/*
 * Decompiled with CFR 0.152.
 */
package com.example.mzy.indicators.Circle;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import com.example.mzy.indicators.IndicatorDrawable;
import java.util.ArrayList;

public class BallScaleIndicator
extends IndicatorDrawable {
    private final String TAG = BallScaleIndicator.class.getSimpleName();
    private final int mCount = 4;
    private float space;
    private float radius;
    private float leftPadding;
    private float[] mAnimatedValue = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public BallScaleIndicator(Context context) {
        Log.d((String)this.TAG, (String)"BallScaleIndicator: ");
        this.init(context);
    }

    @Override
    protected void init(Context context) {
        Log.d((String)this.TAG, (String)"init: ");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(1.0f);
        this.mPaint.setColor(-1);
        this.space = BallScaleIndicator.dip2px(context, 2.0f);
    }

    @Override
    protected ArrayList<ValueAnimator> getAnimation() {
        int[] delay = new int[]{100, 200, 300, 400};
        ArrayList<ValueAnimator> list = new ArrayList<ValueAnimator>();
        for (int i = 0; i < 4; ++i) {
            final int index = i;
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.3f, 1.0f});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    ((BallScaleIndicator)BallScaleIndicator.this).mAnimatedValue[index] = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    BallScaleIndicator.this.invalidateSelf();
                }
            });
            valueAnimator.setRepeatCount(-1);
            valueAnimator.setDuration(1000L);
            valueAnimator.setStartDelay((long)delay[i]);
            list.add(valueAnimator);
        }
        return list;
    }

    @Override
    protected void draw(Canvas canvas, Paint paint) {
        if (this.leftPadding == 0.0f) {
            this.radius = this.getWidth() / 20;
            this.leftPadding = ((float)this.getWidth() - this.radius * 2.0f * 4.0f + this.space * 3.0f) / 2.0f;
        }
        for (int i = 0; i < 4; ++i) {
            canvas.save();
            float translateX = this.leftPadding + this.radius * (float)((i + 1) * 2 - 1) + this.space * (float)i;
            canvas.translate(translateX, (float)(this.getHeight() / 2));
            canvas.scale(this.mAnimatedValue[i], this.mAnimatedValue[i]);
            canvas.drawCircle(0.0f, 0.0f, this.radius, paint);
            canvas.restore();
        }
    }
}

