/*
 * Decompiled with CFR 0.152.
 */
package com.example.dateutil;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentManager;
import android.widget.DatePicker;
import com.example.dateutil.Pickable;
import java.util.Calendar;

public class DatePickerFragment
extends DialogFragment
implements DatePickerDialog.OnDateSetListener {
    private Pickable mPickableInstance;
    private String mSelectedDate = "";
    private boolean mIsSetMinDate = false;
    private long mMinDate = 0L;

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        int month = c.get(2);
        int day = c.get(5);
        DatePickerDialog datePickerDialog = new DatePickerDialog((Context)this.getActivity(), (DatePickerDialog.OnDateSetListener)this, year, month, day);
        if (this.mIsSetMinDate) {
            try {
                if (this.mMinDate > 0L) {
                    datePickerDialog.getDatePicker().setMinDate(this.mMinDate);
                } else {
                    datePickerDialog.getDatePicker().setMinDate(c.getTimeInMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return datePickerDialog;
    }

    public void onDateSet(DatePicker view, int year, int month, int day) {
        this.mSelectedDate = "" + (day < 10 ? "0" + day : Integer.valueOf(day)) + "-" + (month < 10 ? "0" + month : Integer.valueOf(++month)) + "-" + year;
        this.mPickableInstance.onPickerDismissed(this.mSelectedDate);
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        this.mSelectedDate = "";
        this.mPickableInstance.onPickerDismissed(this.mSelectedDate);
    }

    public void show(FragmentManager fragmentManager, String tag, Pickable ctx) {
        this.show(fragmentManager, tag);
        this.mPickableInstance = ctx;
    }

    public void setMinimumDate(long minDate) {
        this.mIsSetMinDate = true;
        this.mMinDate = minDate;
    }
}

