/*
 * Decompiled with CFR 0.152.
 */
package com.example.circleprogress;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.example.circleprogress.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u001c\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\u001b\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0014J\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010#\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\nJ\u0006\u0010$\u001a\u00020\u001aJ\u0006\u0010%\u001a\u00020\u001aJ\u000e\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u0016J\b\u0010(\u001a\u00020\u001aH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/example/circleprogress/CircleProgressBar;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "backgroundPaint", "Landroid/graphics/Paint;", "color", "", "foregroundPaint", "max", "min", "paintCap", "Landroid/graphics/Paint$Cap;", "progress", "rectF", "Landroid/graphics/RectF;", "startAngle", "strokeCap", "strokeWidth", "", "adjustAlpha", "factor", "init", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setColor", "setMax", "setProgress", "setRoundCap", "setSquareCap", "setThickness", "strWidth", "toChangeColor", "circleprogress_release"})
public final class CircleProgressBar
extends View {
    private float strokeWidth = 4.0f;
    private int progress;
    private int min;
    private int max = 100;
    private int strokeCap;
    private Paint.Cap paintCap = Paint.Cap.ROUND;
    private int startAngle = -90;
    private int color = -12303292;
    private RectF rectF;
    private Paint backgroundPaint;
    private Paint foregroundPaint;
    private HashMap _$_findViewCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init(Context context, AttributeSet attrs) {
        this.rectF = new RectF();
        Context context2 = context;
        if (context2 == null) {
            Intrinsics.throwNpe();
        }
        TypedArray typedArray = context2.getTheme().obtainStyledAttributes(attrs, R.styleable.CircleProgressBar, 0, 0);
        try {
            this.strokeWidth = typedArray.getDimension(R.styleable.CircleProgressBar_progressBarThickness, this.strokeWidth);
            this.progress = typedArray.getInt(R.styleable.CircleProgressBar_progress, this.progress);
            this.color = typedArray.getInt(R.styleable.CircleProgressBar_color, this.color);
            this.min = typedArray.getInt(R.styleable.CircleProgressBar_min, this.min);
            this.max = typedArray.getInt(R.styleable.CircleProgressBar_max, this.max);
            this.strokeCap = typedArray.getInt(R.styleable.CircleProgressBar_strokeCap, this.strokeCap);
            this.paintCap = this.strokeCap == 0 ? Paint.Cap.ROUND : Paint.Cap.SQUARE;
        }
        finally {
            typedArray.recycle();
        }
        this.toChangeColor();
    }

    private final int adjustAlpha(int color, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color) * factor);
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = View.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        int width = View.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int min = Math.min(width, height);
        this.setMeasuredDimension(min, min);
        RectF rectF = this.rectF;
        if (rectF == null) {
            Intrinsics.throwNpe();
        }
        rectF.set(0.0f + this.strokeWidth / (float)2, 0.0f + this.strokeWidth / (float)2, (float)min - this.strokeWidth / (float)2, (float)min - this.strokeWidth / (float)2);
    }

    protected void onDraw(@Nullable Canvas canvas) {
        super.onDraw(canvas);
        Canvas canvas2 = canvas;
        if (canvas2 == null) {
            Intrinsics.throwNpe();
        }
        RectF rectF = this.rectF;
        if (rectF == null) {
            Intrinsics.throwNpe();
        }
        Paint paint = this.backgroundPaint;
        if (paint == null) {
            Intrinsics.throwNpe();
        }
        canvas2.drawOval(rectF, paint);
        int angle = 360 * this.progress / this.max;
        RectF rectF2 = this.rectF;
        if (rectF2 == null) {
            Intrinsics.throwNpe();
        }
        float f = this.startAngle;
        float f2 = angle;
        Paint paint2 = this.foregroundPaint;
        if (paint2 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawArc(rectF2, f, f2, false, paint2);
    }

    public final void setProgress(int progress) {
        this.progress = progress;
        this.invalidate();
    }

    public final void setMax(int max) {
        this.max = max;
        this.invalidate();
    }

    public final void setColor(int color) {
        this.color = color;
        Paint paint = this.backgroundPaint;
        if (paint == null) {
            Intrinsics.throwNpe();
        }
        paint.setColor(this.adjustAlpha(color, 0.3f));
        Paint paint2 = this.foregroundPaint;
        if (paint2 == null) {
            Intrinsics.throwNpe();
        }
        paint2.setColor(color);
        this.invalidate();
    }

    private final void toChangeColor() {
        Paint paint = this.backgroundPaint = new Paint(1);
        if (paint == null) {
            Intrinsics.throwNpe();
        }
        paint.setColor(this.adjustAlpha(this.color, 0.3f));
        Paint paint2 = this.backgroundPaint;
        if (paint2 == null) {
            Intrinsics.throwNpe();
        }
        paint2.setStyle(Paint.Style.STROKE);
        Paint paint3 = this.backgroundPaint;
        if (paint3 == null) {
            Intrinsics.throwNpe();
        }
        paint3.setStrokeWidth(this.strokeWidth);
        Paint paint4 = this.foregroundPaint = new Paint(1);
        if (paint4 == null) {
            Intrinsics.throwNpe();
        }
        paint4.setColor(this.color);
        Paint paint5 = this.foregroundPaint;
        if (paint5 == null) {
            Intrinsics.throwNpe();
        }
        paint5.setStyle(Paint.Style.STROKE);
        Paint paint6 = this.foregroundPaint;
        if (paint6 == null) {
            Intrinsics.throwNpe();
        }
        paint6.setStrokeWidth(this.strokeWidth);
        Paint paint7 = this.foregroundPaint;
        if (paint7 == null) {
            Intrinsics.throwNpe();
        }
        paint7.setStrokeCap(this.paintCap);
    }

    public final void setThickness(float strWidth) {
        this.strokeWidth = strWidth;
        Paint paint = this.backgroundPaint;
        if (paint == null) {
            Intrinsics.throwNpe();
        }
        paint.setStrokeWidth(strWidth);
        Paint paint2 = this.foregroundPaint;
        if (paint2 == null) {
            Intrinsics.throwNpe();
        }
        paint2.setStrokeWidth(strWidth);
        this.invalidate();
    }

    public final void setRoundCap() {
        this.paintCap = Paint.Cap.ROUND;
        Paint paint = this.foregroundPaint;
        if (paint == null) {
            Intrinsics.throwNpe();
        }
        paint.setStrokeCap(this.paintCap);
        this.invalidate();
    }

    public final void setSquareCap() {
        this.paintCap = Paint.Cap.SQUARE;
        Paint paint = this.foregroundPaint;
        if (paint == null) {
            Intrinsics.throwNpe();
        }
        paint.setStrokeCap(this.paintCap);
        this.invalidate();
    }

    public CircleProgressBar(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

