/*
 * Decompiled with CFR 0.152.
 */
package com.example.bigpicscrollview.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.example.bigpicscrollview.interfaces.HintView;
import java.util.Map;

public abstract class ShapeHintView
extends LinearLayout
implements HintView {
    private ImageView[] mDots;
    private int length = 0;
    private int lastPosition = 0;
    private int dot_normal;
    private int dot_focus;

    public ShapeHintView(Context context) {
        super(context);
    }

    public ShapeHintView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public abstract Map<String, Integer> setHintViewBG();

    @Override
    public void initView(int length, int gravity, int spacing) {
        this.removeAllViews();
        this.lastPosition = 0;
        this.setOrientation(0);
        switch (gravity) {
            case 0: {
                this.setGravity(19);
                break;
            }
            case 1: {
                this.setGravity(17);
                break;
            }
            case 2: {
                this.setGravity(21);
            }
        }
        this.length = length;
        this.mDots = new ImageView[length];
        Map<String, Integer> map = this.setHintViewBG();
        this.dot_focus = map.get("focusId");
        this.dot_normal = map.get("normalId");
        for (int i = 0; i < length; ++i) {
            this.mDots[i] = new ImageView(this.getContext());
            LinearLayout.LayoutParams dotlp = new LinearLayout.LayoutParams(-2, -2);
            dotlp.setMargins(spacing / 2, 0, spacing / 2, 0);
            this.mDots[i].setLayoutParams((ViewGroup.LayoutParams)dotlp);
            this.mDots[i].setImageResource(this.dot_normal);
            this.addView((View)this.mDots[i]);
        }
        this.setCurrent(0);
    }

    @Override
    public void setCurrent(int current) {
        if (current < 0 || current > this.length - 1) {
            return;
        }
        this.mDots[this.lastPosition].setImageResource(this.dot_normal);
        this.mDots[current].setImageResource(this.dot_focus);
        this.lastPosition = current;
    }
}

