/*
 * Decompiled with CFR 0.152.
 */
package com.example.bigpicscrollview.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import android.widget.Scroller;
import com.example.bigpicscrollview.R;
import com.example.bigpicscrollview.adapter.LoopPagerAdapter;
import com.example.bigpicscrollview.interfaces.HintView;
import com.example.bigpicscrollview.interfaces.HintViewDelegate;
import com.example.bigpicscrollview.interfaces.OnItemClickListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Timer;
import java.util.TimerTask;

public class RollPagerView
extends RelativeLayout
implements ViewPager.OnPageChangeListener {
    private ViewPager mViewPager;
    private PagerAdapter mAdapter;
    private OnItemClickListener mOnItemClickListener;
    private GestureDetector mGestureDetector;
    private long mRecentTouchTime;
    private int delay;
    private int gravity;
    private int color;
    private int alpha;
    private int paddingLeft;
    private int paddingTop;
    private int paddingRight;
    private int paddingBottom;
    private int spacing;
    private View mHintView;
    private Timer timer;
    private HintViewDelegate mHintViewDelegate = new HintViewDelegate(){

        @Override
        public void setCurrentPosition(int position, HintView hintView) {
            if (hintView != null) {
                hintView.setCurrent(position);
            }
        }

        @Override
        public void initView(int length, int gravity, int spacing, HintView hintView) {
            if (hintView != null) {
                hintView.initView(length, gravity, spacing);
            }
        }
    };
    private TimeTaskHandler mHandler = new TimeTaskHandler(this);

    public RollPagerView(Context context) {
        this(context, null);
    }

    public RollPagerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RollPagerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(attrs);
    }

    private void initView(AttributeSet attrs) {
        if (this.mViewPager != null) {
            this.removeView((View)this.mViewPager);
        }
        TypedArray type = this.getContext().obtainStyledAttributes(attrs, R.styleable.RollViewPager);
        this.gravity = type.getInteger(R.styleable.RollViewPager_rollviewpager_hint_gravity, 1);
        this.delay = type.getInt(R.styleable.RollViewPager_rollviewpager_play_delay, 0);
        this.color = type.getColor(R.styleable.RollViewPager_rollviewpager_hint_color, -16777216);
        this.alpha = type.getInt(R.styleable.RollViewPager_rollviewpager_hint_alpha, 0);
        this.paddingLeft = (int)type.getDimension(R.styleable.RollViewPager_rollviewpager_hint_paddingLeft, 0.0f);
        this.paddingRight = (int)type.getDimension(R.styleable.RollViewPager_rollviewpager_hint_paddingRight, 0.0f);
        this.paddingTop = (int)type.getDimension(R.styleable.RollViewPager_rollviewpager_hint_paddingTop, 0.0f);
        this.paddingBottom = (int)type.getDimension(R.styleable.RollViewPager_rollviewpager_hint_paddingBottom, 0.0f);
        this.spacing = (int)type.getDimension(R.styleable.RollViewPager_rollviewpager_hint_spacing, 10.0f);
        this.mViewPager = new ViewPager(this.getContext());
        this.mViewPager.setId(R.id.viewpager_inner);
        this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.addView((View)this.mViewPager);
        type.recycle();
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new SimpleOnGesture());
    }

    private void startPlay() {
        if (this.delay <= 0 || this.mAdapter == null || this.mAdapter.getCount() <= 1) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new WeakTimerTask(this), this.delay, (long)this.delay);
    }

    private void stopPlay() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public RollPagerView setHintViewDelegate(HintViewDelegate delegate) {
        this.mHintViewDelegate = delegate;
        return this;
    }

    private void initHint(HintView hintview) {
        if (this.mHintView != null) {
            this.removeView(this.mHintView);
        }
        if (hintview == null || !(hintview instanceof HintView)) {
            return;
        }
        this.mHintView = (View)hintview;
        this.loadHintView();
    }

    private void loadHintView() {
        this.addView(this.mHintView);
        this.mHintView.setPadding(this.paddingLeft, this.paddingTop, this.paddingRight, this.paddingBottom);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -2);
        lp.addRule(12);
        this.mHintView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.mHintView.setBackgroundColor(this.color);
        this.mHintView.setAlpha((float)this.alpha);
        this.mHintViewDelegate.initView(this.mAdapter == null ? 0 : this.mAdapter.getCount(), this.gravity, this.spacing, (HintView)this.mHintView);
    }

    public RollPagerView setAnimationDurtion(final int during) {
        try {
            Field mField = ViewPager.class.getDeclaredField("mScroller");
            mField.setAccessible(true);
            Scroller mScroller = new Scroller(this.getContext(), new Interpolator(){

                public float getInterpolation(float t) {
                    return (t -= 1.0f) * t * t * t * t + 1.0f;
                }
            }){

                public void startScroll(int startX, int startY, int dx, int dy, int duration) {
                    duration = System.currentTimeMillis() - RollPagerView.this.mRecentTouchTime > (long)RollPagerView.this.delay ? during : (duration /= 2);
                    super.startScroll(startX, startY, dx, dy, duration);
                }

                public void startScroll(int startX, int startY, int dx, int dy) {
                    super.startScroll(startX, startY, dx, dy, during);
                }
            };
            mField.set(this.mViewPager, mScroller);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return this;
    }

    public RollPagerView setPlayDelay(int delay) {
        this.delay = delay;
        this.startPlay();
        return this;
    }

    public void pause() {
        this.stopPlay();
    }

    public void resume() {
        this.startPlay();
    }

    public boolean isPlaying() {
        return this.timer != null;
    }

    public RollPagerView setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
        return this;
    }

    public RollPagerView setHintPadding(int left, int top, int right, int bottom) {
        this.paddingLeft = left;
        this.paddingTop = top;
        this.paddingRight = right;
        this.paddingBottom = bottom;
        this.mHintView.setPadding(this.paddingLeft, this.paddingTop, this.paddingRight, this.paddingBottom);
        return this;
    }

    public RollPagerView setHintSpacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    public RollPagerView setHintAlpha(int alpha) {
        this.alpha = alpha;
        this.initHint((HintView)this.mHintView);
        return this;
    }

    public RollPagerView setHintView(HintView hintview) {
        if (this.mHintView != null) {
            this.removeView(this.mHintView);
        }
        this.mHintView = (View)hintview;
        if (hintview != null && hintview instanceof View) {
            this.initHint(hintview);
        }
        return this;
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public RollPagerView setAdapter(PagerAdapter adapter) {
        this.mViewPager.setAdapter(adapter);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mAdapter = adapter;
        this.dataSetChanged();
        adapter.registerDataSetObserver((DataSetObserver)new JPagerObserver());
        return this;
    }

    private void dataSetChanged() {
        if (this.mHintView != null) {
            this.mHintViewDelegate.initView(this.mAdapter.getCount(), this.gravity, this.spacing, (HintView)this.mHintView);
            this.mHintViewDelegate.setCurrentPosition(this.mViewPager.getCurrentItem(), (HintView)this.mHintView);
        }
        this.startPlay();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.mRecentTouchTime = System.currentTimeMillis();
        this.mGestureDetector.onTouchEvent(ev);
        return super.dispatchTouchEvent(ev);
    }

    public void onPageScrollStateChanged(int arg0) {
    }

    public void onPageScrolled(int arg0, float arg1, int arg2) {
    }

    public void onPageSelected(int arg0) {
        this.mHintViewDelegate.setCurrentPosition(arg0, (HintView)this.mHintView);
    }

    private class JPagerObserver
    extends DataSetObserver {
        private JPagerObserver() {
        }

        public void onChanged() {
            RollPagerView.this.dataSetChanged();
        }

        public void onInvalidated() {
            RollPagerView.this.dataSetChanged();
        }
    }

    private static class WeakTimerTask
    extends TimerTask {
        private WeakReference<RollPagerView> mRollPagerViewWeakReference;

        public WeakTimerTask(RollPagerView mRollPagerView) {
            this.mRollPagerViewWeakReference = new WeakReference<RollPagerView>(mRollPagerView);
        }

        @Override
        public void run() {
            RollPagerView rollPagerView = (RollPagerView)((Object)this.mRollPagerViewWeakReference.get());
            if (rollPagerView != null) {
                if (rollPagerView.isShown() && System.currentTimeMillis() - rollPagerView.mRecentTouchTime > (long)rollPagerView.delay) {
                    rollPagerView.mHandler.sendEmptyMessage(0);
                }
            } else {
                this.cancel();
            }
        }
    }

    private static final class TimeTaskHandler
    extends Handler {
        private WeakReference<RollPagerView> mRollPagerViewWeakReference;

        public TimeTaskHandler(RollPagerView rollPagerView) {
            this.mRollPagerViewWeakReference = new WeakReference<RollPagerView>(rollPagerView);
        }

        public void handleMessage(Message msg) {
            RollPagerView rollPagerView = (RollPagerView)((Object)this.mRollPagerViewWeakReference.get());
            int cur = rollPagerView.getViewPager().getCurrentItem() + 1;
            if (cur >= rollPagerView.mAdapter.getCount()) {
                cur = 0;
            }
            rollPagerView.getViewPager().setCurrentItem(cur);
            rollPagerView.mHintViewDelegate.setCurrentPosition(cur, (HintView)rollPagerView.mHintView);
            if (rollPagerView.mAdapter.getCount() <= 1) {
                rollPagerView.stopPlay();
            }
        }
    }

    private class SimpleOnGesture
    extends GestureDetector.SimpleOnGestureListener {
        private SimpleOnGesture() {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            if (RollPagerView.this.mOnItemClickListener != null) {
                if (RollPagerView.this.mAdapter instanceof LoopPagerAdapter) {
                    RollPagerView.this.mOnItemClickListener.onItemClick(RollPagerView.this.mViewPager.getCurrentItem() % ((LoopPagerAdapter)RollPagerView.this.mAdapter).getRealCount());
                } else {
                    RollPagerView.this.mOnItemClickListener.onItemClick(RollPagerView.this.mViewPager.getCurrentItem());
                }
            }
            return super.onSingleTapUp(e);
        }
    }
}

