/*
 * Decompiled with CFR 0.152.
 */
package com.example.asus.mylibrary.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.FloatMath;

public class BitmapUtils {
    private static final String TAG = "BitmapUtils";

    public static Bitmap getSampledBitmap(String filePath, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            inSampleSize = width > height ? (int)FloatMath.floor((float)((float)height / (float)reqHeight + 0.5f)) : (int)FloatMath.floor((float)((float)width / (float)reqWidth + 0.5f));
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
    }

    public static BitmapSize getBitmapSize(String filePath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        return new BitmapSize(options.outWidth, options.outHeight);
    }

    public static BitmapSize getScaledSize(int originalWidth, int originalHeight, int numPixels) {
        float ratio = (float)originalWidth / (float)originalHeight;
        int scaledHeight = (int)FloatMath.sqrt((float)((float)numPixels / ratio));
        int scaledWidth = (int)(ratio * FloatMath.sqrt((float)((float)numPixels / ratio)));
        return new BitmapSize(scaledWidth, scaledHeight);
    }

    public static class BitmapSize {
        public int width;
        public int height;

        public BitmapSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

