/*
 * Decompiled with CFR 0.152.
 */
package com.example.asus.mylibrary;

import android.graphics.Bitmap;

public class PhotoProcessing {
    private static final String TAG = "PhotoProcessing";

    public static Bitmap filterPhoto(Bitmap bitmap, int position) {
        if (bitmap != null) {
            PhotoProcessing.sendBitmapToNative(bitmap);
        }
        switch (position) {
            case 0: {
                break;
            }
            case 1: {
                PhotoProcessing.nativeApplyInstafix();
                break;
            }
            case 2: {
                PhotoProcessing.nativeApplyAnsel();
                break;
            }
            case 3: {
                PhotoProcessing.nativeApplyTestino();
                break;
            }
            case 4: {
                PhotoProcessing.nativeApplyXPro();
                break;
            }
            case 5: {
                PhotoProcessing.nativeApplyRetro();
                break;
            }
            case 6: {
                PhotoProcessing.nativeApplyBW();
                break;
            }
            case 7: {
                PhotoProcessing.nativeApplySepia();
                break;
            }
            case 8: {
                PhotoProcessing.nativeApplyCyano();
                break;
            }
            case 9: {
                PhotoProcessing.nativeApplyGeorgia();
                break;
            }
            case 10: {
                PhotoProcessing.nativeApplySahara();
                break;
            }
            case 11: {
                PhotoProcessing.nativeApplyHDR();
            }
        }
        Bitmap filteredBitmap = PhotoProcessing.getBitmapFromNative(bitmap);
        PhotoProcessing.nativeDeleteBitmap();
        return filteredBitmap;
    }

    public static Bitmap applyEditAction(Bitmap bitmap, int position) {
        switch (position) {
            case 0: {
                bitmap = PhotoProcessing.flipHorizontally(bitmap);
                break;
            }
            case 1: {
                bitmap = PhotoProcessing.rotate(bitmap, 90);
                break;
            }
            case 2: {
                bitmap = PhotoProcessing.rotate(bitmap, 270);
                break;
            }
            case 3: {
                bitmap = PhotoProcessing.rotate(bitmap, 180);
            }
        }
        return bitmap;
    }

    public static native int nativeInitBitmap(int var0, int var1);

    public static native void nativeGetBitmapRow(int var0, int[] var1);

    public static native void nativeSetBitmapRow(int var0, int[] var1);

    public static native int nativeGetBitmapWidth();

    public static native int nativeGetBitmapHeight();

    public static native void nativeDeleteBitmap();

    public static native int nativeRotate90();

    public static native void nativeRotate180();

    public static native void nativeFlipHorizontally();

    public static native void nativeApplyInstafix();

    public static native void nativeApplyAnsel();

    public static native void nativeApplyTestino();

    public static native void nativeApplyXPro();

    public static native void nativeApplyRetro();

    public static native void nativeApplyBW();

    public static native void nativeApplySepia();

    public static native void nativeApplyCyano();

    public static native void nativeApplyGeorgia();

    public static native void nativeApplySahara();

    public static native void nativeApplyHDR();

    public static native void nativeLoadResizedJpegBitmap(byte[] var0, int var1, int var2);

    public static native void nativeResizeBitmap(int var0, int var1);

    public static void sendBitmapToNative(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        PhotoProcessing.nativeInitBitmap(width, height);
        int[] pixels = new int[width];
        for (int y = 0; y < height; ++y) {
            bitmap.getPixels(pixels, 0, width, 0, y, width, 1);
            PhotoProcessing.nativeSetBitmapRow(y, pixels);
        }
    }

    public static Bitmap getBitmapFromNative(Bitmap bitmap) {
        int width = PhotoProcessing.nativeGetBitmapWidth();
        int height = PhotoProcessing.nativeGetBitmapHeight();
        if (bitmap == null || width != bitmap.getWidth() || height != bitmap.getHeight() || !bitmap.isMutable()) {
            Bitmap.Config config = Bitmap.Config.ARGB_8888;
            if (bitmap != null) {
                config = bitmap.getConfig();
                bitmap.recycle();
            }
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        }
        int[] pixels = new int[width];
        for (int y = 0; y < height; ++y) {
            PhotoProcessing.nativeGetBitmapRow(y, pixels);
            bitmap.setPixels(pixels, 0, width, 0, y, width, 1);
        }
        return bitmap;
    }

    public static Bitmap makeBitmapMutable(Bitmap bitmap) {
        PhotoProcessing.sendBitmapToNative(bitmap);
        return PhotoProcessing.getBitmapFromNative(bitmap);
    }

    public static Bitmap rotate(Bitmap bitmap, int angle) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Bitmap.Config config = bitmap.getConfig();
        PhotoProcessing.nativeInitBitmap(width, height);
        PhotoProcessing.sendBitmapToNative(bitmap);
        if (angle == 90) {
            PhotoProcessing.nativeRotate90();
            bitmap.recycle();
            bitmap = Bitmap.createBitmap((int)height, (int)width, (Bitmap.Config)config);
            bitmap = PhotoProcessing.getBitmapFromNative(bitmap);
            PhotoProcessing.nativeDeleteBitmap();
        } else if (angle == 180) {
            PhotoProcessing.nativeRotate180();
            bitmap.recycle();
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            bitmap = PhotoProcessing.getBitmapFromNative(bitmap);
            PhotoProcessing.nativeDeleteBitmap();
        } else if (angle == 270) {
            PhotoProcessing.nativeRotate180();
            PhotoProcessing.nativeRotate90();
            bitmap.recycle();
            bitmap = Bitmap.createBitmap((int)height, (int)width, (Bitmap.Config)config);
            bitmap = PhotoProcessing.getBitmapFromNative(bitmap);
            PhotoProcessing.nativeDeleteBitmap();
        }
        return bitmap;
    }

    public static Bitmap flipHorizontally(Bitmap bitmap) {
        PhotoProcessing.nativeInitBitmap(bitmap.getWidth(), bitmap.getHeight());
        PhotoProcessing.sendBitmapToNative(bitmap);
        PhotoProcessing.nativeFlipHorizontally();
        bitmap = PhotoProcessing.getBitmapFromNative(bitmap);
        PhotoProcessing.nativeDeleteBitmap();
        return bitmap;
    }

    static {
        System.loadLibrary("photoprocessing");
    }
}

