/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.sdk.domain.usecases.Impl;

import com.eway.payment.sdk.data.beans.CodeDetail;
import com.eway.payment.sdk.data.entities.CodeLookupResponse;
import com.eway.payment.sdk.data.entities.UserMessageResponse;
import com.eway.payment.sdk.data.repository.RapidDataRepository;
import com.eway.payment.sdk.data.repository.sourcedata.RapidDataFactory;
import com.eway.payment.sdk.data.util.RequestBuilder;
import com.eway.payment.sdk.domain.repository.RapidRepository;
import com.eway.payment.sdk.domain.usecases.RxUseCase;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import org.reactivestreams.Publisher;

public class rxUserMessageUseCase
extends RxUseCase<UserMessageResponse> {
    private String language;
    private RapidRepository rapidRepository;
    private String ErrorCodes;

    public rxUserMessageUseCase(String language, String ErrorCodes) {
        this.language = language;
        this.ErrorCodes = ErrorCodes;
        this.rapidRepository = new RapidDataRepository(new RapidDataFactory());
    }

    @Override
    protected Flowable<UserMessageResponse> buildUseCaseObservable() {
        return this.rapidRepository.rxUserMessage(RequestBuilder.buildCodeLookUpRequest(this.language, this.ErrorCodes)).flatMap((Function)new Function<CodeLookupResponse, Publisher<UserMessageResponse>>(){

            public Publisher<UserMessageResponse> apply(final CodeLookupResponse codeLookupResponse) throws Exception {
                return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<UserMessageResponse>(){

                    public void subscribe(FlowableEmitter<UserMessageResponse> e) throws Exception {
                        ArrayList<String> errorMessages = new ArrayList<String>();
                        for (CodeDetail codeDetail : codeLookupResponse.getCodeDetails()) {
                            errorMessages.add(codeDetail.getDisplayMessage());
                        }
                        e.onNext((Object)new UserMessageResponse(errorMessages, null));
                    }
                }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
            }
        });
    }
}

