/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.sdk.domain.usecases.Impl;

import com.eway.payment.sdk.data.beans.CodeDetail;
import com.eway.payment.sdk.data.entities.CodeLookupResponse;
import com.eway.payment.sdk.data.entities.UserMessageResponse;
import com.eway.payment.sdk.data.repository.RapidDataRepository;
import com.eway.payment.sdk.data.repository.sourcedata.RapidDataFactory;
import com.eway.payment.sdk.data.util.RequestBuilder;
import com.eway.payment.sdk.domain.repository.RapidRepository;
import com.eway.payment.sdk.domain.usecases.AbsUserMessageUseCase;
import java.io.IOException;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Response;

public class UserMessageUseCase
extends AbsUserMessageUseCase {
    private String language;
    private RapidRepository rapidRepository;
    private String ErrorCodes;
    private ArrayList<String> errorMessages = new ArrayList();

    public UserMessageUseCase(String language, String errorCodes) {
        this.language = language;
        this.rapidRepository = new RapidDataRepository(new RapidDataFactory());
        this.ErrorCodes = errorCodes;
    }

    @Override
    protected UserMessageResponse buildUseCase() {
        Call<CodeLookupResponse> responseCall = this.rapidRepository.userMessage(RequestBuilder.buildCodeLookUpRequest(this.language, this.ErrorCodes));
        try {
            Response response = responseCall.execute();
            for (CodeDetail codeDetail : ((CodeLookupResponse)response.body()).getCodeDetails()) {
                this.errorMessages.add(codeDetail.getDisplayMessage());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new UserMessageResponse(this.errorMessages, null);
    }
}

