/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.sdk.data.net;

import com.eway.payment.sdk.data.entities.RapidConfigurationException;
import com.eway.payment.sdk.data.net.RapidRestApi;
import com.eway.payment.sdk.data.net.socket.OkhttpBuilderForTLS;
import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class RapidRestAdapter {
    public static String RapidEndpoint;
    public static String PublicAPIKey;
    private static final String VERSIONREPORTED = "1.2.2";
    private static final String PRODUCTION_URL = "https://api.ewaypayments.com";
    private static final String SANDBOX_URL = "https://api.sandbox.ewaypayments.com";
    private static final String DEV_URL = " http://dev.eway.com.au";
    private static final String PRODUCTION = "production";
    private static final String SANDBOX = "sandbox";
    private static final String DEVELOPMENT = "dev";
    private static final String ANDROIDPAY_PRODUCTION = "aprapid";
    private static final String ANDROIDPAY_PRODUCTION_URL = "https://api.ewaypayments.com/aprapid/";
    private static final String ANDROIDPAY_SANDBOX_STAGING = "staging-androidpay";
    private static final String ANDRIODPAY_SANDBOX_URL = "https://api.sandbox.ewaypayments.com/staging-androidpay/";

    public static RapidRestApi callPost() throws RapidConfigurationException, KeyManagementException, NoSuchAlgorithmException {
        String baseUrl = RapidRestAdapter.filterUrl(RapidEndpoint);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(RapidRestAdapter.getEwayClient()).build();
        RapidRestApi adapter = (RapidRestApi)retrofit.create(RapidRestApi.class);
        return adapter;
    }

    public static RapidRestApi rxCallPost() throws RapidConfigurationException, KeyManagementException, NoSuchAlgorithmException {
        String baseUrl = RapidRestAdapter.filterUrl(RapidEndpoint);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(RapidRestAdapter.getEwayClient()).build();
        RapidRestApi adapter = (RapidRestApi)retrofit.create(RapidRestApi.class);
        return adapter;
    }

    private static OkHttpClient getEwayClient() throws RapidConfigurationException, NoSuchAlgorithmException, KeyManagementException {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient.Builder okHttpClient = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                String credential = Credentials.basic((String)PublicAPIKey, (String)"");
                Request.Builder requestBuilder = originalRequest.newBuilder().header("Authorization", credential).header("User-Agent", ";eWAY SDK Android 1.2.2").method(originalRequest.method(), originalRequest.body());
                Request request = requestBuilder.build();
                return chain.proceed(request);
            }
        }).addInterceptor((Interceptor)loggingInterceptor);
        return OkhttpBuilderForTLS.enableTls12OnPreLollipop(okHttpClient).connectTimeout(3L, TimeUnit.MINUTES).readTimeout(3L, TimeUnit.MINUTES).build();
    }

    private static String filterUrl(String url) throws RapidConfigurationException {
        RapidRestAdapter.errorCheck();
        String baseUrl = url;
        if (baseUrl.contains(PRODUCTION)) {
            baseUrl = baseUrl.contains(ANDROIDPAY_PRODUCTION) ? ANDROIDPAY_PRODUCTION_URL : PRODUCTION_URL;
        } else if (baseUrl.contains(SANDBOX)) {
            baseUrl = baseUrl.contains(ANDROIDPAY_SANDBOX_STAGING) ? ANDRIODPAY_SANDBOX_URL : SANDBOX_URL;
        } else if (baseUrl.contains(DEVELOPMENT)) {
            baseUrl = DEV_URL;
        }
        return baseUrl;
    }

    private static void errorCheck() throws RapidConfigurationException {
        if (PublicAPIKey == null || PublicAPIKey.isEmpty()) {
            throw new RapidConfigurationException(new String[]{"S9991"});
        }
        if (RapidEndpoint == null || RapidEndpoint.isEmpty()) {
            throw new RapidConfigurationException(new String[]{"S9990"});
        }
        String urlPattern = "^http(s{0,1})://[a-zA-Z0-9_/\\-\\.]+\\.([A-Za-z/]{2,5})[a-zA-Z0-9_/\\&\\?\\=\\-\\.\\~\\%]*";
        if (!RapidEndpoint.matches(urlPattern)) {
            throw new RapidConfigurationException(new String[]{"S9992"});
        }
    }
}

