package com.eway.payment.sdk.domain.usecases;


import org.reactivestreams.Publisher;

import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import com.eway.payment.sdk.domain.exception.Error;
import com.eway.payment.sdk.domain.executor.IOThread;
import com.eway.payment.sdk.domain.executor.PostExecutionThread;
import com.eway.payment.sdk.domain.executor.ThreadIOExecutor;
import com.eway.payment.sdk.domain.executor.UIThread;


/**
 * Created by alexanderparra on 9/11/16.
 */

public abstract class RxUseCase<T> {

    private PostExecutionThread postExecutionThread;
    private ThreadIOExecutor threadIOExecutor;

    public RxUseCase() {
        threadIOExecutor = new IOThread();
        postExecutionThread = new UIThread();

    }

    public Flowable<T> rxExecute(){

        return this.buildUseCaseObservable()
                 .subscribeOn(threadIOExecutor.SchedulerIO())
                 .onErrorResumeNext(Error.<T>errorToken())
                 .observeOn(postExecutionThread.scheduler());

    }


    protected abstract Flowable<T> buildUseCaseObservable();

}
