package com.eway.payment.sdk.domain.usecases.Impl;

import io.reactivex.Flowable;
import com.eway.payment.sdk.data.beans.Transaction;
import com.eway.payment.sdk.data.entities.SubmitPayResponse;
import com.eway.payment.sdk.data.repository.RapidDataRepository;
import com.eway.payment.sdk.data.repository.sourcedata.RapidDataFactory;
import com.eway.payment.sdk.domain.repository.RapidRepository;
import com.eway.payment.sdk.domain.usecases.RxUseCase;

import static com.eway.payment.sdk.data.util.RequestBuilder.buildSubmitRequest;


/**
 * Created by alexanderparra on 13/11/16.
 */

public class rxSubmitPaymentUseCase extends RxUseCase<SubmitPayResponse> {

    private Transaction transaction;
    private RapidRepository rapidRepository;


    public rxSubmitPaymentUseCase(Transaction transaction) {
        rapidRepository = new RapidDataRepository(new RapidDataFactory());
        this.transaction = transaction;
    }

    @Override
    protected Flowable<SubmitPayResponse> buildUseCaseObservable() {
        return rapidRepository.rxSubmitPayment(buildSubmitRequest(transaction));
    }


}
