package com.eway.payment.sdk.domain.usecases.Impl;

import java.util.ArrayList;

import io.reactivex.Flowable;
import io.reactivex.Observable;
import com.eway.payment.sdk.data.beans.NVPair;
import com.eway.payment.sdk.data.entities.EncryptItemsResponse;
import com.eway.payment.sdk.data.repository.RapidDataRepository;
import com.eway.payment.sdk.data.repository.sourcedata.RapidDataFactory;
import com.eway.payment.sdk.domain.repository.RapidRepository;
import com.eway.payment.sdk.domain.usecases.RxUseCase;

import static com.eway.payment.sdk.data.util.RequestBuilder.buildEncryptValues;

/**
 * Created by alexanderparra on 13/11/16.
 */

public class rxEncryptValuesUseCase extends RxUseCase<EncryptItemsResponse> {

    private RapidRepository rapidRepository;
    private static ArrayList<NVPair> values;


    public rxEncryptValuesUseCase(){

        rapidRepository = new RapidDataRepository(new RapidDataFactory());

    }

    public static void setValues(ArrayList<NVPair> values){
        rxEncryptValuesUseCase.values = values;
    }


    @Override
    protected Flowable<EncryptItemsResponse> buildUseCaseObservable() {
        return rapidRepository.rxEmpcryptValues(buildEncryptValues(rxEncryptValuesUseCase.values));
    }
}
