package com.eway.payment.sdk.domain.usecases.Impl;

import java.io.IOException;
import java.util.ArrayList;

import retrofit2.Call;
import retrofit2.Response;
import com.eway.payment.sdk.data.beans.CodeDetail;
import com.eway.payment.sdk.data.entities.CodeLookupResponse;
import com.eway.payment.sdk.data.entities.UserMessageResponse;
import com.eway.payment.sdk.data.repository.RapidDataRepository;
import com.eway.payment.sdk.data.repository.sourcedata.RapidDataFactory;
import com.eway.payment.sdk.domain.repository.RapidRepository;
import com.eway.payment.sdk.domain.usecases.AbsUserMessageUseCase;

import static com.eway.payment.sdk.data.util.RequestBuilder.buildCodeLookUpRequest;

/**
 * Created by alexanderparra on 25/11/16.
 */

public class UserMessageUseCase extends AbsUserMessageUseCase {

    private String language;
    private RapidRepository rapidRepository;
    private String ErrorCodes;
    private ArrayList<String> errorMessages = new ArrayList<>();



    public UserMessageUseCase(String language, String errorCodes) {
        this.language = language;
        rapidRepository = new RapidDataRepository(new RapidDataFactory());
        ErrorCodes = errorCodes;
    }

    @Override
    protected UserMessageResponse buildUseCase() {

        Call<CodeLookupResponse> responseCall = rapidRepository.userMessage(buildCodeLookUpRequest(language,ErrorCodes));
        try {
            Response<CodeLookupResponse> response = responseCall.execute();

            for (CodeDetail codeDetail : response.body().getCodeDetails()) {
                errorMessages.add(codeDetail.getDisplayMessage());
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return new UserMessageResponse(errorMessages,null);
    }
}
