package com.eway.payment.sdk.domain.usecases.Impl;

import retrofit2.Call;
import com.eway.payment.sdk.data.beans.Transaction;
import com.eway.payment.sdk.data.entities.SubmitPayResponse;
import com.eway.payment.sdk.data.repository.RapidDataRepository;
import com.eway.payment.sdk.data.repository.sourcedata.RapidDataFactory;
import com.eway.payment.sdk.domain.repository.RapidRepository;
import com.eway.payment.sdk.domain.usecases.UseCase;

import static com.eway.payment.sdk.data.util.RequestBuilder.buildSubmitRequest;

/**
 * Created by alexanderparra on 18/11/16.
 */

public class SubmitPaymentUseCase extends UseCase<SubmitPayResponse> {

    private Transaction transaction;
    private RapidRepository rapidRepository;

    public SubmitPaymentUseCase(Transaction transaction) {
        this.rapidRepository = new RapidDataRepository(new RapidDataFactory());
        this.transaction = transaction;

    }

    @Override
    protected Call<SubmitPayResponse> buildUseCase() {
        return this.rapidRepository.SubmitPayment(buildSubmitRequest(transaction));
    }


}
