package com.eway.payment.sdk.domain.usecases.Impl;

import retrofit2.Call;
import com.eway.payment.sdk.data.beans.Transaction;
import com.eway.payment.sdk.data.entities.SubmitPayResponse;
import com.eway.payment.sdk.data.repository.RapidDataRepository;
import com.eway.payment.sdk.data.repository.sourcedata.RapidDataFactory;
import com.eway.payment.sdk.domain.repository.RapidRepository;
import com.eway.payment.sdk.domain.usecases.UseCase;

import static com.eway.payment.sdk.data.util.RequestBuilder.buildAndroidPaySubmitRequest;

/**
 * Created by alexanderparra on 6/12/16.
 */

public class AndroidPayUseCase extends UseCase<SubmitPayResponse> {

    private Transaction transaction;
    private RapidRepository rapidRepository;

    public AndroidPayUseCase(Transaction transaction) {
        this.transaction = transaction;
        this.rapidRepository = new RapidDataRepository(new RapidDataFactory());
    }

    @Override
    protected Call<SubmitPayResponse> buildUseCase() {
        return rapidRepository.androidPay(buildAndroidPaySubmitRequest(transaction));
    }
}
