package com.eway.payment.sdk.domain.repository;


import io.reactivex.Flowable;
import io.reactivex.Observable;
import retrofit2.Call;
import com.eway.payment.sdk.data.beans.Transaction;
import com.eway.payment.sdk.data.entities.CodeLookupRequest;
import com.eway.payment.sdk.data.entities.CodeLookupResponse;
import com.eway.payment.sdk.data.entities.EncryptItemsResponse;
import com.eway.payment.sdk.data.entities.EncryptValuesRequest;
import com.eway.payment.sdk.data.entities.SubmitPayResponse;
import com.eway.payment.sdk.data.entities.SubmitPaymentRequest;
import com.eway.payment.sdk.data.entities.UserMessageResponse;

/**
 * Created by alexanderparra on 9/11/16.
 */

public interface RapidRepository {

    Call<SubmitPayResponse> SubmitPayment(SubmitPaymentRequest request);

    Flowable<SubmitPayResponse> rxSubmitPayment(SubmitPaymentRequest request);

    Flowable<EncryptItemsResponse> rxEmpcryptValues(EncryptValuesRequest request);

    Call<EncryptItemsResponse> EmpcryptValues(EncryptValuesRequest request);

    Flowable<CodeLookupResponse> rxUserMessage(CodeLookupRequest request);

    Call<CodeLookupResponse> userMessage(CodeLookupRequest request);

    Call<SubmitPayResponse> androidPay(SubmitPaymentRequest request);

}
