package com.eway.payment.sdk.data.repository.sourcedata;

import io.reactivex.Flowable;
import io.reactivex.Observable;
import retrofit2.Call;
import com.eway.payment.sdk.data.beans.Transaction;
import com.eway.payment.sdk.data.entities.CodeLookupRequest;
import com.eway.payment.sdk.data.entities.CodeLookupResponse;
import com.eway.payment.sdk.data.entities.EncryptItemsResponse;
import com.eway.payment.sdk.data.entities.EncryptValuesRequest;
import com.eway.payment.sdk.data.entities.SubmitPayResponse;
import com.eway.payment.sdk.data.entities.SubmitPaymentRequest;
import com.eway.payment.sdk.data.entities.UserMessageResponse;

/**
 * Created by alexanderparra on 10/11/16.
 */

public interface RapidNetData {

    Flowable<SubmitPayResponse> rxSubmitPayment(SubmitPaymentRequest request);

    Call<SubmitPayResponse> SubmitResponse(SubmitPaymentRequest request);

    Flowable<EncryptItemsResponse> rxEncryptValues(EncryptValuesRequest request);

    Call<EncryptItemsResponse> EncryptValues(EncryptValuesRequest request);

    Flowable<CodeLookupResponse> rxUserMessage(CodeLookupRequest request);

    Call<CodeLookupResponse> UserMessage(CodeLookupRequest request);

    Call<SubmitPayResponse> androidPay(SubmitPaymentRequest request);

}
