package com.eway.payment.sdk.data.repository;



import io.reactivex.Flowable;
import retrofit2.Call;
import com.eway.payment.sdk.data.entities.CodeLookupRequest;
import com.eway.payment.sdk.data.entities.CodeLookupResponse;
import com.eway.payment.sdk.data.entities.EncryptItemsResponse;
import com.eway.payment.sdk.data.entities.EncryptValuesRequest;
import com.eway.payment.sdk.data.entities.SubmitPayResponse;
import com.eway.payment.sdk.data.entities.SubmitPaymentRequest;
import com.eway.payment.sdk.data.repository.sourcedata.RapidDataFactory;
import com.eway.payment.sdk.domain.repository.RapidRepository;

/**
 * Created by alexanderparra on 9/11/16.
 */

public class RapidDataRepository implements RapidRepository {

    private RapidDataFactory rapidDataFactory;


    public RapidDataRepository(RapidDataFactory rapidDataFactory) {
        this.rapidDataFactory = rapidDataFactory;
    }

    @Override
    public Call<SubmitPayResponse>SubmitPayment(SubmitPaymentRequest request) {
        return this.rapidDataFactory.createDataSource().SubmitResponse(request);
    }


    @Override
    public Flowable<SubmitPayResponse> rxSubmitPayment(SubmitPaymentRequest request) {
        return this.rapidDataFactory.createDataSource().rxSubmitPayment(request);
    }

    @Override
    public Flowable<EncryptItemsResponse> rxEmpcryptValues(EncryptValuesRequest request) {
        return this.rapidDataFactory.createDataSource().rxEncryptValues(request);
    }

    @Override
    public Call<EncryptItemsResponse> EmpcryptValues(EncryptValuesRequest request) {
        return this.rapidDataFactory.createDataSource().EncryptValues(request);
    }

    @Override
    public Flowable<CodeLookupResponse> rxUserMessage(CodeLookupRequest request) {
        return this.rapidDataFactory.createDataSource().rxUserMessage(request);
    }

    @Override
    public Call<CodeLookupResponse> userMessage(CodeLookupRequest request) {
        return this.rapidDataFactory.createDataSource().UserMessage(request);
    }

    @Override
    public Call<SubmitPayResponse> androidPay(SubmitPaymentRequest request) {
        return this.rapidDataFactory.createDataSource().androidPay(request);
    }

}
