package com.eway.payment.sdk.data.net;

import io.reactivex.Observable;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Headers;
import retrofit2.http.POST;

import com.eway.payment.sdk.data.entities.CodeLookupRequest;
import com.eway.payment.sdk.data.entities.CodeLookupResponse;
import com.eway.payment.sdk.data.entities.EncryptItemsResponse;
import com.eway.payment.sdk.data.entities.EncryptValuesRequest;
import com.eway.payment.sdk.data.entities.SubmitPayResponse;
import com.eway.payment.sdk.data.entities.SubmitPaymentRequest;

/**
 * Created by alexanderparra on 9/11/16.
 */

public interface RapidRestApi {

    // Asynchronous or synchronous api
    @Headers("Content-Type: application/json")
    @POST("/payment")
    Call<SubmitPayResponse> submitPayment(@Body SubmitPaymentRequest request);

    @Headers("Content-Type: application/json")
    @POST("/payment")
    Observable<SubmitPayResponse> rxObsSubmitPayment(@Body SubmitPaymentRequest request);

    @Headers("Content-Type: application/json")
    @POST("/encrypt")
    Call<EncryptItemsResponse> encryptValues(@Body EncryptValuesRequest request);

    @Headers("Content-Type: application/json")
    @POST("/encrypt")
    Observable<EncryptItemsResponse> rxObsEncryptValues(@Body EncryptValuesRequest request);

    @Headers("Content-Type: application/json")
    @POST("/codelookup")
    Call<CodeLookupResponse> codeLookUp(@Body CodeLookupRequest request);

    @Headers("Content-Type: application/json")
    @POST("/codelookup")
    Observable<CodeLookupResponse> rxCodeLookUp(@Body CodeLookupRequest request);

    @Headers("Content-Type: application/json")
    @POST("payment")
    Call<SubmitPayResponse> androidPaySubmitPayment(@Body SubmitPaymentRequest request);
}
