/*
 * Decompiled with CFR 0.152.
 */
package com.evolveasia.aws;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferObserver;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtility;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.evolveasia.aws.AwsMetaInfo;
import com.evolveasia.initializer.ContextProviderImpl;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\t\u001a\u00020\n2\u0016\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/evolveasia/aws/Util;", "", "()V", "sCredProvider", "Lcom/amazonaws/auth/CognitoCachingCredentialsProvider;", "sS3Client", "Lcom/amazonaws/services/s3/AmazonS3Client;", "sTransferUtility", "Lcom/amazonaws/mobileconnectors/s3/transferutility/TransferUtility;", "fillMap", "", "map", "", "", "observer", "Lcom/amazonaws/mobileconnectors/s3/transferutility/TransferObserver;", "isChecked", "", "getBytesString", "bytes", "", "getCredProvider", "awsMetaInfo", "Lcom/evolveasia/aws/AwsMetaInfo$AWSConfig;", "getS3Client", "getTransferUtility", "Lcom/evolveasia/aws/AwsMetaInfo;", "isNetworkAvailable", "context", "Landroid/content/Context;", "gcloud-storage-utils_release"})
public final class Util {
    private static AmazonS3Client sS3Client;
    private static CognitoCachingCredentialsProvider sCredProvider;
    private static TransferUtility sTransferUtility;
    public static final Util INSTANCE;

    private final CognitoCachingCredentialsProvider getCredProvider(AwsMetaInfo.AWSConfig awsMetaInfo) {
        if (sCredProvider == null) {
            sCredProvider = new CognitoCachingCredentialsProvider(ContextProviderImpl.Companion.getInstance().getAppCtx(), awsMetaInfo.getCognitoPoolId(), Regions.fromName((String)awsMetaInfo.getRegion()));
        }
        return sCredProvider;
    }

    @NotNull
    public final AmazonS3Client getS3Client(@NotNull AwsMetaInfo.AWSConfig awsMetaInfo) {
        Intrinsics.checkParameterIsNotNull((Object)awsMetaInfo, (String)"awsMetaInfo");
        if (sS3Client == null) {
            sS3Client = new AmazonS3Client((AWSCredentialsProvider)this.getCredProvider(awsMetaInfo), Region.getRegion((String)awsMetaInfo.getRegion()));
        }
        AmazonS3Client amazonS3Client = sS3Client;
        if (amazonS3Client == null) {
            Intrinsics.throwNpe();
        }
        return amazonS3Client;
    }

    @JvmStatic
    @Nullable
    public static final TransferUtility getTransferUtility(@NotNull AwsMetaInfo awsMetaInfo) {
        Intrinsics.checkParameterIsNotNull((Object)awsMetaInfo, (String)"awsMetaInfo");
        if (sTransferUtility == null) {
            sTransferUtility = TransferUtility.builder().context(ContextProviderImpl.Companion.getInstance().getAppCtx()).s3Client((AmazonS3)INSTANCE.getS3Client(awsMetaInfo.getServiceConfig())).awsConfiguration(new AWSConfiguration(awsMetaInfo.getServiceConfig().getAwsConfiguration())).build();
        }
        return sTransferUtility;
    }

    private final String getBytesString(long bytes) {
        String[] quantifiers = new String[]{"KB", "MB", "GB", "TB"};
        double speedNum = bytes;
        int i = 0;
        while (i < quantifiers.length) {
            if ((speedNum /= 1024.0) < (double)512) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "%.2f";
                Object[] objectArray = new Object[]{speedNum};
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                return stringBuilder.append(string3).append(" ").append(quantifiers[i]).toString();
            }
            ++i;
        }
        return "";
    }

    public final void fillMap(@NotNull Map<String, Object> map, @NotNull TransferObserver observer, boolean isChecked) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        int progress = (int)((double)observer.getBytesTransferred() * (double)100 / (double)observer.getBytesTotal());
        map.put("id", observer.getId());
        map.put("checked", isChecked);
        map.put("fileName", observer.getAbsoluteFilePath());
        map.put("progress", progress);
        map.put("bytes", this.getBytesString(observer.getBytesTransferred()) + "/" + this.getBytesString(observer.getBytesTotal()));
        map.put("state", observer.getState());
        map.put("percentage", "" + progress + '%');
    }

    @JvmStatic
    public static final boolean isNetworkAvailable(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        if (connectivityManager == null) {
            return false;
        }
        ConnectivityManager cm = connectivityManager;
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }

    private Util() {
    }

    static {
        Util util;
        INSTANCE = util = new Util();
    }
}

