/*
 * Decompiled with CFR 0.152.
 */
package com.evolveasia.aws;

import com.amazonaws.mobileconnectors.s3.transferutility.TransferListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferObserver;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtility;
import com.evolveasia.aws.AwsMetaInfo;
import com.evolveasia.aws.TransferUpdate;
import com.evolveasia.aws.Util;
import com.evolveasia.initializer.ContextProviderImpl;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.atomic.AtomicBoolean;

public class TransferObservable
extends Observable<TransferUpdate> {
    public static final long FILE_SIZE_UNLIMITED = Long.MAX_VALUE;
    private final AwsMetaInfo awsMetaInfo;
    private final TransferUtility transferUtility;
    private final String filePath;
    private final String uploadPath;
    private final long maxSizeInBytes;

    public TransferObservable(AwsMetaInfo awsMetaInfo, String filePath, String uploadPath) {
        this(awsMetaInfo, filePath, uploadPath, Long.MAX_VALUE);
    }

    public TransferObservable(AwsMetaInfo awsMetaInfo, String filePath, String uploadPath, long maxSizeInBytes) {
        this.awsMetaInfo = awsMetaInfo;
        this.transferUtility = Util.getTransferUtility(awsMetaInfo);
        this.filePath = filePath;
        this.uploadPath = uploadPath;
        this.maxSizeInBytes = maxSizeInBytes;
    }

    protected void subscribeActual(Observer<? super TransferUpdate> observer) {
        File file = new File(this.filePath);
        if (!file.exists()) {
            observer.onError((Throwable)new FileNotFoundException());
        } else if (this.maxSizeInBytes < file.length()) {
            observer.onError((Throwable)new Exception("file size(" + file.length() + "bytes) is greater than max filesize(" + this.maxSizeInBytes + ")"));
        } else if (!Util.isNetworkAvailable(ContextProviderImpl.Companion.getInstance().getAppCtx())) {
            observer.onError((Throwable)new Exception("Check your internet connection"));
        } else {
            String fileName = file.getName();
            TransferObserver transferObserver = this.transferUtility.upload(this.awsMetaInfo.getServiceConfig().getBucketName(), this.uploadPath, file);
            Listener listener = new Listener(observer, transferObserver, fileName, this.uploadPath);
            observer.onSubscribe((Disposable)listener);
            transferObserver.setTransferListener((TransferListener)listener);
        }
    }

    private static String buildAmazonS3Url(String uploadPath, String filename) {
        return uploadPath;
    }

    private static final class Listener
    implements TransferListener,
    Disposable {
        private final Observer<? super TransferUpdate> observer;
        private final TransferObserver transferObserver;
        private final String fileName;
        private final String uploadPath;
        private final AtomicBoolean unsubscribed = new AtomicBoolean();

        Listener(Observer<? super TransferUpdate> observer, TransferObserver transferObserver, String fileName, String uploadPath) {
            this.observer = observer;
            this.transferObserver = transferObserver;
            this.fileName = fileName;
            this.uploadPath = uploadPath;
        }

        public void onStateChanged(int id, TransferState state) {
            if (!this.isDisposed()) {
                if (state.equals((Object)TransferState.COMPLETED)) {
                    this.observer.onNext((Object)new TransferUpdate(1, id, state, -1L, -1L, TransferObservable.buildAmazonS3Url(this.uploadPath, this.fileName)));
                    this.observer.onComplete();
                } else if (state.equals((Object)TransferState.FAILED)) {
                    this.observer.onError((Throwable)new Exception("Transfer Failed"));
                }
            }
        }

        public void onProgressChanged(int id, long bytesCurrent, long bytesTotal) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)new TransferUpdate(2, id, null, bytesCurrent, bytesTotal, null));
            }
        }

        public void onError(int id, Exception ex) {
            if (!this.isDisposed()) {
                this.observer.onError((Throwable)ex);
            }
        }

        public void dispose() {
            if (this.unsubscribed.compareAndSet(false, true)) {
                this.transferObserver.cleanTransferListener();
            }
        }

        public boolean isDisposed() {
            return this.unsubscribed.get();
        }
    }
}

