/*
 * Decompiled with CFR 0.152.
 */
package com.evolveasia.gCloudStorageUtils;

import android.graphics.Bitmap;
import com.evolveasia.ImageUploadHelperKt;
import com.evolveasia.gCloudStorageUtils.ApiModule;
import com.evolveasia.gCloudStorageUtils.Constants;
import com.evolveasia.gCloudStorageUtils.CountingRequestBody;
import com.evolveasia.gCloudStorageUtils.GCSMetaInfo;
import com.evolveasia.gCloudStorageUtils.StorageObjectBaseResponse;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Credentials;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Single;
import io.reactivex.functions.Consumer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010\u001a\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001a\u001c\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0019"}, d2={"compressImage", "", "gcsMetaInfo", "Lcom/evolveasia/gCloudStorageUtils/GCSMetaInfo;", "createCountingRequestBody", "Lokhttp3/RequestBody;", "file", "Ljava/io/File;", "emitter", "Lio/reactivex/FlowableEmitter;", "", "createRequestBody", "fetchImage", "Lio/reactivex/Single;", "Lcom/evolveasia/gCloudStorageUtils/StorageObjectBaseResponse;", "bucketName", "", "serviceConfig", "Ljava/io/InputStream;", "query", "getAuthCredentials", "Lcom/google/auth/oauth2/OAuth2Credentials;", "getMetaDataRequestBody", "uploadImageGCS", "Lio/reactivex/Flowable;", "gcloud-storage-utils_release"})
public final class CloudUtilsKt {
    @NotNull
    public static final OAuth2Credentials getAuthCredentials(@Nullable InputStream serviceConfig) {
        GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)serviceConfig).createScoped((Collection)Collections.singleton("https://www.googleapis.com/auth/devstorage.full_control"));
        boolean bl = false;
        boolean bl2 = false;
        GoogleCredentials $this$apply = googleCredentials;
        boolean bl3 = false;
        $this$apply.refresh();
        GoogleCredentials googleCredentials2 = googleCredentials;
        Intrinsics.checkExpressionValueIsNotNull((Object)googleCredentials2, (String)"GoogleCredentials.fromSt\u2026     .apply { refresh() }");
        return (OAuth2Credentials)googleCredentials2;
    }

    @NotNull
    public static final RequestBody getMetaDataRequestBody(@NotNull GCSMetaInfo gcsMetaInfo, @NotNull FlowableEmitter<Double> emitter) {
        Intrinsics.checkParameterIsNotNull((Object)gcsMetaInfo, (String)"gcsMetaInfo");
        Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        $this$apply.put("name", (Object)gcsMetaInfo.getGcsStoragePath());
        CharSequence charSequence = gcsMetaInfo.getImageMetaInfo().getMetadata();
        boolean bl4 = false;
        if (!(charSequence.length() == 0)) {
            $this$apply.put("metadata", (Object)gcsMetaInfo.getImageMetaInfo().getMetadata());
        }
        JSONObject jsonParams = jSONObject;
        MultipartBody multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addPart(RequestBody.create((MediaType)Constants.INSTANCE.getTYPE_JSON(), (String)jsonParams.toString())).addPart(RequestBody.create((MediaType)MediaType.parse((String)gcsMetaInfo.getImageMetaInfo().getMediaType()), (byte[])gcsMetaInfo.getImageMetaInfo().getImageByteArray())).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)multipartBody, (String)"MultipartBody.Builder()\n\u2026ay))\n            .build()");
        return (RequestBody)multipartBody;
    }

    private static final RequestBody createCountingRequestBody(File file, FlowableEmitter<Double> emitter) {
        RequestBody requestBody = CloudUtilsKt.createRequestBody(file);
        String string = "create couting req body";
        boolean bl = false;
        System.out.println((Object)string);
        string = "image file name --> " + file.getAbsolutePath();
        bl = false;
        System.out.print((Object)string);
        return new CountingRequestBody(requestBody, (Function2<? super Long, ? super Long, Unit>)((Function2)new Function2<Long, Long, Unit>(emitter){
            final /* synthetic */ FlowableEmitter $emitter;

            public final void invoke(long bytesWritten, long contentLength) {
                double progress = 1.0 * (double)bytesWritten / (double)contentLength;
                String string = "prog: " + progress;
                boolean bl = false;
                System.out.println((Object)string);
                this.$emitter.onNext((Object)progress);
            }
            {
                this.$emitter = flowableEmitter;
                super(2);
            }
        }));
    }

    private static final RequestBody createRequestBody(File file) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)GCSMetaInfo.ImageMetaInfo.Companion.getTYPE_JPEG()), (File)file);
        Intrinsics.checkExpressionValueIsNotNull((Object)requestBody, (String)"RequestBody.create(Media\u2026etaInfo.TYPE_JPEG), file)");
        return requestBody;
    }

    @NotNull
    public static final Flowable<Double> uploadImageGCS(@NotNull GCSMetaInfo gcsMetaInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gcsMetaInfo, (String)"gcsMetaInfo");
        Flowable flowable = Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<T>(gcsMetaInfo){
            final /* synthetic */ GCSMetaInfo $gcsMetaInfo;

            public final void subscribe(@NotNull FlowableEmitter<Double> emitter) {
                Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                this.$gcsMetaInfo.getImageMetaInfo().setImageByteArray(CloudUtilsKt.compressImage(this.$gcsMetaInfo));
                RequestBody params = CloudUtilsKt.getMetaDataRequestBody(this.$gcsMetaInfo, emitter);
                ApiModule.Companion.provideApiService(this.$gcsMetaInfo.getServiceConfig()).uploadImageToGCS(this.$gcsMetaInfo.getBucketName(), params).subscribe((Consumer)new Consumer<ResponseBody>(emitter){
                    final /* synthetic */ FlowableEmitter $emitter;

                    public final void accept(ResponseBody it) {
                        this.$emitter.onComplete();
                    }
                    {
                        this.$emitter = flowableEmitter;
                    }
                }, (Consumer)new Consumer<Throwable>(emitter){
                    final /* synthetic */ FlowableEmitter $emitter;

                    public final void accept(Throwable it) {
                        this.$emitter.onError(it);
                    }
                    {
                        this.$emitter = flowableEmitter;
                    }
                });
            }
            {
                this.$gcsMetaInfo = gCSMetaInfo;
            }
        }, (BackpressureStrategy)BackpressureStrategy.LATEST);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"Flowable.create({ emitte\u2026kpressureStrategy.LATEST)");
        return flowable;
    }

    @NotNull
    public static final byte[] compressImage(@NotNull GCSMetaInfo gcsMetaInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gcsMetaInfo, (String)"gcsMetaInfo");
        byte[] byteArray = ImageUploadHelperKt.streamToByteArray(new FileInputStream(gcsMetaInfo.getImageMetaInfo().getImagePath()));
        Integer n = gcsMetaInfo.getImageMetaInfo().getImageWidth();
        Integer n2 = gcsMetaInfo.getImageMetaInfo().getImageHeight();
        Bitmap bitmap = ImageUploadHelperKt.decodeSampledBitmapFromResource(byteArray, n != null ? n : 500, n2 != null ? n2 : 500, gcsMetaInfo.getImageMetaInfo().getWaterMarkInfo());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(gcsMetaInfo.getImageMetaInfo().getCompressFormat(), gcsMetaInfo.getImageMetaInfo().getCompressLevel(), (OutputStream)stream);
        byte[] byArray = stream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"stream.toByteArray()");
        return byArray;
    }

    @NotNull
    public static final Single<StorageObjectBaseResponse> fetchImage(@NotNull String bucketName, @NotNull InputStream serviceConfig, @NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)bucketName, (String)"bucketName");
        Intrinsics.checkParameterIsNotNull((Object)serviceConfig, (String)"serviceConfig");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        return ApiModule.Companion.provideApiService(serviceConfig).fetchImage(bucketName, query);
    }
}

