/*
 * Decompiled with CFR 0.152.
 */
package com.evolveasia.aws;

import android.content.Context;
import android.net.Uri;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferObserver;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtility;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.evolveasia.aws.AwsMetaInfo;
import com.evolveasia.initializer.ContextProviderImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;

public class Util {
    private static AmazonS3Client sS3Client;
    private static CognitoCachingCredentialsProvider sCredProvider;
    private static TransferUtility sTransferUtility;

    private static CognitoCachingCredentialsProvider getCredProvider(AwsMetaInfo awsMetaInfo) {
        if (sCredProvider == null) {
            sCredProvider = new CognitoCachingCredentialsProvider(ContextProviderImpl.Companion.getInstance().getAppCtx(), awsMetaInfo.getServiceConfig().getCognitoPoolId(), Regions.fromName((String)awsMetaInfo.getServiceConfig().getRegion()));
        }
        return sCredProvider;
    }

    public static AmazonS3Client getS3Client(AwsMetaInfo awsMetaInfo) {
        if (sS3Client == null) {
            sS3Client = new AmazonS3Client((AWSCredentialsProvider)Util.getCredProvider(awsMetaInfo), Region.getRegion((String)awsMetaInfo.getServiceConfig().getRegion()));
        }
        return sS3Client;
    }

    public static TransferUtility getTransferUtility(AwsMetaInfo awsMetaInfo) {
        if (sTransferUtility == null) {
            sTransferUtility = TransferUtility.builder().context(ContextProviderImpl.Companion.getInstance().getAppCtx()).s3Client((AmazonS3)Util.getS3Client(awsMetaInfo)).awsConfiguration(new AWSConfiguration(awsMetaInfo.getServiceConfig().getAwsConfiguration())).build();
        }
        return sTransferUtility;
    }

    public static String getBytesString(long bytes) {
        String[] quantifiers = new String[]{"KB", "MB", "GB", "TB"};
        double speedNum = bytes;
        int i = 0;
        while (i < quantifiers.length) {
            if ((speedNum /= 1024.0) < 512.0) {
                return String.format("%.2f", speedNum) + " " + quantifiers[i];
            }
            ++i;
        }
        return "";
    }

    public static File copyContentUriToFile(Context context, Uri uri) throws IOException {
        InputStream is = context.getContentResolver().openInputStream(uri);
        File copiedData = new File(context.getDir("SampleImagesDir", 0), UUID.randomUUID().toString());
        copiedData.createNewFile();
        FileOutputStream fos = new FileOutputStream(copiedData);
        byte[] buf = new byte[2046];
        int read = -1;
        while ((read = is.read(buf)) != -1) {
            fos.write(buf, 0, read);
        }
        fos.flush();
        fos.close();
        return copiedData;
    }

    public static void fillMap(Map<String, Object> map, TransferObserver observer, boolean isChecked) {
        int progress = (int)((double)observer.getBytesTransferred() * 100.0 / (double)observer.getBytesTotal());
        map.put("id", observer.getId());
        map.put("checked", isChecked);
        map.put("fileName", observer.getAbsoluteFilePath());
        map.put("progress", progress);
        map.put("bytes", Util.getBytesString(observer.getBytesTransferred()) + "/" + Util.getBytesString(observer.getBytesTotal()));
        map.put("state", observer.getState());
        map.put("percentage", progress + "%");
    }
}

