/*
 * Decompiled with CFR 0.152.
 */
package com.evolveasia.aws;

import android.graphics.Bitmap;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.evolveasia.ImageUploadHelperKt;
import com.evolveasia.aws.AWSUtilsKt;
import com.evolveasia.aws.AwsMetaInfo;
import com.evolveasia.aws.TransferObservable;
import com.evolveasia.aws.TransferUpdate;
import com.evolveasia.aws.Util;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Single;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a*\u0010\u0000\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004\u001a\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\f0\u00012\u0006\u0010\r\u001a\u00020\u0004\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u0004\u001a\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u0016"}, d2={"amazonUploadSingle", "Lio/reactivex/Single;", "Lcom/evolveasia/aws/TransferUpdate;", "awsMetaInfo", "Lcom/evolveasia/aws/AwsMetaInfo;", "uploadPath", "", "maxFileSize", "", "compressAwsImage", "gcsMetaInfo", "fetchImage", "", "serviceConfig", "getImageFromS3Buckets", "getObjectList", "Lcom/amazonaws/services/s3/model/ObjectListing;", "objectListing", "s3", "Lcom/amazonaws/services/s3/AmazonS3Client;", "uploadImageAWS", "Lio/reactivex/Flowable;", "gcloud-storage-utils_release"})
public final class AWSUtilsKt {
    @NotNull
    public static final Flowable<String> uploadImageAWS(@NotNull AwsMetaInfo gcsMetaInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gcsMetaInfo, (String)"gcsMetaInfo");
        Flowable flowable = Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<T>(gcsMetaInfo){
            final /* synthetic */ AwsMetaInfo $gcsMetaInfo;

            public final void subscribe(@NotNull FlowableEmitter<String> emitter) {
                block0: {
                    Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                    this.$gcsMetaInfo.getImageMetaInfo().setImagePath(AWSUtilsKt.compressAwsImage(this.$gcsMetaInfo));
                    Single single = AWSUtilsKt.amazonUploadSingle(this.$gcsMetaInfo, this.$gcsMetaInfo.getAwsFolerPath());
                    if (single == null || (single = single.subscribeOn(Schedulers.io())) == null || (single = single.observeOn(AndroidSchedulers.mainThread())) == null) break block0;
                    single.subscribe((Consumer)new Consumer<TransferUpdate>(emitter){
                        final /* synthetic */ FlowableEmitter $emitter;

                        public final void accept(@Nullable TransferUpdate it) {
                            this.$emitter.onComplete();
                        }
                        {
                            this.$emitter = flowableEmitter;
                        }
                    }, (Consumer)new Consumer<Throwable>(emitter){
                        final /* synthetic */ FlowableEmitter $emitter;

                        public final void accept(Throwable it) {
                            this.$emitter.onError(it);
                        }
                        {
                            this.$emitter = flowableEmitter;
                        }
                    });
                }
            }
            {
                this.$gcsMetaInfo = awsMetaInfo;
            }
        }, (BackpressureStrategy)BackpressureStrategy.LATEST);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"Flowable.create({ emitte\u2026kpressureStrategy.LATEST)");
        return flowable;
    }

    @Nullable
    public static final Single<TransferUpdate> amazonUploadSingle(@NotNull AwsMetaInfo awsMetaInfo, @Nullable String uploadPath, long maxFileSize) {
        Intrinsics.checkParameterIsNotNull((Object)awsMetaInfo, (String)"awsMetaInfo");
        return new TransferObservable(awsMetaInfo, awsMetaInfo.getImageMetaInfo().getImagePath(), uploadPath, maxFileSize).doOnNext(amazonUploadSingle.1.INSTANCE).lastOrError().observeOn(Schedulers.io());
    }

    @Nullable
    public static final Single<TransferUpdate> amazonUploadSingle(@NotNull AwsMetaInfo awsMetaInfo, @Nullable String uploadPath) {
        Intrinsics.checkParameterIsNotNull((Object)awsMetaInfo, (String)"awsMetaInfo");
        return AWSUtilsKt.amazonUploadSingle(awsMetaInfo, uploadPath, Long.MAX_VALUE);
    }

    @NotNull
    public static final String compressAwsImage(@NotNull AwsMetaInfo gcsMetaInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gcsMetaInfo, (String)"gcsMetaInfo");
        byte[] byteArray = ImageUploadHelperKt.streamToByteArray(new FileInputStream(gcsMetaInfo.getImageMetaInfo().getImagePath()));
        Integer n = gcsMetaInfo.getImageMetaInfo().getImageWidth();
        Integer n2 = gcsMetaInfo.getImageMetaInfo().getImageHeight();
        Bitmap bitmap = ImageUploadHelperKt.decodeSampledBitmapFromResource(byteArray, n != null ? n : 500, n2 != null ? n2 : 500, gcsMetaInfo.getImageMetaInfo().getWaterMarkInfo());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(gcsMetaInfo.getImageMetaInfo().getCompressFormat(), gcsMetaInfo.getImageMetaInfo().getCompressLevel(), (OutputStream)stream);
        try {
            OutputStream os = new FileOutputStream(gcsMetaInfo.getImageMetaInfo().getImagePath());
            os.write(stream.toByteArray());
            os.close();
        }
        catch (Exception e) {
            String string = "Exception: " + e;
            boolean bl = false;
            System.out.println((Object)string);
            gcsMetaInfo.getImageMetaInfo().getImagePath();
        }
        return gcsMetaInfo.getImageMetaInfo().getImagePath();
    }

    @NotNull
    public static final Single<List<String>> fetchImage(@NotNull AwsMetaInfo serviceConfig) {
        Intrinsics.checkParameterIsNotNull((Object)serviceConfig, (String)"serviceConfig");
        Single single = Single.fromCallable((Callable)new Callable<T>(serviceConfig){
            final /* synthetic */ AwsMetaInfo $serviceConfig;

            @NotNull
            public final List<String> call() {
                return AWSUtilsKt.getImageFromS3Buckets(this.$serviceConfig);
            }
            {
                this.$serviceConfig = awsMetaInfo;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.fromCallable {\n  \u2026kets(serviceConfig)\n    }");
        return single;
    }

    @NotNull
    public static final List<String> getImageFromS3Buckets(@NotNull AwsMetaInfo serviceConfig) {
        Object object;
        S3ObjectSummary it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        ObjectListing objectList;
        Intrinsics.checkParameterIsNotNull((Object)serviceConfig, (String)"serviceConfig");
        AmazonS3Client s3 = Util.getS3Client(serviceConfig);
        ObjectListing objectListing = objectList = s3.listObjects(serviceConfig.getBucketName());
        Intrinsics.checkExpressionValueIsNotNull((Object)objectListing, (String)"objectList");
        List list = objectListing.getObjectSummaries();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"objectList.objectSummaries");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            S3ObjectSummary s3ObjectSummary = (S3ObjectSummary)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = serviceConfig.getBucketName();
            void v3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            object = s3.getUrl(string, v3.getKey()).toString();
            collection.add(object);
        }
        List list2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        while (true) {
            ObjectListing objectListing2 = objectList;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectListing2, (String)"objectList");
            if (objectListing2.isTruncated()) break;
            AmazonS3Client amazonS3Client = s3;
            Intrinsics.checkExpressionValueIsNotNull((Object)amazonS3Client, (String)"s3");
            objectList = AWSUtilsKt.getObjectList(objectList, amazonS3Client);
            List list3 = objectList.getObjectSummaries();
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"objectList.objectSummaries");
            $this$map$iv = list3;
            collection = list2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (S3ObjectSummary)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                String string = serviceConfig.getBucketName();
                S3ObjectSummary s3ObjectSummary = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)s3ObjectSummary, (String)"it");
                String string2 = s3.getUrl(string, s3ObjectSummary.getKey()).toString();
                object.add(string2);
            }
            object = (List)destination$iv$iv;
            collection.addAll((Collection)object);
        }
        return list2;
    }

    @NotNull
    public static final ObjectListing getObjectList(@NotNull ObjectListing objectListing, @NotNull AmazonS3Client s3) {
        Intrinsics.checkParameterIsNotNull((Object)objectListing, (String)"objectListing");
        Intrinsics.checkParameterIsNotNull((Object)s3, (String)"s3");
        ObjectListing objectListing2 = s3.listNextBatchOfObjects(objectListing);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectListing2, (String)"s3.listNextBatchOfObjects(objectListing)");
        return objectListing2;
    }
}

