/*
 * Decompiled with CFR 0.152.
 */
package com.evolveasia.aws;

import android.graphics.Bitmap;
import com.evolveasia.ImageUploadHelperKt;
import com.evolveasia.aws.AWSUtilsKt;
import com.evolveasia.aws.AwsMetaInfo;
import com.evolveasia.aws.TransferObservable;
import com.evolveasia.aws.TransferUpdate;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Single;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a*\u0010\u0000\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\r"}, d2={"amazonUploadSingle", "Lio/reactivex/Single;", "Lcom/evolveasia/aws/TransferUpdate;", "awsMetaInfo", "Lcom/evolveasia/aws/AwsMetaInfo;", "uploadPath", "", "maxFileSize", "", "compressAwsImage", "gcsMetaInfo", "uploadImageAWS", "Lio/reactivex/Flowable;", "gcloud-storage-utils_release"})
public final class AWSUtilsKt {
    @NotNull
    public static final Flowable<String> uploadImageAWS(@NotNull AwsMetaInfo gcsMetaInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gcsMetaInfo, (String)"gcsMetaInfo");
        Flowable flowable = Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<T>(gcsMetaInfo){
            final /* synthetic */ AwsMetaInfo $gcsMetaInfo;

            public final void subscribe(@NotNull FlowableEmitter<String> emitter) {
                block0: {
                    Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                    this.$gcsMetaInfo.getImageMetaInfo().setImagePath(AWSUtilsKt.compressAwsImage(this.$gcsMetaInfo));
                    Single single = AWSUtilsKt.amazonUploadSingle(this.$gcsMetaInfo, this.$gcsMetaInfo.getAwsFolerPath());
                    if (single == null || (single = single.subscribeOn(Schedulers.io())) == null || (single = single.observeOn(AndroidSchedulers.mainThread())) == null) break block0;
                    single.subscribe((Consumer)new Consumer<TransferUpdate>(emitter){
                        final /* synthetic */ FlowableEmitter $emitter;

                        public final void accept(@Nullable TransferUpdate it) {
                            this.$emitter.onComplete();
                        }
                        {
                            this.$emitter = flowableEmitter;
                        }
                    }, (Consumer)new Consumer<Throwable>(emitter){
                        final /* synthetic */ FlowableEmitter $emitter;

                        public final void accept(Throwable it) {
                            this.$emitter.onError(it);
                        }
                        {
                            this.$emitter = flowableEmitter;
                        }
                    });
                }
            }
            {
                this.$gcsMetaInfo = awsMetaInfo;
            }
        }, (BackpressureStrategy)BackpressureStrategy.LATEST);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"Flowable.create({ emitte\u2026kpressureStrategy.LATEST)");
        return flowable;
    }

    @Nullable
    public static final Single<TransferUpdate> amazonUploadSingle(@NotNull AwsMetaInfo awsMetaInfo, @Nullable String uploadPath, long maxFileSize) {
        Intrinsics.checkParameterIsNotNull((Object)awsMetaInfo, (String)"awsMetaInfo");
        return new TransferObservable(awsMetaInfo, awsMetaInfo.getImageMetaInfo().getImagePath(), uploadPath, maxFileSize).doOnNext(amazonUploadSingle.1.INSTANCE).lastOrError().observeOn(Schedulers.io());
    }

    @Nullable
    public static final Single<TransferUpdate> amazonUploadSingle(@NotNull AwsMetaInfo awsMetaInfo, @Nullable String uploadPath) {
        Intrinsics.checkParameterIsNotNull((Object)awsMetaInfo, (String)"awsMetaInfo");
        return AWSUtilsKt.amazonUploadSingle(awsMetaInfo, uploadPath, Long.MAX_VALUE);
    }

    @NotNull
    public static final String compressAwsImage(@NotNull AwsMetaInfo gcsMetaInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gcsMetaInfo, (String)"gcsMetaInfo");
        byte[] byteArray = ImageUploadHelperKt.streamToByteArray(new FileInputStream(gcsMetaInfo.getImageMetaInfo().getImagePath()));
        Integer n = gcsMetaInfo.getImageMetaInfo().getImageWidth();
        Integer n2 = gcsMetaInfo.getImageMetaInfo().getImageHeight();
        Bitmap bitmap = ImageUploadHelperKt.decodeSampledBitmapFromResource(byteArray, n != null ? n : 500, n2 != null ? n2 : 500, gcsMetaInfo.getImageMetaInfo().getWaterMarkInfo());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(gcsMetaInfo.getImageMetaInfo().getCompressFormat(), gcsMetaInfo.getImageMetaInfo().getCompressLevel(), (OutputStream)stream);
        try {
            OutputStream os = new FileOutputStream(gcsMetaInfo.getImageMetaInfo().getImagePath());
            os.write(stream.toByteArray());
            os.close();
        }
        catch (Exception e) {
            String string = "Exception: " + e;
            boolean bl = false;
            System.out.println((Object)string);
            gcsMetaInfo.getImageMetaInfo().getImagePath();
        }
        return gcsMetaInfo.getImageMetaInfo().getImagePath();
    }
}

