package com.evolveasia.gCloudStorageUtils

import android.util.Log
import com.google.api.client.util.IOUtils
import okhttp3.Interceptor
import okhttp3.Response
import okhttp3.ResponseBody
import java.io.ByteArrayOutputStream
import java.io.IOException
import java.io.InputStream
import java.io.StringWriter

class ApiInterceptor(val serviceConfig: InputStream) : Interceptor {

    override fun intercept(chain: Interceptor.Chain): Response {
        val writer = ByteArrayOutputStream()
        IOUtils.copy(serviceConfig, writer)
        Log.e("Lib:service-config-->>>", writer.toString())
        println("Lib:service-config-->>> $writer.toString()")
        val token = "Bearer " + getAuthCredentials(serviceConfig).accessToken.tokenValue
        println("Lib:token --->+ $token")

        val multipartRelated = "multipart/related; boundary=__XX__"
        val requestBuilder = chain.request().newBuilder()
        requestBuilder.apply {
            addHeader("Authorization", token)
            addHeader("Content-Type", multipartRelated)
        }

        val response = chain.proceed(requestBuilder.build())
        val responseBody = response.body()
        val responseString = responseBody?.string()

        val contentType = responseBody?.contentType()
        return response.newBuilder().body(ResponseBody.create(contentType, responseString!!)).build()


    }

}