package com.evolveasia.gCloudStorageUtils

import com.evolveasia.cloudutil_lib.BuildConfig
import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import retrofit2.Retrofit
import java.util.concurrent.TimeUnit

class ApiModule {

    companion object {

        private fun provideOkHttpClient(gcsMetaInfo: GCSMetaInfo): OkHttpClient {
            val interceptor = HttpLoggingInterceptor()
            interceptor.level = if (BuildConfig.DEBUG) HttpLoggingInterceptor.Level.NONE else HttpLoggingInterceptor.Level.NONE
            return OkHttpClient.Builder()
                    .apply {
                        addInterceptor(ApiInterceptor(gcsMetaInfo))
                        addInterceptor(interceptor)
                        readTimeout(120, TimeUnit.SECONDS)
                        writeTimeout(120, TimeUnit.SECONDS)
                    }.build()
        }

        fun provideApiService(gcsMetaInfo: GCSMetaInfo): UploadService {
            val retrofit = Retrofit.Builder()
                    .baseUrl(Constants.BASE_URL)
                    .client(provideOkHttpClient(gcsMetaInfo))
                    .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                    .build()

            return retrofit.create(UploadService::class.java)
        }
    }
}


