package com.evolveasia.gCloudStorageUtils

import android.graphics.Bitmap
import android.graphics.BitmapFactory
import com.evolveasia.gCloudStorageUtils.GCSMetaInfo
import io.reactivex.BackpressureStrategy
import io.reactivex.Flowable
import org.json.JSONObject
import java.io.ByteArrayOutputStream
import java.io.IOException
import java.io.InputStream
import java.util.*
import javax.annotation.Nullable



@Throws(IOException::class)
fun streamToByteArray(stream: InputStream): ByteArray {

    val buffer = ByteArray(1024)
    val os = ByteArrayOutputStream()

    var line = 0
    // read bytes from stream, and store them in buffer
    while (line != -1) {
        // Writes bytes from byte array (buffer) into output stream.
        os.write(buffer, 0, line)
        line = stream.read(buffer)
    }
    stream.close()
    os.flush()
    os.close()
    return os.toByteArray()
}


fun decodeSampledBitmapFromResource(data: ByteArray,
                                    reqWidth: Int,
                                    reqHeight: Int): Bitmap {

    // First decode with inJustDecodeBounds=true to check dimensions
    val options = BitmapFactory.Options()
    options.inJustDecodeBounds = true
    BitmapFactory.decodeByteArray(data, 0, data.size, options)

    // Calculate inSampleSize
    options.inSampleSize = calculateInSampleSize(options, reqWidth, reqHeight)

    // Decode bitmap with inSampleSize set
    options.inJustDecodeBounds = false
    return BitmapFactory.decodeByteArray(data, 0, data.size, options)
}

fun calculateInSampleSize(options: BitmapFactory.Options, reqWidth: Int, reqHeight: Int): Int {
    // Raw height and width of image
    val height = options.outHeight
    val width = options.outWidth
    var inSampleSize = 1

    if (height > reqHeight || width > reqWidth) {

        val halfHeight = height / 2
        val halfWidth = width / 2

        // Calculate the largest inSampleSize value that is a power of 2 and keeps both
        // height and width larger than the requested height and width.
        while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
            inSampleSize *= 2
        }
    }

    return inSampleSize
}
