/*
 * Decompiled with CFR 0.152.
 */
package com.evgeniysharafan.utils.picasso;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import com.squareup.picasso.Transformation;

public class CircleTransformation
implements Transformation {
    private final int borderColor;
    private final int borderSize;
    private String key;

    public CircleTransformation(int borderColor, int borderSize) {
        this.borderColor = borderColor;
        this.borderSize = borderSize;
        this.key = "circle(color=" + borderColor + ", size=" + borderSize + ")";
    }

    public Bitmap transform(Bitmap source) {
        Bitmap.Config config;
        int y;
        int size = Math.min(source.getWidth(), source.getHeight());
        int x = (source.getWidth() - size) / 2;
        Bitmap squaredBitmap = Bitmap.createBitmap((Bitmap)source, (int)x, (int)(y = (source.getHeight() - size) / 2), (int)size, (int)size);
        if (squaredBitmap != source) {
            source.recycle();
        }
        if ((config = source.getConfig()) == null) {
            config = Bitmap.Config.ARGB_8888;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        BitmapShader shader = new BitmapShader(squaredBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        paint.setShader((Shader)shader);
        paint.setAntiAlias(true);
        float r = (float)size / 2.0f;
        if (this.borderSize > 0) {
            Paint bg = new Paint();
            bg.setColor(this.borderColor);
            bg.setAntiAlias(true);
            canvas.drawCircle(r, r, r, bg);
        }
        canvas.drawCircle(r, r, r - (float)this.borderSize, paint);
        squaredBitmap.recycle();
        return bitmap;
    }

    public String key() {
        return this.key;
    }
}

