/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.state;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;

public class StateProcessor
extends AbstractProcessor {
    private static final Map<String, String> TYPE_MAPPING = new HashMap<String, String>(){
        {
            this.put("boolean", "Boolean");
            this.put("boolean[]", "BooleanArray");
            this.put("java.lang.Boolean", "BoxedBoolean");
            this.put("byte", "Byte");
            this.put("byte[]", "ByteArray");
            this.put("java.lang.Byte", "BoxedByte");
            this.put("char", "Char");
            this.put("char[]", "CharArray");
            this.put("java.lang.Character", "BoxedChar");
            this.put("double", "Double");
            this.put("double[]", "DoubleArray");
            this.put("java.lang.Double", "BoxedDouble");
            this.put("float", "Float");
            this.put("float[]", "FloatArray");
            this.put("java.lang.Float", "BoxedFloat");
            this.put("int", "Int");
            this.put("int[]", "IntArray");
            this.put("java.lang.Integer", "BoxedInt");
            this.put("long", "Long");
            this.put("long[]", "LongArray");
            this.put("java.lang.Long", "BoxedLong");
            this.put("short", "Short");
            this.put("short[]", "ShortArray");
            this.put("java.lang.Short", "BoxedShort");
            this.put("java.lang.CharSequence", "CharSequence");
            this.put("java.lang.CharSequence[]", "CharSequenceArray");
            this.put("java.lang.String", "String");
            this.put("java.lang.String[]", "StringArray");
            this.put("java.util.ArrayList<java.lang.CharSequence>", "CharSequenceArrayList");
            this.put("java.util.ArrayList<java.lang.Integer>", "IntegerArrayList");
            this.put("java.util.ArrayList<java.lang.String>", "StringArrayList");
            this.put(StateProcessor.BUNDLE_CLASS_NAME, "Bundle");
            this.put(StateProcessor.PARCELABLE_ARRAY_CLASS_NAME, "ParcelableArray");
        }
    };
    private static final Comparator<Element> COMPARATOR = new Comparator<Element>(){

        @Override
        public int compare(Element o1, Element o2) {
            return o1.getSimpleName().toString().compareTo(o2.getSimpleName().toString());
        }
    };
    static final String STATE_SAVER_SUFFIX = "$$StateSaver";
    private static final String STATE_CLASS_NAME = "com.evernote.android.state.State";
    private static final String STATE_REFLECTION_CLASS_NAME = "com.evernote.android.state.StateReflection";
    private static final String INJECTOR_VIEW_CLASS_NAME = "com.evernote.android.state.Injector.View";
    private static final String INJECTOR_OBJECT_CLASS_NAME = "com.evernote.android.state.Injector.Object";
    private static final String INJECTION_HELPER_CLASS_NAME = "com.evernote.android.state.InjectionHelper";
    private static final String OBJECT_CLASS_NAME = Object.class.getName();
    private static final String PARCELABLE_CLASS_NAME = "android.os.Parcelable";
    private static final String PARCELABLE_ARRAY_CLASS_NAME = "android.os.Parcelable[]";
    private static final String BUNDLE_CLASS_NAME = "android.os.Bundle";
    private static final String SPARSE_ARRAY_CLASS_NAME = "android.util.SparseArray";
    private static final String VIEW_CLASS_NAME = "android.view.View";
    private static final String BUNDLER_CLASS_NAME = "com.evernote.android.state.Bundler";
    private static final String SERIALIZABLE_CLASS_NAME = Serializable.class.getName();
    private static final String ARRAY_LIST_CLASS_NAME = ArrayList.class.getName();
    private static final Set<String> GENERIC_SUPER_TYPES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add(StateProcessor.PARCELABLE_CLASS_NAME);
            this.add(SERIALIZABLE_CLASS_NAME);
        }
    });
    private static final Set<String> GENERIC_SUPER_TYPE_SERIALIZABLE = Collections.singleton(SERIALIZABLE_CLASS_NAME);
    private static final Set<String> IGNORED_TYPE_DECLARATIONS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add(StateProcessor.BUNDLE_CLASS_NAME);
            this.add(String.class.getName());
            this.add(Byte.class.getName());
            this.add(Short.class.getName());
            this.add(Integer.class.getName());
            this.add(Long.class.getName());
            this.add(Float.class.getName());
            this.add(Double.class.getName());
            this.add(Character.class.getName());
            this.add(Boolean.class.getName());
        }
    });
    private Types mTypeUtils;
    private Elements mElementUtils;
    private Filer mFiler;
    private Messager mMessager;
    private HashMap<String, List<Element>> mMapGeneratedFileToOriginatingElements = new LinkedHashMap<String, List<Element>>();
    private static final String LICENSE_HEADER = "/* *****************************************************************************\n * Copyright (c) 2017 Evernote Corporation.\n * This software was generated by Evernote\u2019s Android-State code generator\n * (available at https://github.com/evernote/android-state), which is made\n * available under the terms of the Eclipse Public License v1.0\n * (available at http://www.eclipse.org/legal/epl-v10.html).\n * For clarification, code generated by the Android-State code generator is\n * not subject to the Eclipse Public License and can be used subject to the\n * following terms:\n *\n * Permission is hereby granted, free of charge, to any person obtaining a copy\n * of this software and associated documentation files (the \"Software\"), to deal\n * in the Software without restriction, including without limitation the rights\n * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n * copies of the Software, and to permit persons to whom the Software is\n * furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in all\n * copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\n * SOFTWARE.\n *******************************************************************************/\n";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.mTypeUtils = processingEnv.getTypeUtils();
        this.mElementUtils = processingEnv.getElementUtils();
        this.mFiler = processingEnv.getFiler();
        this.mMessager = processingEnv.getMessager();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotations = new HashSet<String>();
        annotations.add(STATE_CLASS_NAME);
        annotations.add(STATE_REFLECTION_CLASS_NAME);
        return Collections.unmodifiableSet(annotations);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        HashSet<Element> annotatedFields = new HashSet<Element>();
        annotatedFields.addAll(env.getElementsAnnotatedWith(this.mElementUtils.getTypeElement(STATE_CLASS_NAME)));
        annotatedFields.addAll(env.getElementsAnnotatedWith(this.mElementUtils.getTypeElement(STATE_REFLECTION_CLASS_NAME)));
        HashMap<Element, BundlerWrapper> bundlers = new HashMap<Element, BundlerWrapper>();
        for (Element field : annotatedFields) {
            if (field.getModifiers().contains((Object)Modifier.STATIC)) {
                this.mMessager.printMessage(Diagnostic.Kind.ERROR, "Field must not be static", field);
                return true;
            }
            if (field.getModifiers().contains((Object)Modifier.FINAL)) {
                this.mMessager.printMessage(Diagnostic.Kind.ERROR, "Field must not be final", field);
                return true;
            }
            BundlerWrapper bundlerWrapper = this.getBundlerWrapper(field);
            if (bundlerWrapper == null && TYPE_MAPPING.get(field.asType().toString()) == null) {
                CompatibilityType compatibilityType = this.getCompatibilityType(field);
                if (compatibilityType == null) {
                    this.mMessager.printMessage(Diagnostic.Kind.ERROR, "Don't know how to put " + field.asType() + " into a bundle", field);
                    return true;
                }
                TYPE_MAPPING.put(field.asType().toString(), compatibilityType.mMapping);
            }
            if (bundlerWrapper == null) continue;
            Element privateClass = this.getPrivateClass(this.mElementUtils.getTypeElement(bundlerWrapper.mGenericName.toString()));
            if (privateClass != null) {
                this.mMessager.printMessage(Diagnostic.Kind.ERROR, "Class must not be private", privateClass);
                return true;
            }
            privateClass = this.getPrivateClass(this.mElementUtils.getTypeElement(bundlerWrapper.mBundlerName.toString()));
            if (privateClass != null) {
                this.mMessager.printMessage(Diagnostic.Kind.ERROR, "Class must not be private", privateClass);
                return true;
            }
            bundlers.put(field, bundlerWrapper);
        }
        Map<Element, Set<Element>> classes = this.getClassElements(annotatedFields);
        Set<Element> allClassElements = classes.keySet();
        for (Element classElement : allClassElements) {
            Element privateClass = this.getPrivateClass(classElement);
            if (privateClass == null) continue;
            this.mMessager.printMessage(Diagnostic.Kind.ERROR, "Class must not be private", privateClass);
            return true;
        }
        for (Element classElement : allClassElements) {
            ParameterizedTypeName superTypeName;
            List<? extends Element> fields = StateProcessor.sorted((Collection<? extends Element>)classes.get(classElement));
            Element packageElement = this.findElement(classElement, ElementKind.PACKAGE);
            String packageName = packageElement.asType().toString();
            if ("package".equals(packageName)) {
                String packageJackCompiler = this.findPackageJackCompiler(classElement);
                packageName = packageJackCompiler == null ? packageName : packageJackCompiler;
            }
            String className = this.getClassName(classElement);
            boolean isView = this.isAssignable(classElement, VIEW_CLASS_NAME);
            TypeVariableName genericType = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.eraseGenericIfNecessary(classElement.asType()))});
            TypeMirror superType = this.getSuperType(classElement.asType(), allClassElements);
            if (superType == null) {
                superTypeName = ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)(isView ? INJECTOR_VIEW_CLASS_NAME : INJECTOR_OBJECT_CLASS_NAME)), (TypeName[])new TypeName[]{genericType});
            } else {
                ClassName rawType = ClassName.bestGuess((String)(this.eraseGenericIfNecessary(superType).toString() + STATE_SAVER_SUFFIX));
                if (!rawType.toString().equals(rawType.reflectionName())) {
                    rawType = ClassName.bestGuess((String)rawType.reflectionName());
                }
                superTypeName = ParameterizedTypeName.get((ClassName)rawType, (TypeName[])new TypeName[]{genericType});
            }
            MethodSpec.Builder saveMethodBuilder = MethodSpec.methodBuilder((String)"save").addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)genericType, "target", new Modifier[0]);
            MethodSpec.Builder restoreMethodBuilder = MethodSpec.methodBuilder((String)"restore").addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)genericType, "target", new Modifier[0]);
            TypeName bundleTypeName = this.getTypeName(BUNDLE_CLASS_NAME);
            if (isView) {
                TypeName parcelableTypeName = this.getTypeName(PARCELABLE_CLASS_NAME);
                saveMethodBuilder = saveMethodBuilder.returns(parcelableTypeName).addParameter(parcelableTypeName, "p", new Modifier[0]);
                restoreMethodBuilder = restoreMethodBuilder.returns(parcelableTypeName).addParameter(parcelableTypeName, "p", new Modifier[0]);
                saveMethodBuilder = superType != null ? saveMethodBuilder.addStatement("$T state = HELPER.putParent(super.save(target, p))", new Object[]{bundleTypeName}) : saveMethodBuilder.addStatement("$T state = HELPER.putParent(p)", new Object[]{bundleTypeName});
                restoreMethodBuilder = restoreMethodBuilder.addStatement("$T state = ($T) p", new Object[]{bundleTypeName, bundleTypeName});
            } else {
                saveMethodBuilder = saveMethodBuilder.returns(Void.TYPE).addParameter(bundleTypeName, "state", new Modifier[0]);
                restoreMethodBuilder = restoreMethodBuilder.returns(Void.TYPE).addParameter(bundleTypeName, "state", new Modifier[0]);
                if (superType != null) {
                    saveMethodBuilder = saveMethodBuilder.addStatement("super.save(target, state)", new Object[0]);
                    restoreMethodBuilder = restoreMethodBuilder.addStatement("super.restore(target, state)", new Object[0]);
                }
            }
            CodeBlock.Builder staticInitBlock = CodeBlock.builder();
            for (Element element : fields) {
                BundlerWrapper bundler;
                String fieldTypeString = element.asType().toString();
                String mapping = TYPE_MAPPING.get(fieldTypeString);
                FieldType fieldType = this.getFieldType(element, false);
                if (fieldType == FieldType.NOT_SUPPORTED && StateProcessor.isHungarianNotation(element)) {
                    fieldType = this.getFieldType(element, true);
                }
                String fieldName = fieldType.getFieldName(element);
                String castedType = null;
                CompatibilityType compatibilityType = this.getCompatibilityType(element);
                if (compatibilityType == CompatibilityType.PARCELABLE_ARRAY && !PARCELABLE_ARRAY_CLASS_NAME.equals(fieldTypeString)) {
                    this.mMessager.printMessage(Diagnostic.Kind.NOTE, "Field " + fieldTypeString + " " + PARCELABLE_ARRAY_CLASS_NAME);
                    castedType = fieldTypeString;
                }
                if ((bundler = (BundlerWrapper)bundlers.get(element)) != null) {
                    staticInitBlock = staticInitBlock.addStatement("BUNDLERS.put($S, new $T())", new Object[]{fieldName, bundler.mBundlerName});
                    mapping = "WithBundler";
                }
                switch (fieldType) {
                    case FIELD: {
                        saveMethodBuilder = saveMethodBuilder.addStatement("HELPER.put$N(state, $S, target.$N)", new Object[]{mapping, fieldName, fieldName});
                        if (castedType != null) {
                            restoreMethodBuilder = restoreMethodBuilder.addStatement("target.$N = ($N) HELPER.get$N(state, $S)", new Object[]{fieldName, castedType, mapping, fieldName});
                            break;
                        }
                        restoreMethodBuilder = restoreMethodBuilder.addStatement("target.$N = HELPER.get$N(state, $S)", new Object[]{fieldName, mapping, fieldName});
                        break;
                    }
                    case BOOLEAN_PROPERTY: 
                    case BOOLEAN_PROPERTY_KOTLIN: 
                    case PROPERTY_HUNGARIAN: 
                    case PROPERTY: {
                        if (fieldType == FieldType.BOOLEAN_PROPERTY || fieldType == FieldType.BOOLEAN_PROPERTY_KOTLIN) {
                            saveMethodBuilder.addStatement("HELPER.put$N(state, $S, target.$N$N())", new Object[]{mapping, fieldName, "is", fieldName});
                        } else {
                            saveMethodBuilder.addStatement("HELPER.put$N(state, $S, target.$N$N())", new Object[]{mapping, fieldName, "get", fieldName});
                        }
                        if (bundler != null) {
                            TypeMirror parameterType;
                            TypeName genericName = bundler.mGenericName;
                            if (fieldType == FieldType.PROPERTY && (parameterType = this.findParameterType(element)) != null) {
                                genericName = ClassName.get((TypeMirror)parameterType);
                            }
                            restoreMethodBuilder = restoreMethodBuilder.addStatement("target.set$N(HELPER.<$T>get$N(state, $S))", new Object[]{fieldName, genericName, mapping, fieldName});
                            break;
                        }
                        InsertedTypeResult insertedType = this.getInsertedType(element, true);
                        if (insertedType != null) {
                            restoreMethodBuilder = restoreMethodBuilder.addStatement("target.set$N(HELPER.<$T>get$N(state, $S))", new Object[]{fieldName, ClassName.get((TypeMirror)insertedType.mTypeMirror), mapping, fieldName});
                            break;
                        }
                        if (castedType != null) {
                            restoreMethodBuilder = restoreMethodBuilder.addStatement("target.set$N(($N) HELPER.get$N(state, $S))", new Object[]{fieldName, castedType, mapping, fieldName});
                            break;
                        }
                        restoreMethodBuilder = restoreMethodBuilder.addStatement("target.set$N(HELPER.get$N(state, $S))", new Object[]{fieldName, mapping, fieldName});
                        break;
                    }
                    case FIELD_REFLECTION: {
                        String reflectionMapping = this.isPrimitiveMapping(mapping) ? mapping : "";
                        InsertedTypeResult insertedType = this.getInsertedType(element, true);
                        if (compatibilityType != null && insertedType != null) {
                            fieldTypeString = compatibilityType.mClass;
                        }
                        saveMethodBuilder = saveMethodBuilder.beginControlFlow("try", new Object[0]).addStatement("$T field = target.getClass().getDeclaredField($S)", new Object[]{Field.class, fieldName}).addStatement("boolean accessible = field.isAccessible()", new Object[0]).beginControlFlow("if (!accessible)", new Object[0]).addStatement("field.setAccessible(true)", new Object[0]).endControlFlow().addStatement("HELPER.put$N(state, $S, ($N) field.get$N(target))", new Object[]{mapping, fieldName, fieldTypeString, reflectionMapping}).beginControlFlow("if (!accessible)", new Object[0]).addStatement("field.setAccessible(false)", new Object[0]).endControlFlow().nextControlFlow("catch (Exception e)", new Object[0]).addStatement("throw new $T(e)", new Object[]{RuntimeException.class}).endControlFlow();
                        restoreMethodBuilder = restoreMethodBuilder.beginControlFlow("try", new Object[0]).addStatement("$T field = target.getClass().getDeclaredField($S)", new Object[]{Field.class, fieldName}).addStatement("boolean accessible = field.isAccessible()", new Object[0]).beginControlFlow("if (!accessible)", new Object[0]).addStatement("field.setAccessible(true)", new Object[0]).endControlFlow().addStatement("field.set$N(target, HELPER.get$N(state, $S))", new Object[]{reflectionMapping, mapping, fieldName}).beginControlFlow("if (!accessible)", new Object[0]).addStatement("field.setAccessible(false)", new Object[0]).endControlFlow().nextControlFlow("catch (Exception e)", new Object[0]).addStatement("throw new $T(e)", new Object[]{RuntimeException.class}).endControlFlow();
                        break;
                    }
                    default: {
                        this.mMessager.printMessage(Diagnostic.Kind.ERROR, "Field " + element.getSimpleName() + " must be either non-private or provide a getter and setter method", element);
                        return true;
                    }
                }
            }
            if (isView) {
                saveMethodBuilder = saveMethodBuilder.addStatement("return state", new Object[0]);
                restoreMethodBuilder = superType != null ? restoreMethodBuilder.addStatement("return super.restore(target, HELPER.getParent(state))", new Object[0]) : restoreMethodBuilder.addStatement("return HELPER.getParent(state)", new Object[0]);
            }
            ParameterizedTypeName bundlerType = ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)BUNDLER_CLASS_NAME), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), bundlerType});
            TypeSpec classBuilder = TypeSpec.classBuilder((String)(className + STATE_SAVER_SUFFIX)).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)superTypeName).addTypeVariable(genericType).addField(FieldSpec.builder((TypeName)parameterizedTypeName, (String)"BUNDLERS", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{parameterizedTypeName}).build()).addStaticBlock(staticInitBlock.build()).addField(FieldSpec.builder((TypeName)this.getTypeName(INJECTION_HELPER_CLASS_NAME), (String)"HELPER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.STATIC, Modifier.PRIVATE}).initializer("new $T($S, $N)", new Object[]{this.getTypeName(INJECTION_HELPER_CLASS_NAME), packageName + '.' + className + STATE_SAVER_SUFFIX, "BUNDLERS"}).build()).addMethod(saveMethodBuilder.build()).addMethod(restoreMethodBuilder.build()).addOriginatingElement(classElement).build();
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)classBuilder).build();
            if (!this.writeJavaFile(javaFile)) {
                return true;
            }
            this.mMapGeneratedFileToOriginatingElements.put(javaFile.toJavaFileObject().getName(), javaFile.typeSpec.originatingElements);
        }
        return true;
    }

    private boolean writeJavaFile(JavaFile javaFile) {
        StringBuilder builder = new StringBuilder();
        FileObject filerSourceFile = null;
        try {
            builder.append(LICENSE_HEADER);
            javaFile.writeTo((Appendable)builder);
            String fileName = javaFile.packageName.isEmpty() ? javaFile.typeSpec.name : javaFile.packageName + "." + javaFile.typeSpec.name;
            List originatingElements = javaFile.typeSpec.originatingElements;
            filerSourceFile = this.mFiler.createSourceFile(fileName, originatingElements.toArray(new Element[0]));
            try (Writer writer = filerSourceFile.openWriter();){
                writer.write(builder.toString());
            }
            return true;
        }
        catch (Exception e) {
            this.mMessager.printMessage(Diagnostic.Kind.ERROR, "Couldn't generate classes " + javaFile.packageName + '.' + javaFile.typeSpec.name);
            e.printStackTrace();
            if (filerSourceFile != null) {
                filerSourceFile.delete();
            }
            return false;
        }
    }

    HashMap<String, List<Element>> getMapGeneratedFileToOriginatingElements() {
        return this.mMapGeneratedFileToOriginatingElements;
    }

    private Map<Element, Set<Element>> getClassElements(Collection<? extends Element> annotatedFields) {
        HashMap<Element, Set<Element>> result = new HashMap<Element, Set<Element>>();
        for (Element element : annotatedFields) {
            Element classElement = this.findElement(element, ElementKind.CLASS);
            HashSet<Element> elements = (HashSet<Element>)result.get(classElement);
            if (elements == null) {
                elements = new HashSet<Element>();
            }
            elements.add(element);
            result.put(classElement, elements);
        }
        return result;
    }

    private Element findElement(Element element, ElementKind kind) {
        Element enclosingElement = element.getEnclosingElement();
        if (enclosingElement == null) {
            return element;
        }
        return element.getKind() == kind ? element : this.findElement(enclosingElement, kind);
    }

    private String findPackageJackCompiler(Element element) {
        Element enclosingElement = element.getEnclosingElement();
        if (enclosingElement != null && enclosingElement.getKind() == ElementKind.PACKAGE && element.getKind() == ElementKind.CLASS) {
            String className = element.asType().toString();
            int index = className.lastIndexOf(46);
            if (index <= 0) {
                this.mMessager.printMessage(Diagnostic.Kind.WARNING, "Couldn't find package name with Jack compiler");
                return null;
            }
            return className.substring(0, index);
        }
        return enclosingElement != null ? this.findPackageJackCompiler(enclosingElement) : null;
    }

    private Element getPrivateClass(Element classElement) {
        if (classElement == null || classElement.getKind() != ElementKind.CLASS) {
            return null;
        }
        if (classElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return classElement;
        }
        return this.getPrivateClass(classElement.getEnclosingElement());
    }

    private String getClassName(Element classElement) {
        StringBuilder className = new StringBuilder(classElement.getSimpleName().toString());
        for (Element enclosingElement = classElement.getEnclosingElement(); enclosingElement != null && enclosingElement.getKind() == ElementKind.CLASS; enclosingElement = enclosingElement.getEnclosingElement()) {
            className.insert(0, enclosingElement.getSimpleName() + "$");
        }
        return className.toString();
    }

    private static boolean isHungarianNotation(Element field) {
        String fieldName = field.getSimpleName().toString();
        return fieldName.length() >= 2 && fieldName.startsWith("m") && Character.isUpperCase(fieldName.charAt(1));
    }

    private static String getPropertyFieldName(Element field, boolean ignoreHungarianNotation) {
        String fieldName = field.getSimpleName().toString();
        if (!ignoreHungarianNotation && StateProcessor.isHungarianNotation(field)) {
            fieldName = fieldName.substring(1);
        }
        return Character.toUpperCase(fieldName.charAt(0)) + (fieldName.length() > 1 ? fieldName.substring(1) : "");
    }

    private TypeMirror findParameterType(Element field) {
        TypeMirror result = this.findParameterType(field, true);
        return result != null ? result : this.findParameterType(field, false);
    }

    private TypeMirror findParameterType(Element field, boolean ignoreHungarianNotation) {
        String fieldName = StateProcessor.getPropertyFieldName(field, ignoreHungarianNotation);
        String setterName = "set" + fieldName;
        List<? extends Element> elements = field.getEnclosingElement().getEnclosedElements();
        for (Element element : elements) {
            List<? extends VariableElement> parameters;
            String elementName;
            if (element.getKind() != ElementKind.METHOD || !(element instanceof ExecutableElement) || !setterName.equals(elementName = element.getSimpleName().toString()) || element.getModifiers().contains((Object)Modifier.PRIVATE) || (parameters = ((ExecutableElement)element).getParameters()) == null || parameters.isEmpty()) continue;
            VariableElement variableElement = parameters.get(0);
            return variableElement.asType();
        }
        return null;
    }

    private FieldType getFieldType(Element field, boolean ignoreHungarianNotation) {
        if (!field.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return FieldType.FIELD;
        }
        if (this.useReflection(field)) {
            return FieldType.FIELD_REFLECTION;
        }
        String fieldName = StateProcessor.getPropertyFieldName(field, ignoreHungarianNotation);
        String getterName = "get" + fieldName;
        String isGetterName = "is" + fieldName;
        String setterName = "set" + fieldName;
        String isGetterNameKotlin = null;
        String setterNameKotlin = null;
        if (fieldName.length() > 2 && fieldName.startsWith("Is") && Character.isUpperCase(fieldName.charAt(2))) {
            String substring = fieldName.substring(2);
            isGetterNameKotlin = "is" + substring;
            setterNameKotlin = "set" + substring;
        }
        List<? extends Element> elements = field.getEnclosingElement().getEnclosedElements();
        boolean hasGetter = false;
        boolean hasIsGetter = false;
        boolean hasSetter = false;
        boolean isKotlinBooleanProperty = false;
        for (Element element : elements) {
            if (element.getKind() != ElementKind.METHOD) continue;
            String elementName = element.getSimpleName().toString();
            if (!hasGetter && getterName.equals(elementName) && !element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                hasGetter = true;
                if (hasSetter) break;
            }
            if (!hasIsGetter && isGetterName.equals(elementName) && !element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                hasIsGetter = true;
                if (hasSetter) break;
            }
            if (!hasGetter && isGetterNameKotlin != null && isGetterNameKotlin.equals(elementName) && !element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                hasIsGetter = true;
                isKotlinBooleanProperty = true;
                if (hasSetter) break;
            }
            if (!hasSetter && setterName.equals(elementName) && !element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                hasSetter = true;
                if (hasGetter) break;
            }
            if (hasSetter || setterNameKotlin == null || !setterNameKotlin.equals(elementName) || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            hasSetter = true;
            if (!hasGetter) continue;
            break;
        }
        if (isKotlinBooleanProperty && hasSetter) {
            return FieldType.BOOLEAN_PROPERTY_KOTLIN;
        }
        if (hasIsGetter && hasSetter) {
            return FieldType.BOOLEAN_PROPERTY;
        }
        if (hasGetter && hasSetter) {
            return ignoreHungarianNotation ? FieldType.PROPERTY_HUNGARIAN : FieldType.PROPERTY;
        }
        return FieldType.NOT_SUPPORTED;
    }

    private BundlerWrapper getBundlerWrapper(Element field) {
        for (AnnotationMirror annotationMirror : field.getAnnotationMirrors()) {
            if (!this.isStateAnnotation(annotationMirror)) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            for (ExecutableElement executableElement : elementValues.keySet()) {
                Object value;
                if (!"value".equals(executableElement.getSimpleName().toString()) || (value = elementValues.get(executableElement).getValue()) == null) continue;
                ClassName bundlerName = ClassName.get((TypeElement)this.mElementUtils.getTypeElement(value.toString()));
                ClassName genericName = null;
                try {
                    List<? extends TypeMirror> interfaces = this.mElementUtils.getTypeElement(value.toString()).getInterfaces();
                    for (TypeMirror typeMirror : interfaces) {
                        List<? extends TypeMirror> typeArguments;
                        if (!this.isAssignable(this.mTypeUtils.erasure(typeMirror), BUNDLER_CLASS_NAME) || (typeArguments = ((DeclaredType)typeMirror).getTypeArguments()) == null || typeArguments.size() < 1) continue;
                        TypeMirror genericTypeMirror = typeArguments.get(0);
                        String genericString = genericTypeMirror.toString();
                        if (genericString.contains("<? extends ")) {
                            InsertedTypeResult insertedType;
                            String innerType = genericString.substring(genericString.indexOf("<? extends ") + 11, genericString.length() - 1);
                            if (PARCELABLE_CLASS_NAME.equals(innerType) && (insertedType = this.getInsertedType(field, true)) != null) {
                                innerType = insertedType.mTypeMirror.toString();
                            }
                            ClassName erasureClassName = ClassName.bestGuess((String)this.mTypeUtils.erasure(genericTypeMirror).toString());
                            genericName = ParameterizedTypeName.get((ClassName)erasureClassName, (TypeName[])new TypeName[]{ClassName.bestGuess((String)innerType)});
                            continue;
                        }
                        genericName = ClassName.get((TypeMirror)genericTypeMirror);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return new BundlerWrapper((TypeName)bundlerName, (TypeName)(genericName == null ? ClassName.get(Object.class) : genericName));
            }
        }
        return null;
    }

    private boolean useReflection(Element field) {
        for (AnnotationMirror annotationMirror : field.getAnnotationMirrors()) {
            if (!STATE_REFLECTION_CLASS_NAME.equals(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isPrimitiveMapping(String mapping) {
        switch (mapping) {
            case "Int": 
            case "Short": 
            case "Byte": 
            case "Long": 
            case "Char": 
            case "Boolean": 
            case "Double": 
            case "Float": {
                return true;
            }
        }
        return false;
    }

    private CompatibilityType getCompatibilityType(Element field) {
        TypeMirror typeMirror = field.asType();
        for (CompatibilityType compatibilityType : CompatibilityType.values()) {
            List<? extends TypeMirror> typeArguments;
            if (compatibilityType == CompatibilityType.PARCELABLE_ARRAY) {
                TypeMirror arrayType = this.getArrayType(field);
                if (arrayType == null || !this.isAssignable(arrayType, PARCELABLE_CLASS_NAME)) continue;
                return CompatibilityType.PARCELABLE_ARRAY;
            }
            if (!(compatibilityType.mGenericClass == null ? this.isAssignable(typeMirror, compatibilityType.mClass) : typeMirror.getKind() != TypeKind.WILDCARD && this.isAssignable(this.mTypeUtils.erasure(typeMirror), compatibilityType.mClass) && (typeArguments = ((DeclaredType)typeMirror).getTypeArguments()) != null && typeArguments.size() >= 1 && this.isAssignable(typeArguments.get(0), compatibilityType.mGenericClass))) continue;
            return compatibilityType;
        }
        return null;
    }

    private TypeMirror getArrayType(Element field) {
        TypeMirror typeMirror = field.asType();
        if (typeMirror instanceof ArrayType) {
            return ((ArrayType)typeMirror).getComponentType();
        }
        return null;
    }

    private boolean isAssignable(Element element, String className) {
        return this.isAssignable(element.asType(), className);
    }

    private boolean isAssignable(TypeMirror typeMirror, String className) {
        return this.mTypeUtils.isAssignable(typeMirror, this.mElementUtils.getTypeElement(className).asType());
    }

    private static List<? extends Element> sorted(Collection<? extends Element> collection) {
        ArrayList<? extends Element> result = new ArrayList<Element>(collection);
        Collections.sort(result, COMPARATOR);
        return result;
    }

    private TypeMirror eraseGenericIfNecessary(TypeMirror typeMirror) {
        String[] split = typeMirror.toString().split("\\.");
        boolean hasGeneric = false;
        for (String className : split) {
            if (!className.endsWith(">")) continue;
            hasGeneric = true;
            break;
        }
        return hasGeneric ? this.mTypeUtils.erasure(typeMirror) : typeMirror;
    }

    private TypeMirror eraseCovarianceAndInvariance(TypeMirror typeMirror) {
        String string = typeMirror.toString();
        if (string.startsWith("? extends") || string.startsWith("? super")) {
            return this.mTypeUtils.erasure(typeMirror);
        }
        return typeMirror;
    }

    private TypeMirror getSuperType(TypeMirror classElement, Set<Element> allClassElements) {
        TypeMirror superClass;
        List<? extends TypeMirror> typeMirrors = this.mTypeUtils.directSupertypes(classElement);
        while (typeMirrors != null && !typeMirrors.isEmpty() && !OBJECT_CLASS_NAME.equals((superClass = typeMirrors.get(0)).toString())) {
            if (allClassElements.contains(this.mTypeUtils.asElement(superClass))) {
                return superClass;
            }
            typeMirrors = this.mTypeUtils.directSupertypes(superClass);
        }
        return null;
    }

    private InsertedTypeResult getInsertedType(Element field, boolean checkIgnoredTypes) {
        if (field == null) {
            return null;
        }
        return this.getInsertedType(field.asType(), checkIgnoredTypes);
    }

    private InsertedTypeResult getInsertedType(TypeMirror fieldType, boolean checkIgnoredTypes) {
        List<? extends TypeMirror> typeArguments;
        List<? extends TypeMirror> superTypes;
        TypeElement classElement = this.mElementUtils.getTypeElement(this.eraseGenericIfNecessary(fieldType = this.eraseCovarianceAndInvariance(fieldType)).toString());
        List<? extends TypeMirror> list = superTypes = classElement == null ? null : this.mTypeUtils.directSupertypes(classElement.asType());
        if (fieldType instanceof DeclaredType && (typeArguments = ((DeclaredType)fieldType).getTypeArguments()) != null && !typeArguments.isEmpty()) {
            if (superTypes != null && this.isSuperType(superTypes, GENERIC_SUPER_TYPES) && !fieldType.toString().startsWith(ArrayList.class.getName())) {
                return new InsertedTypeResult(fieldType, this.isSuperType(superTypes, GENERIC_SUPER_TYPE_SERIALIZABLE));
            }
            InsertedTypeResult insertedTypeResult = this.getInsertedType(typeArguments.get(0), false);
            if (insertedTypeResult != null && insertedTypeResult.mSerializable && fieldType.toString().startsWith(ArrayList.class.getName())) {
                return new InsertedTypeResult(fieldType, true);
            }
            return insertedTypeResult;
        }
        if (classElement == null || OBJECT_CLASS_NAME.equals(classElement.toString())) {
            return null;
        }
        if (checkIgnoredTypes && IGNORED_TYPE_DECLARATIONS.contains(classElement.toString())) {
            return null;
        }
        if (superTypes != null) {
            if (this.isSuperType(superTypes, GENERIC_SUPER_TYPES)) {
                return new InsertedTypeResult(fieldType, this.isSuperType(superTypes, GENERIC_SUPER_TYPE_SERIALIZABLE));
            }
            for (TypeMirror typeMirror : superTypes) {
                InsertedTypeResult result = this.getInsertedType(this.eraseGenericIfNecessary(typeMirror), checkIgnoredTypes);
                if (result == null) continue;
                return new InsertedTypeResult(fieldType, result.mSerializable);
            }
        }
        return null;
    }

    private boolean isSuperType(List<? extends TypeMirror> typeMirrors, Collection<String> superTypes) {
        for (TypeMirror typeMirror : typeMirrors) {
            if (!superTypes.contains(typeMirror.toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isStateAnnotation(AnnotationMirror annotationMirror) {
        String string = annotationMirror.getAnnotationType().toString();
        return STATE_CLASS_NAME.equals(string) || STATE_REFLECTION_CLASS_NAME.equals(string);
    }

    private TypeName getTypeName(String className) {
        return TypeName.get((TypeMirror)this.mElementUtils.getTypeElement(className).asType());
    }

    static /* synthetic */ String access$400() {
        return ARRAY_LIST_CLASS_NAME;
    }

    private static final class InsertedTypeResult {
        private final TypeMirror mTypeMirror;
        private final boolean mSerializable;

        private InsertedTypeResult(TypeMirror typeMirror, boolean serializable) {
            this.mTypeMirror = typeMirror;
            this.mSerializable = serializable;
        }
    }

    private static enum CompatibilityType {
        PARCELABLE("Parcelable", "android.os.Parcelable", null),
        PARCELABLE_ARRAY("ParcelableArray", "android.os.Parcelable[]", null),
        PARCELABLE_LIST("ParcelableArrayList", StateProcessor.access$400(), "android.os.Parcelable"),
        SPARSE_PARCELABLE_ARRAY("SparseParcelableArray", "android.util.SparseArray", "android.os.Parcelable"),
        SERIALIZABLE("Serializable", StateProcessor.access$000(), null);

        final String mMapping;
        final String mClass;
        final String mGenericClass;

        private CompatibilityType(String mapping, String clazz, String genericClass) {
            this.mMapping = mapping;
            this.mClass = clazz;
            this.mGenericClass = genericClass;
        }
    }

    private static final class BundlerWrapper {
        final TypeName mBundlerName;
        final TypeName mGenericName;

        private BundlerWrapper(TypeName bundlerName, TypeName genericName) {
            this.mBundlerName = bundlerName;
            this.mGenericName = genericName;
        }
    }

    private static enum FieldType {
        FIELD,
        FIELD_REFLECTION,
        PROPERTY,
        BOOLEAN_PROPERTY,
        BOOLEAN_PROPERTY_KOTLIN,
        PROPERTY_HUNGARIAN,
        NOT_SUPPORTED;


        public String getFieldName(Element field) {
            switch (this) {
                case FIELD: 
                case FIELD_REFLECTION: {
                    return field.getSimpleName().toString();
                }
                case BOOLEAN_PROPERTY: 
                case PROPERTY: {
                    return StateProcessor.getPropertyFieldName(field, false);
                }
                case PROPERTY_HUNGARIAN: {
                    return StateProcessor.getPropertyFieldName(field, true);
                }
                case BOOLEAN_PROPERTY_KOTLIN: {
                    return field.getSimpleName().toString().substring(2);
                }
            }
            return null;
        }
    }
}

