/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.promote;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.promote.Item;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.json.JSONObject;

public class Tag
extends Item {
    @NonNull
    public String tagType;

    public Tag(@NonNull String id2, @NonNull String tagType) {
        super(id2);
        if (Tag.isTypeInvalid(tagType)) {
            IllegalArgumentException e = new IllegalArgumentException();
            Logger.log(1000, TAG, e, "Created Tag with invalid field: tagType must be one of the specified Tag.Type values");
        }
        this.tagType = tagType;
    }

    private static boolean isTypeInvalid(@NonNull String tagType) {
        if (tagType == null) {
            return true;
        }
        switch (tagType) {
            case "ContentClass": 
            case "Author": 
            case "Brand": 
            case "Gender": 
            case "ItemClass": 
            case "Keyword": 
            case "Size": 
            case "Style": {
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public JSONObject toJSONObject() {
        if (Tag.isTypeInvalid(this.tagType)) {
            Logger.log(1000, TAG, null, "Dropping Tag before sending to server: tagType is invalid or null");
            return null;
        }
        JSONObject tagJson = super.toJSONObject();
        if (tagJson == null) {
            return null;
        }
        JSONUtil.put(tagJson, "tagType", this.tagType);
        return tagJson;
    }

    @Nullable
    public static Tag fromJSONObject(@NonNull JSONObject json, @NonNull String id2) {
        String tagType = JSONUtil.getString(json, "tagType");
        if (Tag.isTypeInvalid(tagType)) {
            return null;
        }
        Tag newTag = new Tag(id2, tagType);
        newTag.setFieldsFromJson(json);
        return newTag;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
        public static final String Brand = "Brand";
        public static final String ItemClass = "ItemClass";
        public static final String Gender = "Gender";
        public static final String Style = "Style";
        public static final String Author = "Author";
        public static final String Keyword = "Keyword";
        public static final String ContentClass = "ContentClass";
        public static final String Size = "Size";
    }
}

