/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.promote;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.StringUtil;
import java.util.Date;
import org.json.JSONObject;

public class Review {
    @NonNull
    public String itemId;
    @Nullable
    public Date date;
    @Nullable
    @IntRange(from=1L, to=100L)
    public Integer rating;
    @Nullable
    public String title;
    @Nullable
    public String content;
    @Nullable
    public String userDisplayName;
    @Nullable
    public Boolean purchased;

    public Review(@NonNull String itemId, @Nullable Date date, @Nullable @IntRange(from=1L, to=100L) Integer rating, @Nullable String title, @Nullable Boolean purchased) {
        if (!StringUtil.isValid(itemId)) {
            IllegalArgumentException e = new IllegalArgumentException();
            Logger.log(1000, "Review", e, "Review created with invalid field: itemId is null or empty.");
        }
        this.itemId = itemId;
        this.date = date;
        this.rating = rating;
        this.title = title;
        this.purchased = purchased;
    }

    @Nullable
    public JSONObject toJSONObject() {
        if (!StringUtil.isValid(this.itemId)) {
            Logger.log(1000, "Review", null, "Dropping Review before sending to server: itemId is null or empty.");
            return null;
        }
        JSONObject reviewJson = new JSONObject();
        JSONUtil.put(reviewJson, "itemId", this.itemId);
        if (this.date != null) {
            JSONUtil.put(reviewJson, "date", this.date.getTime());
        }
        JSONUtil.put(reviewJson, "rating", this.rating);
        JSONUtil.put(reviewJson, "title", StringUtil.truncate("title", this.title));
        JSONUtil.put(reviewJson, "content", StringUtil.truncate("content", this.content));
        JSONUtil.put(reviewJson, "userDisplayName", this.userDisplayName);
        JSONUtil.put(reviewJson, "purchased", this.purchased);
        return reviewJson;
    }

    @Nullable
    public static Review fromJSONObject(@NonNull JSONObject json) {
        if (json == null) {
            return null;
        }
        String itemIdJson = JSONUtil.getString(json, "itemId");
        if (!StringUtil.isValid(itemIdJson)) {
            return null;
        }
        Long dateFromLong = JSONUtil.getLong(json, "date");
        Date dateJson = dateFromLong == null ? null : new Date(dateFromLong);
        Integer ratingJson = JSONUtil.getInteger(json, "rating");
        String titleJson = JSONUtil.getString(json, "title");
        Boolean purchasedJson = JSONUtil.getBoolean(json, "purchased");
        Review newReview = new Review(itemIdJson, dateJson, ratingJson, titleJson, purchasedJson);
        newReview.content = JSONUtil.getString(json, "content");
        newReview.userDisplayName = JSONUtil.getString(json, "userDisplayName");
        return newReview;
    }
}

