/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.promote;

import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.StringUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class Location {
    private static final String TAG = Location.class.getSimpleName();
    @Nullable
    @FloatRange(from=-90.0, to=90.0)
    public Double latitude;
    @Nullable
    @FloatRange(from=-180.0, to=180.0)
    public Double longitude;
    @Nullable
    public String city;
    @Nullable
    public String stateProvinceCode;
    @Nullable
    public String postalCode;

    public Location(@FloatRange(from=-90.0, to=90.0) double latitude, @FloatRange(from=-180.0, to=180.0) double longitude) {
        IllegalArgumentException e;
        if (latitude < -90.0 || latitude > 90.0) {
            e = new IllegalArgumentException();
            Logger.log(1000, TAG, e, "Location is invalid. Latitude should be from -90 to 90. Found: ", Double.toString(latitude));
        }
        if (longitude < -180.0 || longitude > 180.0) {
            e = new IllegalArgumentException();
            Logger.log(1000, TAG, e, "Location is invalid. Longitude should be from -180 to 180. Found: ", Double.toString(longitude));
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Location(@NonNull String city, @NonNull String stateProvinceCode) {
        IllegalArgumentException e;
        if (!StringUtil.isValid(city)) {
            e = new IllegalArgumentException();
            Logger.log(1000, TAG, e, "Location is invalid. City is null or empty. Set to a valid value to fix.");
        }
        this.city = city;
        if (!StringUtil.isValid(stateProvinceCode)) {
            e = new IllegalArgumentException();
            Logger.log(1000, TAG, e, "Location is invalid. State/Province Code is null or empty. Set to a valid value to fix.");
        }
        this.stateProvinceCode = stateProvinceCode;
    }

    public Location(@NonNull String postalCode) {
        if (!StringUtil.isValid(postalCode)) {
            IllegalArgumentException e = new IllegalArgumentException();
            Logger.log(1000, TAG, e, "Location is invalid. Postal Code is null or empty. Set to a valid value to fix.");
        }
        this.postalCode = postalCode;
    }

    @Nullable
    public JSONObject toJSONObject() {
        StringBuilder sb = new StringBuilder();
        JSONObject locJson = new JSONObject();
        boolean componentInvalid = false;
        if (this.longitude != null && (this.longitude < -180.0 || this.longitude > 180.0)) {
            sb.append("Longitude was ").append(this.longitude).append(". ");
            componentInvalid = true;
        }
        if (this.latitude != null && (this.latitude < -90.0 || this.latitude > 90.0)) {
            sb.append("Latitude was ").append(this.latitude).append(". ");
            componentInvalid = true;
        }
        if (this.latitude != null && this.longitude != null && !componentInvalid) {
            JSONArray longlat = new JSONArray();
            JSONUtil.arrayPut(longlat, this.longitude, true);
            JSONUtil.arrayPut(longlat, this.latitude, true);
            JSONUtil.put(locJson, "longlat", longlat);
        }
        componentInvalid = false;
        if (this.city != null && this.city.isEmpty()) {
            sb.append("City was empty. ");
            componentInvalid = true;
        }
        if (this.stateProvinceCode != null && this.stateProvinceCode.isEmpty()) {
            sb.append("State or Province Code was empty. ");
            componentInvalid = true;
        }
        if (this.city != null && this.stateProvinceCode != null && !componentInvalid) {
            JSONUtil.put(locJson, "city", this.city);
            JSONUtil.put(locJson, "stateProvinceCode", this.stateProvinceCode);
        }
        if (this.postalCode != null) {
            if (this.postalCode.isEmpty()) {
                sb.append("Postal Code was empty. ");
            } else {
                JSONUtil.put(locJson, "postalCode", this.postalCode);
            }
        }
        if (sb.length() > 0) {
            Logger.log(3000, TAG, null, "Ignored invalid fields: ", sb.toString());
        }
        if (locJson.length() > 0) {
            return locJson;
        }
        Logger.log(1000, TAG, null, "Dropping Location before sending to server, invalid.");
        return null;
    }

    @Nullable
    public static Location fromJSONObject(@NonNull JSONObject json) {
        String postalJson;
        if (json == null) {
            return null;
        }
        Location location = null;
        JSONArray longlat = JSONUtil.getJSONArray(json, "longlat");
        if (longlat != null && longlat.length() == 2) {
            Double longJson = JSONUtil.arrayGetDouble(longlat, 0);
            Double latJson = JSONUtil.arrayGetDouble(longlat, 1);
            if (longJson != null && latJson != null && longJson >= -180.0 && longJson <= 180.0 && latJson >= -90.0 && latJson <= 90.0) {
                location = new Location(latJson, longJson);
            }
        }
        String cityJson = JSONUtil.getString(json, "city");
        String stateJson = JSONUtil.getString(json, "stateProvinceCode");
        if (StringUtil.isValid(cityJson) && StringUtil.isValid(stateJson)) {
            if (location == null) {
                location = new Location(cityJson, stateJson);
            } else {
                location.city = cityJson;
                location.stateProvinceCode = stateJson;
            }
        }
        if (StringUtil.isValid(postalJson = JSONUtil.getString(json, "postalCode"))) {
            if (location == null) {
                location = new Location(postalJson);
            } else {
                location.postalCode = postalJson;
            }
        }
        return location;
    }
}

