/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.promote;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.promote.Item;
import org.json.JSONObject;

public class LineItem {
    private static final String TAG = LineItem.class.getSimpleName();
    @Nullable
    public Integer quantity;
    @NonNull
    public Item item;
    @Nullable
    public String attributedTerm;

    public LineItem(@NonNull Item item, @Nullable Integer quantity) {
        IllegalArgumentException e;
        if (item == null) {
            e = new IllegalArgumentException();
            Logger.log(1000, TAG, e, "LineItem created is invalid: Item provided is null");
        }
        if (quantity != null && quantity == 0) {
            e = new IllegalArgumentException();
            Logger.log(1000, TAG, e, "LineItem created is invalid: Quantity is 0");
        }
        this.item = item;
        this.quantity = quantity;
    }

    @Nullable
    public JSONObject toJSONObject() {
        JSONObject itemJSON;
        if (this.quantity != null && this.quantity == 0) {
            Logger.log(1000, TAG, null, "toJSONObject failed, quantity is 0");
            return null;
        }
        if (this.item == null || (itemJSON = this.item.toJSONObject()) == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        JSONUtil.put(json, "quantity", this.quantity);
        JSONUtil.put(json, "item", itemJSON);
        JSONUtil.put(json, "attributedTerm", this.attributedTerm);
        return json;
    }

    @Nullable
    static LineItem fromJSONObject(@NonNull JSONObject json) {
        if (json == null) {
            return null;
        }
        Item item = Item.getItemFromJSONObject(JSONUtil.getJSONObject(json, "item"));
        if (item == null) {
            return null;
        }
        Integer quantity = JSONUtil.getInteger(json, "quantity");
        LineItem lineItem = new LineItem(item, quantity);
        lineItem.attributedTerm = JSONUtil.getString(json, "attributedTerm");
        return lineItem;
    }
}

