/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.promote;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.StringUtil;
import com.evergage.android.promote.Article;
import com.evergage.android.promote.Blog;
import com.evergage.android.promote.Category;
import com.evergage.android.promote.Location;
import com.evergage.android.promote.Product;
import com.evergage.android.promote.Tag;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class Item {
    static final String TAG = Item.class.getSimpleName();
    @NonNull
    public String id;
    @Nullable
    public String name;
    @Nullable
    public String description;
    @Nullable
    public String url;
    @Nullable
    public String imageUrl;
    @Nullable
    public Location location;
    @Nullable
    public List<Tag> tags;
    @Nullable
    public Double rating;
    @Nullable
    @IntRange(from=0L)
    public Integer numRatings;
    @Nullable
    public String promotionState;
    @Nullable
    public Date published;
    @Nullable
    public Date expiration;

    Item(@NonNull String id2) {
        if (!StringUtil.isValid(id2)) {
            IllegalArgumentException e = new IllegalArgumentException();
            Logger.log(1000, TAG, e, this.getClass().getSimpleName(), " is invalid: id is null or empty. Set id to a valid value to fix.");
        }
        this.id = id2;
    }

    @Nullable
    public JSONObject toJSONObject() {
        String typeToSend;
        String itemClass;
        if (!StringUtil.isValid(this.id)) {
            Logger.log(1000, TAG, null, "Dropping ", this.getClass().getSimpleName(), " before sending to server: id is null or empty.");
            return null;
        }
        switch (itemClass = this.getClass().getSimpleName()) {
            case "Article": {
                typeToSend = "a";
                break;
            }
            case "Blog": {
                typeToSend = "b";
                break;
            }
            case "Category": {
                typeToSend = "c";
                break;
            }
            case "Product": {
                typeToSend = "p";
                break;
            }
            case "Tag": {
                typeToSend = "t";
                break;
            }
            default: {
                Logger.log(1000, TAG, null, "toJSONObject failed, unknown Item class: ", itemClass);
                return null;
            }
        }
        JSONObject json = new JSONObject();
        JSONUtil.put(json, "type", typeToSend);
        JSONUtil.put(json, "_id", this.id);
        JSONUtil.put(json, "name", StringUtil.truncate("name", this.name));
        JSONUtil.put(json, "description", StringUtil.truncate("description", this.description));
        JSONUtil.put(json, "url", this.url);
        JSONUtil.put(json, "imageUrl", this.imageUrl);
        if (this.published != null) {
            JSONUtil.put(json, "published", this.published.getTime());
        }
        if (this.expiration != null) {
            JSONUtil.put(json, "expiration", this.expiration.getTime());
        }
        if (this.location != null) {
            JSONUtil.put(json, "location", this.location.toJSONObject());
        }
        JSONUtil.put(json, "rating", this.rating);
        JSONUtil.put(json, "numRatings", this.numRatings);
        if (this.tags != null) {
            JSONArray jsonTags = new JSONArray();
            ArrayList<Tag> currentTags = new ArrayList<Tag>(this.tags);
            for (Tag tag : currentTags) {
                JSONObject jsonTag;
                if (tag == null || (jsonTag = tag.toJSONObject()) == null) continue;
                JSONUtil.arrayPut(jsonTags, jsonTag, true);
            }
            if (jsonTags.length() > 0) {
                JSONUtil.put(json, "tags", jsonTags);
            }
        }
        if (this.promotionState != null && (this.promotionState.equals("Excluded") || this.promotionState.equals("Prioritized"))) {
            JSONUtil.put(json, "promotionState", this.promotionState);
        }
        return json;
    }

    @Nullable
    public static Item fromJSONString(@NonNull String jsonString) {
        JSONObject json = JSONUtil.jsonObjectFromString(jsonString);
        return Item.getItemFromJSONObject(json);
    }

    @Nullable
    static Item getItemFromJSONObject(@NonNull JSONObject json) {
        if (json == null) {
            Logger.log(2000, TAG, null, "from JSON, json null");
            return null;
        }
        String id2 = JSONUtil.getString(json, "_id");
        if (!StringUtil.isValid(id2)) {
            Logger.log(2000, TAG, null, "from JSON, missing or empty id");
            return null;
        }
        String itemType = JSONUtil.getString(json, "type");
        if (itemType != null) {
            switch (itemType) {
                case "p": {
                    return Product.fromJSONObject(json, id2);
                }
                case "a": {
                    return Article.fromJSONObject(json, id2);
                }
                case "b": {
                    return Blog.fromJSONObject(json, id2);
                }
                case "c": {
                    return Category.fromJSONObject(json, id2);
                }
                case "t": {
                    return Tag.fromJSONObject(json, id2);
                }
            }
        }
        Logger.log(2000, TAG, null, "from JSON, invalid item type ", itemType);
        return null;
    }

    void setFieldsFromJson(JSONObject json) {
        this.name = JSONUtil.getString(json, "name");
        this.description = JSONUtil.getString(json, "description");
        this.url = JSONUtil.getString(json, "url");
        this.imageUrl = JSONUtil.getString(json, "imageUrl");
        this.location = Location.fromJSONObject(JSONUtil.getJSONObject(json, "location"));
        this.rating = JSONUtil.getDouble(json, "rating");
        this.numRatings = JSONUtil.getInteger(json, "numRatings");
        Long publishedJson = JSONUtil.getLong(json, "published");
        this.published = publishedJson == null ? null : new Date(publishedJson);
        Long expirationJson = JSONUtil.getLong(json, "expiration");
        this.expiration = expirationJson == null ? null : new Date(expirationJson);
        String promoStateJson = JSONUtil.getString(json, "promotionState");
        if (promoStateJson != null && (promoStateJson.equals("Prioritized") || promoStateJson.equals("Excluded"))) {
            this.promotionState = promoStateJson;
        }
        this.tags = null;
        JSONArray tagsFromJson = JSONUtil.getJSONArray(json, "tags");
        ArrayList<Tag> tagsList = new ArrayList<Tag>();
        if (tagsFromJson != null) {
            for (int i = 0; i < tagsFromJson.length(); ++i) {
                Tag currentTag = (Tag)Item.getItemFromJSONObject(JSONUtil.arrayGetJSONObject(tagsFromJson, i));
                if (currentTag == null) continue;
                tagsList.add(currentTag);
            }
            if (tagsList.size() > 0) {
                this.tags = tagsList;
            }
        }
    }
}

