/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.promote;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.promote.Category;
import com.evergage.android.promote.Item;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class CategorizedItem
extends Item {
    @Nullable
    public List<Category> categories;

    CategorizedItem(@NonNull String id2) {
        super(id2);
    }

    @Override
    @Nullable
    public JSONObject toJSONObject() {
        JSONObject categorizedJson = super.toJSONObject();
        if (categorizedJson == null) {
            return null;
        }
        if (this.categories != null) {
            JSONArray jsonCategories = new JSONArray();
            ArrayList<Category> currentCats = new ArrayList<Category>(this.categories);
            for (Category category : currentCats) {
                JSONObject jsonCategory;
                if (category == null || (jsonCategory = category.toJSONObject()) == null) continue;
                JSONUtil.arrayPut(jsonCategories, jsonCategory, true);
            }
            if (jsonCategories.length() > 0) {
                JSONUtil.put(categorizedJson, "categories", jsonCategories);
            }
        }
        return categorizedJson;
    }

    @Override
    void setFieldsFromJson(@NonNull JSONObject json) {
        super.setFieldsFromJson(json);
        this.categories = null;
        JSONArray categoriesFromJson = JSONUtil.getJSONArray(json, "categories");
        ArrayList<Category> categoriesList = new ArrayList<Category>();
        if (categoriesFromJson != null) {
            for (int i = 0; i < categoriesFromJson.length(); ++i) {
                Category currentCategory = (Category)Item.getItemFromJSONObject(JSONUtil.arrayGetJSONObject(categoriesFromJson, i));
                if (currentCategory == null) continue;
                categoriesList.add(currentCategory);
            }
            if (categoriesList.size() > 0) {
                this.categories = categoriesList;
            }
        }
    }
}

