/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.promote;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.StringUtil;
import com.evergage.android.promote.CategorizedItem;
import java.util.Date;
import org.json.JSONObject;

public class Blog
extends CategorizedItem {
    @Nullable
    public Date modifiedDate;
    @Nullable
    public String subTitle;

    public Blog(@NonNull String id2) {
        super(id2);
    }

    @Override
    @Nullable
    public JSONObject toJSONObject() {
        JSONObject blogJson = super.toJSONObject();
        if (blogJson == null) {
            return null;
        }
        JSONUtil.put(blogJson, "modifiedDate", this.modifiedDate == null ? null : Long.valueOf(this.modifiedDate.getTime()));
        JSONUtil.put(blogJson, "subtitle", StringUtil.truncate("subTitle", this.subTitle));
        return blogJson;
    }

    @Nullable
    public static Blog fromJSONObject(@NonNull JSONObject json, @NonNull String id2) {
        Blog newBlog = new Blog(id2);
        newBlog.setFieldsFromJson(json);
        Long modifiedLong = JSONUtil.getLong(json, "modifiedDate");
        newBlog.modifiedDate = modifiedLong == null ? null : new Date(modifiedLong);
        newBlog.subTitle = JSONUtil.getString(json, "subtitle");
        return newBlog;
    }
}

