/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal.util;

import android.graphics.Color;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.Logger;
import java.util.regex.Pattern;

public class StringUtil {
    private static final int TRUNCATION_MAX_LENGTH = 1024;
    private static final Pattern sPatternAlphaNumeric = Pattern.compile("[^a-zA-Z0-9]");

    public static boolean isValid(@Nullable CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    @Nullable
    public static String trimString(@NonNull String fieldName, @Nullable String string) {
        if (string == null) {
            return null;
        }
        String newString = string.trim();
        if (string.length() != newString.length()) {
            Logger.log(3000, "StringUtil", null, "Trimmed white space around ", fieldName);
        }
        return newString;
    }

    @Nullable
    public static String truncate(@NonNull String fieldName, @Nullable String str) {
        if (str == null || str.length() <= 1024) {
            return str;
        }
        Logger.log(2000, "StringUtil", null, "Truncating ", fieldName, " to length ", Integer.toString(1024), " before sending");
        return str.substring(0, 1024);
    }

    public static boolean onlyAlphaNumericCharsInString(@Nullable String string) {
        return !StringUtil.isValid(string) || !sPatternAlphaNumeric.matcher(string).find();
    }

    @Nullable
    public static Integer colorFromHexString(@NonNull String hexString) {
        if (hexString == null || !hexString.startsWith("#") || hexString.length() != 7 && hexString.length() != 9) {
            Logger.log(2000, "Color", null, "Not supported: ", hexString);
            return null;
        }
        try {
            if (hexString.length() == 9) {
                hexString = "#" + hexString.substring(7, 9) + hexString.substring(1, 7);
            }
            return Color.parseColor((String)hexString);
        }
        catch (Exception e) {
            Logger.log(2000, "Color", null, "Unable to parse color: ", hexString);
            return null;
        }
    }
}

