/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal.util;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SafetyUtil {
    private static final String TAG = "SafetyUtil";
    public static final Looper sMainLooper = Looper.getMainLooper();
    public static final Handler sMainHandler = new Handler(sMainLooper);
    static volatile boolean throwAsserts = false;
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(@NonNull Runnable r) {
            return new Thread(r, "EVG #" + this.mCount.getAndIncrement());
        }
    };
    private static final Executor sThreadPoolExecutor;

    public static void assertOnMain() {
        if (Looper.myLooper() != sMainLooper) {
            SafetyUtil.assertFail(0, "Called on non-main thread", null, false);
        }
    }

    public static void assertFail(int logLevel, @NonNull String message, @Nullable Throwable optionalCause, boolean logError) {
        Error e = new Error(message, optionalCause);
        Logger.log(logLevel, TAG, logError ? e : null, message);
        if (throwAsserts) {
            throw e;
        }
    }

    public static void closeSafely(Closeable closeable, boolean logException) {
        block3: {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (!logException) break block3;
                Logger.log(2000, TAG, e, "Error closing");
            }
        }
    }

    public static boolean runOnMain(@NonNull SafeRunnable safeRunnable) {
        if (safeRunnable == null) {
            NullPointerException e = new NullPointerException("null safeRunnable");
            SafetyUtil.assertFail(2000, "RunOnMain exception", e, true);
            return false;
        }
        if (Looper.myLooper() == sMainLooper) {
            safeRunnable.run();
            return true;
        }
        return SafetyUtil.runAsyncOnHandler(sMainHandler, safeRunnable);
    }

    public static boolean runOnMainUNSAFE(@NonNull Runnable runnable) {
        if (runnable == null) {
            NullPointerException e = new NullPointerException("null runnable");
            SafetyUtil.assertFail(2000, "RunOnMainExternal exception", e, true);
            return false;
        }
        if (Looper.myLooper() == sMainLooper) {
            runnable.run();
            return true;
        }
        if (!sMainHandler.post(runnable)) {
            IllegalThreadStateException e = new IllegalThreadStateException("post rejected");
            SafetyUtil.assertFail(1000, "RunOnMainExternal exception", e, true);
            return false;
        }
        return true;
    }

    public static boolean runAfterDelay(long millis, @NonNull Handler handler, @NonNull WeakSafeRunnable weakSafeRunnable) {
        if (handler == null) {
            NullPointerException e = new NullPointerException("null handler");
            SafetyUtil.assertFail(1000, "RunAfterDelay exception", e, true);
            return false;
        }
        if (weakSafeRunnable == null) {
            NullPointerException e = new NullPointerException("null weakSafeRunnable");
            SafetyUtil.assertFail(2000, "RunAfterDelay exception", e, true);
            return false;
        }
        if (!handler.postDelayed((Runnable)weakSafeRunnable, millis)) {
            IllegalThreadStateException e = new IllegalThreadStateException("postDelayed rejected");
            SafetyUtil.assertFail(1000, "RunAfterDelay exception", e, true);
            return false;
        }
        return true;
    }

    public static boolean runAsyncOnHandler(@NonNull Handler handler, @NonNull SafeRunnable safeRunnable) {
        if (handler == null) {
            NullPointerException e = new NullPointerException("null handler");
            SafetyUtil.assertFail(1000, "RunAsyncOnHandler exception", e, true);
            return false;
        }
        if (safeRunnable == null) {
            NullPointerException e = new NullPointerException("null safeRunnable");
            SafetyUtil.assertFail(2000, "RunAsyncOnHandler exception", e, true);
            return false;
        }
        if (!handler.post((Runnable)safeRunnable)) {
            IllegalThreadStateException e = new IllegalThreadStateException("post rejected");
            SafetyUtil.assertFail(1000, "RunAsyncOnHandler exception", e, true);
            return false;
        }
        return true;
    }

    public static boolean runInBackground(@NonNull SafeRunnable safeRunnable) {
        if (safeRunnable == null) {
            NullPointerException e = new NullPointerException("null safeRunnable");
            SafetyUtil.assertFail(2000, "RunInBackground exception", e, true);
            return false;
        }
        try {
            sThreadPoolExecutor.execute(safeRunnable);
            return true;
        }
        catch (RejectedExecutionException e) {
            SafetyUtil.assertFail(1000, "RunInBackground exception", e, true);
            return false;
        }
    }

    static {
        int numNetworkRequestTypes = 3;
        int corePoolSize = Math.max(numNetworkRequestTypes, Runtime.getRuntime().availableProcessors()) + 1;
        sThreadPoolExecutor = new ThreadPoolExecutor(corePoolSize, corePoolSize * 2 + 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), sThreadFactory);
    }

    public static abstract class SafeRunnable
    implements Runnable {
        private final CountDownLatch finishedLatch = new CountDownLatch(1);
        volatile long started;
        volatile long finished;
        volatile Exception exceptionCaught;
        public volatile String exceptionLogMessage;

        public abstract void runImpl();

        public final boolean waitUntilFinished(long millis) {
            try {
                return this.finishedLatch.await(millis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        @Override
        public final void run() {
            try {
                this.started = System.currentTimeMillis();
                this.runImpl();
            }
            catch (Exception e) {
                this.exceptionCaught = e;
                String message = this.exceptionLogMessage;
                if (message == null || message.isEmpty()) {
                    message = "SafeRunnable run exception";
                }
                SafetyUtil.assertFail(1000, message, e, true);
            }
            finally {
                this.finished = System.currentTimeMillis();
                this.finishedLatch.countDown();
            }
        }
    }

    public static class WeakSafeRunnable
    extends SafeRunnable {
        final WeakReference<SafeRunnable> weakDelegate;

        public WeakSafeRunnable(@NonNull SafeRunnable delegate) {
            this.weakDelegate = new WeakReference<SafeRunnable>(delegate);
        }

        @Override
        public void runImpl() {
            SafeRunnable delegate = (SafeRunnable)this.weakDelegate.get();
            if (delegate == null) {
                Logger.log(4000, SafetyUtil.TAG, null, "WeakSafeRunnable run, instance null");
            } else {
                delegate.run();
            }
        }
    }

    public static class Timer {
        private final Handler handler;
        private final SafeRunnable safeRunnable;
        private WeakSafeRunnable weakSafeRunnable;

        public Timer(@NonNull Handler handler, @NonNull SafeRunnable safeRunnable) {
            this.handler = handler;
            this.safeRunnable = safeRunnable;
        }

        public void restartWithDelay(long delayMillis) {
            this.cancel();
            this.weakSafeRunnable = this.safeRunnable instanceof WeakSafeRunnable ? (WeakSafeRunnable)this.safeRunnable : new WeakSafeRunnable(this.safeRunnable);
            if (!SafetyUtil.runAfterDelay(delayMillis, this.handler, this.weakSafeRunnable)) {
                this.weakSafeRunnable = null;
            }
        }

        public void cancel() {
            if (this.handler == null || this.weakSafeRunnable == null) {
                return;
            }
            this.handler.removeCallbacks((Runnable)this.weakSafeRunnable);
            this.weakSafeRunnable.weakDelegate.clear();
            this.weakSafeRunnable = null;
        }

        public boolean isCancelledOrNotStarted() {
            return this.weakSafeRunnable == null;
        }
    }

    public static class ConstructionException
    extends Exception {
        public ConstructionException(int level, @NonNull String tag, @Nullable Throwable cause, @NonNull String message) {
            super(message, cause);
            if (level > 0) {
                Logger.log(level, tag, cause, message);
            }
        }
    }
}

