/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal.util;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.StringUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class PromoteUtil {
    private static final Set<String> REQUIRED_ITEM_FIELDS;
    private static final Set<String> REQUIRED_CATEGORY_FIELDS;
    private static final Set<String> REQUIRED_TAG_FIELDS;
    private static final Set<String> SPARSE_ITEM_FIELDS;
    private static final Set<String> KNOWN_ITEM_FIELDS;
    private static final Set<String> KNOWN_CATEGORIZED_ITEM_FIELDS;
    private static final Set<String> KNOWN_BLOG_OR_ARTICLE_FIELDS;
    private static final Set<String> KNOWN_PRODUCT_FIELDS;
    private static final Set<String> KNOWN_CATEGORY_FIELDS;
    private static final Set<String> KNOWN_TAG_FIELDS;
    private static final Set<String> KNOWN_ORDER_FIELDS;
    private static final Set<String> KNOWN_LINE_ITEM_FIELDS;
    private static final Set<String> KNOWN_REVIEW_FIELDS;
    private static volatile int promoteWarnings;
    private static final String TAG = "PromoteUtil";

    @Nullable
    public static JSONObject sparsifyItem(@NonNull JSONObject item) {
        JSONArray tags;
        if (item == null) {
            return null;
        }
        if (PromoteUtil.isWrongKindOfClass(item, "item", JSONObject.class)) {
            return null;
        }
        JSONObject sparseItem = PromoteUtil.pickFields(item, SPARSE_ITEM_FIELDS);
        if (!PromoteUtil.itemHasRequiredStringFields(sparseItem, "sparseItem")) {
            return null;
        }
        JSONArray categories = (JSONArray)JSONUtil.get(sparseItem, "categories");
        if (PromoteUtil.isWrongKindOfClass(categories, "categories", JSONArray.class)) {
            return null;
        }
        sparseItem.remove("categories");
        if (categories != null) {
            JSONArray sparseCategories = new JSONArray();
            for (int i = 0; i < categories.length(); ++i) {
                JSONObject category = JSONUtil.arrayGetJSONObject(categories, i);
                if (PromoteUtil.isWrongKindOfClass(category, "category", JSONObject.class)) {
                    return null;
                }
                JSONObject sparseCategory = PromoteUtil.pickFields(category, REQUIRED_CATEGORY_FIELDS);
                if (!PromoteUtil.itemHasRequiredStringFields(sparseCategory, "sparseCategory")) {
                    return null;
                }
                PromoteUtil.logUnknownItemFields(sparseCategory);
                JSONUtil.arrayPut(sparseCategories, sparseCategory, true);
            }
            if (sparseCategories.length() > 0) {
                JSONUtil.put(sparseItem, "categories", sparseCategories);
            }
        }
        if (PromoteUtil.isWrongKindOfClass(tags = (JSONArray)JSONUtil.get(sparseItem, "tags"), "tags", JSONArray.class)) {
            return null;
        }
        sparseItem.remove("tags");
        if (tags != null) {
            JSONArray sparseTags = new JSONArray();
            for (int i = 0; i < tags.length(); ++i) {
                JSONObject tag = JSONUtil.arrayGetJSONObject(tags, i);
                if (PromoteUtil.isWrongKindOfClass(tag, "tag", JSONObject.class)) {
                    return null;
                }
                JSONObject sparseTag = PromoteUtil.pickFields(tag, REQUIRED_TAG_FIELDS);
                if (!PromoteUtil.itemHasRequiredStringFields(sparseTag, "sparseTag")) {
                    return null;
                }
                PromoteUtil.logUnknownItemFields(sparseTag);
                JSONUtil.arrayPut(sparseTags, sparseTag, true);
            }
            if (sparseTags.length() > 0) {
                JSONUtil.put(sparseItem, "tags", sparseTags);
            }
        }
        return sparseItem;
    }

    @Nullable
    public static JSONObject sparsifyLineItem(@NonNull JSONObject lineItem) {
        if (lineItem == null) {
            return null;
        }
        if (PromoteUtil.isWrongKindOfClass(lineItem, "lineItem", JSONObject.class)) {
            return null;
        }
        JSONObject sparseLineItem = JSONUtil.shallowCopy(lineItem);
        if (sparseLineItem == null) {
            return null;
        }
        JSONObject item = JSONUtil.getJSONObject(sparseLineItem, "item");
        if (item == null) {
            return null;
        }
        JSONObject sparseItem = PromoteUtil.sparsifyItem(item);
        if (sparseItem == null) {
            return null;
        }
        JSONUtil.put(sparseLineItem, "item", sparseItem);
        return sparseLineItem;
    }

    @Nullable
    public static JSONObject sparsifyLineItemsInOrder(@NonNull JSONObject order) {
        JSONObject sparseOrder = JSONUtil.shallowCopy(order);
        if (sparseOrder == null) {
            return null;
        }
        JSONArray lineItems = (JSONArray)JSONUtil.get(sparseOrder, "lineItems");
        if (PromoteUtil.isWrongKindOfClass(lineItems, "lineItems", JSONArray.class)) {
            return null;
        }
        sparseOrder.remove("lineItems");
        if (lineItems != null) {
            JSONArray sparseLineItems = new JSONArray();
            for (int i = 0; i < lineItems.length(); ++i) {
                JSONObject sparseLineItem = PromoteUtil.sparsifyLineItem((JSONObject)JSONUtil.arrayGet(lineItems, i));
                if (sparseLineItem == null) continue;
                JSONUtil.arrayPut(sparseLineItems, sparseLineItem, true);
            }
            if (sparseLineItems.length() > 0) {
                JSONUtil.put(sparseOrder, "lineItems", sparseLineItems);
            }
        }
        return sparseOrder;
    }

    private static void logUnknownFields(@Nullable JSONObject item, @NonNull String objectName, @NonNull Set<String> knownFields) {
        if (item == null) {
            return;
        }
        Iterator keys = item.keys();
        while (keys.hasNext()) {
            String currentKey = (String)keys.next();
            if (knownFields.contains(currentKey)) continue;
            ++promoteWarnings;
            String itemId = JSONUtil.getString(item, "_id");
            Logger.log(2000, TAG, null, "Item ID [", itemId, "]: Unknown field [", currentKey, "] for [", objectName, "]");
        }
    }

    @NonNull
    private static JSONObject pickFields(@Nullable JSONObject sourceObject, @NonNull Set<String> fieldNames) {
        JSONObject pickedObject = new JSONObject();
        if (sourceObject != null) {
            for (String name : fieldNames) {
                Object fieldValue = JSONUtil.get(sourceObject, name);
                if (fieldValue == null) continue;
                JSONUtil.put(pickedObject, name, fieldValue);
            }
        }
        return pickedObject;
    }

    public static boolean itemHasRequiredStringFields(@Nullable JSONObject itemJson, @NonNull String name) {
        if (itemJson == null) {
            ++promoteWarnings;
            Logger.log(1000, TAG, null, name, " to be serialized was null");
            return false;
        }
        String itemType = JSONUtil.getString(itemJson, "type");
        Set<String> requiredFields = REQUIRED_ITEM_FIELDS;
        if (itemType != null) {
            switch (itemType) {
                case "c": {
                    requiredFields = REQUIRED_CATEGORY_FIELDS;
                    break;
                }
                case "t": {
                    requiredFields = REQUIRED_TAG_FIELDS;
                }
            }
        }
        for (String fieldName : requiredFields) {
            Object value = JSONUtil.get(itemJson, fieldName);
            if (PromoteUtil.isWrongKindOfClass(value, fieldName, String.class)) {
                return false;
            }
            if (StringUtil.isValid((String)value)) continue;
            ++promoteWarnings;
            Logger.log(1000, TAG, null, name, " was missing the required field ", fieldName);
            return false;
        }
        return true;
    }

    public static boolean isRequiredObjectMissing(@Nullable JSONObject jsonObject, @NonNull String objectName) {
        if (jsonObject == null) {
            ++promoteWarnings;
            Logger.log(1000, TAG, null, "Required ", objectName, " was not provided");
            return true;
        }
        return false;
    }

    public static void logUnknownItemFields(@Nullable JSONObject item) {
        String itemType = null;
        if (item != null) {
            itemType = JSONUtil.getString(item, "type");
        }
        if (itemType != null) {
            switch (itemType) {
                case "p": {
                    PromoteUtil.logUnknownFields(item, "Product", KNOWN_PRODUCT_FIELDS);
                    return;
                }
                case "a": {
                    PromoteUtil.logUnknownFields(item, "Article", KNOWN_BLOG_OR_ARTICLE_FIELDS);
                    return;
                }
                case "b": {
                    PromoteUtil.logUnknownFields(item, "Blog", KNOWN_BLOG_OR_ARTICLE_FIELDS);
                    return;
                }
                case "c": {
                    PromoteUtil.logUnknownFields(item, "Category", KNOWN_CATEGORY_FIELDS);
                    return;
                }
                case "t": {
                    PromoteUtil.logUnknownFields(item, "Tag", KNOWN_TAG_FIELDS);
                    return;
                }
            }
        }
        ++promoteWarnings;
        Logger.log(2000, TAG, null, "Items: from JSON, invalid item type ", itemType);
    }

    public static void logUnknownReviewFields(@Nullable JSONObject reviewDetails) {
        PromoteUtil.logUnknownFields(reviewDetails, "Review", KNOWN_REVIEW_FIELDS);
    }

    public static void logUnknownLineItemFields(@Nullable JSONObject lineItem) {
        PromoteUtil.logUnknownFields(lineItem, "LineItem", KNOWN_LINE_ITEM_FIELDS);
    }

    public static void logUnknownOrderFields(@Nullable JSONObject order) {
        PromoteUtil.logUnknownFields(order, "Order", KNOWN_ORDER_FIELDS);
    }

    private static boolean isWrongKindOfClass(@Nullable Object instance, @NonNull String name, @NonNull Class clazz) {
        if (instance != null && instance.getClass() != clazz) {
            ++promoteWarnings;
            Logger.log(1000, TAG, null, name, " should be class ", clazz.getCanonicalName(), " but was ", instance.getClass().getCanonicalName());
            return true;
        }
        return false;
    }

    public static void resetPromoteWarnings() {
        promoteWarnings = 0;
    }

    static {
        HashSet<Object> set = new HashSet<String>();
        set.add("_id");
        set.add("type");
        REQUIRED_ITEM_FIELDS = Collections.unmodifiableSet(set);
        REQUIRED_CATEGORY_FIELDS = REQUIRED_ITEM_FIELDS;
        set = new HashSet();
        set.add("_id");
        set.add("type");
        set.add("tagType");
        REQUIRED_TAG_FIELDS = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("_id");
        set.add("type");
        set.add("price");
        set.add("currency");
        set.add("categories");
        set.add("tags");
        set.add("tagType");
        SPARSE_ITEM_FIELDS = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("_id");
        set.add("type");
        set.add("name");
        set.add("description");
        set.add("url");
        set.add("imageUrl");
        set.add("tags");
        set.add("promotionState");
        set.add("published");
        set.add("expiration");
        set.add("location");
        set.add("rating");
        set.add("numRatings");
        KNOWN_ITEM_FIELDS = Collections.unmodifiableSet(set);
        set = new HashSet<String>(KNOWN_ITEM_FIELDS);
        set.add("categories");
        KNOWN_CATEGORIZED_ITEM_FIELDS = Collections.unmodifiableSet(set);
        set = new HashSet<String>(KNOWN_CATEGORIZED_ITEM_FIELDS);
        set.add("modifiedDate");
        set.add("subtitle");
        KNOWN_BLOG_OR_ARTICLE_FIELDS = Collections.unmodifiableSet(set);
        set = new HashSet<String>(KNOWN_CATEGORIZED_ITEM_FIELDS);
        set.add("price");
        set.add("priceDescription");
        set.add("listPrice");
        set.add("currency");
        set.add("inventoryCount");
        set.add("alternateId");
        set.add("isProduct");
        KNOWN_PRODUCT_FIELDS = Collections.unmodifiableSet(set);
        set = new HashSet<String>(KNOWN_ITEM_FIELDS);
        set.add("isDepartment");
        KNOWN_CATEGORY_FIELDS = Collections.unmodifiableSet(set);
        set = new HashSet<String>(KNOWN_ITEM_FIELDS);
        set.add("tagType");
        KNOWN_TAG_FIELDS = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("item");
        set.add("quantity");
        set.add("attributedTerm");
        KNOWN_LINE_ITEM_FIELDS = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("orderId");
        set.add("lineItems");
        set.add("totalValue");
        set.add("totalValueCurrency");
        KNOWN_ORDER_FIELDS = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("date");
        set.add("itemId");
        set.add("rating");
        set.add("title");
        set.add("content");
        set.add("userDisplayName");
        set.add("purchased");
        KNOWN_REVIEW_FIELDS = Collections.unmodifiableSet(set);
    }
}

