/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal.util;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.StringUtil;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONUtil {
    private static final String TAG = "JSONUtil";

    @Nullable
    public static JSONObject jsonObjectFromString(@NonNull String json) {
        if (!StringUtil.isValid(json)) {
            Logger.log(2000, TAG, null, "JSONObject: string null/empty");
            return null;
        }
        try {
            return new JSONObject(json);
        }
        catch (Exception e) {
            Logger.log(2000, TAG, e, "JSONObject: Couldn't deserialize : ", json);
            return null;
        }
    }

    @Nullable
    public static JSONObject shallowCopy(@NonNull JSONObject obj) {
        if (obj == null) {
            return null;
        }
        JSONArray names = obj.names();
        if (names == null) {
            return obj;
        }
        try {
            String[] arr = new String[names.length()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = names.optString(i);
            }
            return new JSONObject(obj, arr);
        }
        catch (Exception e) {
            Logger.log(2000, TAG, e, "JSONObject: Error making shallow copy of ", obj.toString());
            return null;
        }
    }

    public static void put(@NonNull JSONObject object, @NonNull String key, @Nullable Object value) {
        if (!StringUtil.isValid(key)) {
            Logger.log(2000, TAG, null, "JSONObject: Not allowing inserting null/empty key for value [", value == null ? null : value.toString(), "]");
            return;
        }
        try {
            object.put(key, value);
        }
        catch (Exception e) {
            Logger.log(2000, TAG, e, "JSONObject: Error inserting [", key, "] into value [", value == null ? null : value.toString(), "]");
        }
    }

    public static void putAll(@NonNull JSONObject toObject, @NonNull JSONObject fromObject) {
        if (toObject == null || fromObject == null) {
            Logger.log(2000, TAG, null, "JSONObject: Put all: ", toObject == null ? "toObject null " : "", fromObject == null ? "fields null" : "");
            return;
        }
        Iterator keys = fromObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            JSONUtil.put(toObject, key, JSONUtil.get(fromObject, key));
        }
    }

    @Nullable
    public static Object get(@NonNull JSONObject object, @NonNull String key) {
        try {
            return object.get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static String getString(@NonNull JSONObject object, @NonNull String key) {
        try {
            return object.getString(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Boolean getBoolean(@NonNull JSONObject object, @NonNull String key) {
        try {
            return object.getBoolean(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Integer getInteger(@NonNull JSONObject object, @NonNull String key) {
        try {
            return object.getInt(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Double getDouble(@NonNull JSONObject object, @NonNull String key) {
        try {
            return object.getDouble(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Long getLong(@NonNull JSONObject object, @NonNull String key) {
        try {
            return object.getLong(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static JSONObject getJSONObject(@NonNull JSONObject object, @NonNull String key) {
        try {
            return object.getJSONObject(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static JSONArray getJSONArray(@NonNull JSONObject object, @NonNull String key) {
        try {
            return object.getJSONArray(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Object objectOfType(@NonNull Class clazz, @NonNull String key, @NonNull JSONObject fromJSON) {
        return JSONUtil.objectOfType(clazz, key, fromJSON, false);
    }

    @Nullable
    private static Object objectOfType(@NonNull Class clazz, @NonNull String key, @NonNull JSONObject fromJSON, boolean logNull) {
        if (!StringUtil.isValid(key) || fromJSON == null || clazz == null) {
            return null;
        }
        Object obj = JSONUtil.get(fromJSON, key);
        if (obj == null) {
            return null;
        }
        if (!obj.getClass().equals(clazz) && !clazz.isAssignableFrom(obj.getClass())) {
            if (logNull) {
                Logger.log(1000, TAG, null, "keyPath: ", key, " expected class: ", clazz.getSimpleName(), " but found class: ", obj.getClass().getSimpleName());
            }
            return null;
        }
        return obj;
    }

    public static boolean jsonObjectsEqual(@Nullable JSONObject one, @Nullable JSONObject two) {
        if (one == two) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one.equals(two)) {
            return true;
        }
        if (one.length() != two.length()) {
            return false;
        }
        Iterator oneKeys = one.keys();
        while (oneKeys.hasNext()) {
            Object twoValue;
            String oneKey = (String)oneKeys.next();
            Object oneValue = JSONUtil.get(one, oneKey);
            if (oneValue == (twoValue = JSONUtil.get(two, oneKey))) continue;
            if (oneValue == null || twoValue == null) {
                return false;
            }
            if (!(oneValue instanceof JSONObject && twoValue instanceof JSONObject ? !JSONUtil.jsonObjectsEqual((JSONObject)oneValue, (JSONObject)twoValue) : (oneValue instanceof JSONArray && twoValue instanceof JSONArray ? !JSONUtil.jsonArraysEqual((JSONArray)oneValue, (JSONArray)twoValue) : !oneValue.equals(twoValue)))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static JSONArray jsonArrayFromString(@NonNull String json) {
        if (!StringUtil.isValid(json)) {
            Logger.log(2000, TAG, null, "JSONArray: string null/empty");
            return null;
        }
        try {
            return new JSONArray(json);
        }
        catch (Exception e) {
            Logger.log(2000, TAG, e, "JSONArray: Couldn't deserialize : ", json);
            return null;
        }
    }

    public static void arrayPut(@NonNull JSONArray array, @NonNull Object value, boolean logMessage) {
        block2: {
            try {
                array.put(value);
            }
            catch (Exception e) {
                if (!logMessage) break block2;
                Logger.log(2000, TAG, e, "JSONArray: Error putting ", value == null ? null : value.toString());
            }
        }
    }

    @Nullable
    public static Object arrayGet(@NonNull JSONArray array, int index) {
        try {
            return array.get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static String arrayGetString(@NonNull JSONArray array, int index) {
        try {
            return array.getString(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Double arrayGetDouble(@NonNull JSONArray array, int index) {
        try {
            return array.getDouble(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static JSONObject arrayGetJSONObject(@NonNull JSONArray array, int index) {
        try {
            return array.getJSONObject(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean jsonArraysEqual(@Nullable JSONArray one, @Nullable JSONArray two) {
        if (one == two) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one.equals((Object)two)) {
            return true;
        }
        if (one.length() != two.length()) {
            return false;
        }
        for (int i = 0; i < one.length(); ++i) {
            Object twoValue;
            Object oneValue = JSONUtil.arrayGet(one, i);
            if (oneValue == (twoValue = JSONUtil.arrayGet(two, i))) continue;
            if (oneValue == null || twoValue == null) {
                return false;
            }
            if (!(oneValue instanceof JSONObject && twoValue instanceof JSONObject ? !JSONUtil.jsonObjectsEqual((JSONObject)oneValue, (JSONObject)twoValue) : (oneValue instanceof JSONArray && twoValue instanceof JSONArray ? !JSONUtil.jsonArraysEqual((JSONArray)oneValue, (JSONArray)twoValue) : !oneValue.equals(twoValue)))) continue;
            return false;
        }
        return true;
    }
}

