/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal.util;

import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import androidx.annotation.Nullable;
import com.evergage.android.EvergageActivity;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.StringUtil;
import java.lang.reflect.Field;

public class HostAppUtil {
    private static final String TAG = "HostAppUtil";
    private static Boolean buildConfigDebug = null;
    private static String defaultActivityState = null;

    @Nullable
    public static Long appInstallDateInMillis() {
        Context appContext = DependencyManager.getAppContext();
        if (appContext == null) {
            Logger.log(4000, TAG, null, "App Context null, unable to get app install date");
            return null;
        }
        PackageManager pm = appContext.getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(HostAppUtil.packageName(), 0);
            return packageInfo.firstInstallTime;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.log(1000, TAG, null, "Unable to get app install date, package not found : ", HostAppUtil.packageName());
            return null;
        }
    }

    @Nullable
    public static Long appUpgradedDateInMillis() {
        Context appContext = DependencyManager.getAppContext();
        if (appContext == null) {
            Logger.log(4000, TAG, null, "App Context null, unable to get app upgraded date");
            return null;
        }
        PackageManager pm = appContext.getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(HostAppUtil.packageName(), 0);
            return packageInfo.lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.log(1000, TAG, null, "Unable to get app upgraded date, package not found : ", HostAppUtil.packageName());
            return null;
        }
    }

    @Nullable
    public static String packageName() {
        Context appContext = DependencyManager.getAppContext();
        if (appContext == null) {
            Logger.log(4000, TAG, null, "App Context null, unable to get app package name");
            return null;
        }
        return appContext.getPackageName();
    }

    @Nullable
    public static String appVersionName() {
        Context appContext = DependencyManager.getAppContext();
        if (appContext == null) {
            Logger.log(4000, TAG, null, "App Context null, unable to get app version name");
            return null;
        }
        try {
            PackageInfo pInfo = appContext.getPackageManager().getPackageInfo(appContext.getPackageName(), 0);
            if (StringUtil.isValid(pInfo.versionName)) {
                return pInfo.versionName;
            }
            return String.valueOf(pInfo.versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.log(4000, TAG, e, "Unable to get app version");
            return null;
        }
    }

    @Nullable
    public static Integer appVersionCode() {
        Context appContext = DependencyManager.getAppContext();
        if (appContext == null) {
            Logger.log(4000, TAG, null, "App Context null, unable to get app version code");
            return null;
        }
        try {
            PackageInfo pInfo = appContext.getPackageManager().getPackageInfo(appContext.getPackageName(), 0);
            return pInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.log(4000, TAG, e, "Unable to get app version code");
            return null;
        }
    }

    public static boolean appIsDebugBuildOrDebuggable() {
        Application application = DependencyManager.getApplication();
        if (application == null) {
            Logger.log(4000, TAG, null, "Application null, unable to determine app debug/debuggable");
            return false;
        }
        if (HostAppUtil.getBuildConfigDebug(application)) {
            return true;
        }
        ApplicationInfo appInfo = application.getApplicationInfo();
        if (appInfo == null) {
            Logger.log(2000, TAG, null, "Unable to get ApplicationInfo");
            return false;
        }
        return (appInfo.flags & 2) != 0;
    }

    private static synchronized boolean getBuildConfigDebug(Application application) {
        if (buildConfigDebug != null) {
            return buildConfigDebug;
        }
        String packageName = HostAppUtil.packageName();
        Class<?> clazz = HostAppUtil.getBuildConfigClassForPackage(packageName);
        if (clazz == null && (packageName = application.getClass().getPackage().getName()) != null && !packageName.startsWith("android.") && !packageName.startsWith("com.google.")) {
            clazz = HostAppUtil.getBuildConfigClassForPackage(packageName);
        }
        buildConfigDebug = false;
        if (clazz == null) {
            Logger.log(4000, TAG, null, "Unable to find BuildConfig");
        } else {
            try {
                Field field = clazz.getField("DEBUG");
                Class<?> type = field.getType();
                if (type != Boolean.TYPE && type != Boolean.class) {
                    throw new Exception("DEBUG unexpected type: " + type);
                }
                buildConfigDebug = field.getBoolean(null);
            }
            catch (Exception e) {
                Logger.log(4000, TAG, e, "Unable to access BuildConfig/DEBUG");
            }
        }
        return buildConfigDebug;
    }

    @Nullable
    private static Class<?> getBuildConfigClassForPackage(String packageName) {
        try {
            return Class.forName(packageName + ".BuildConfig");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void updateManifestComponents(int desiredState) {
        Context appContext = DependencyManager.getAppContext();
        if (appContext == null) {
            Logger.log(4000, TAG, null, "App Context null, unable to update manifest components");
            return;
        }
        try {
            PackageManager pm = appContext.getPackageManager();
            ComponentName cn = new ComponentName(appContext, EvergageActivity.class);
            int currentState = pm.getComponentEnabledSetting(cn);
            String defaultState = HostAppUtil.getDefaultActivityState(pm);
            Logger.log(4000, TAG, null, "Updating/refreshing EvergageActivity state, desired: ", String.valueOf(desiredState), ", current: ", String.valueOf(currentState), ", default: ", defaultState);
            pm.setComponentEnabledSetting(cn, desiredState, 1);
        }
        catch (IllegalArgumentException e) {
            Logger.log(4000, TAG, null, "EvergageActivity not found. May have been optionally removed by manifest merge.");
        }
        catch (Exception e) {
            Logger.log(2000, TAG, e, "Unable to update/refresh EvergageActivity state.");
        }
    }

    private static String getDefaultActivityState(PackageManager pm) {
        if (defaultActivityState != null) {
            return defaultActivityState;
        }
        try {
            PackageInfo packageInfo = pm.getPackageInfo(HostAppUtil.packageName(), 513);
            for (ActivityInfo activityInfo : packageInfo.activities) {
                if (!EvergageActivity.class.getName().equals(activityInfo.name)) continue;
                defaultActivityState = activityInfo.isEnabled() ? "1" : "2";
                break;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.log(4000, TAG, null, "Unable to get default EvergageActivity state, package not found : ", HostAppUtil.packageName());
        }
        if (defaultActivityState == null) {
            defaultActivityState = "unknown";
        }
        return defaultActivityState;
    }
}

