/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import android.net.Uri;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.Config;
import com.evergage.android.internal.Constants;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.NetworkingUtil;
import com.evergage.android.internal.util.SafetyUtil;
import com.evergage.android.internal.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.json.JSONArray;
import org.json.JSONObject;

class Sender {
    protected static String TAG = "Sender";
    private static final int MAX_ERROR_RESPONSE_BYTES = 10000;
    private Config config;
    protected Uri uriConfig;
    protected Uri uriEvents;
    protected History<JSONObject> configHistory;
    protected History<JSONArray> eventHistory;

    Sender() {
        this.reset();
    }

    void reset() {
        if (this.configHistory != null) {
            ((History)this.configHistory).reset();
        }
        if (this.eventHistory != null) {
            ((History)this.eventHistory).reset();
        }
        this.config = DependencyManager.getConfig();
        this.updateConfig();
    }

    void updateConfig() {
        Uri.Builder builder;
        String account = (String)this.config.objectForKey(String.class, "account", false);
        String dataset = (String)this.config.objectForKey(String.class, "dataset", false);
        Integer port = (Integer)this.config.objectForKey(Integer.class, "port", false);
        String domain = (String)this.config.objectForKey(String.class, "domain", false);
        String protocol = (String)this.config.objectForKey(String.class, "protocol", false);
        Boolean useCDN = (Boolean)this.config.objectForKey(Boolean.class, "useCDN", false);
        if (!StringUtil.isValid(domain)) {
            domain = account + ".evergage.com";
        }
        String uriString = (String)this.config.objectForKey(String.class, "urlConfig", false);
        try {
            this.uriConfig = Uri.parse((String)uriString);
        }
        catch (Exception e) {
            if (StringUtil.isValid(uriString)) {
                Logger.log(2000, TAG, e, "Falling back to default URL for config, issue getting Uri from ", uriString);
            }
            if (!(StringUtil.isValid(account) && StringUtil.isValid(dataset) && StringUtil.isValid(domain))) {
                if (!this.config.hasEmptyLayer(1)) {
                    Logger.log(2000, TAG, e, "Could not build URL for retrieving config: account, dataset or domain invalid");
                }
                this.uriConfig = null;
            }
            builder = new Uri.Builder();
            builder.scheme(protocol);
            builder.encodedAuthority((useCDN != null && useCDN == false ? domain : "cdn.evergage.com") + ":" + port);
            builder.appendPath("api").appendPath("dataset").appendPath(dataset).appendPath("appConfig");
            builder.appendQueryParameter("_ak", account);
            try {
                this.uriConfig = builder.build();
            }
            catch (Exception e1) {
                Logger.log(1000, TAG, e1, "Could not build URL for retrieving config: issue with ", builder.toString());
                this.uriConfig = null;
            }
        }
        uriString = (String)this.config.objectForKey(String.class, "urlEvents", false);
        try {
            this.uriEvents = Uri.parse((String)uriString);
        }
        catch (Exception e) {
            if (StringUtil.isValid(uriString)) {
                Logger.log(2000, TAG, e, "Falling back to default URL for events, issue with ", uriString);
            }
            if (!(StringUtil.isValid(account) && StringUtil.isValid(dataset) && StringUtil.isValid(domain))) {
                if (!this.config.hasEmptyLayer(1)) {
                    Logger.log(2000, TAG, e, "Could not build URL for sending events: account, dataset or domain invalid");
                }
                this.uriEvents = null;
            }
            builder = new Uri.Builder();
            builder.scheme(protocol);
            builder.encodedAuthority(domain + ":" + port);
            builder.appendPath("mr").appendPath("dataset").appendPath(dataset);
            builder.appendQueryParameter("_ak", account);
            try {
                this.uriEvents = builder.build();
            }
            catch (Exception e1) {
                Logger.log(1000, TAG, e1, "Could not build URL for sending events, issue with ", builder.toString());
                this.uriEvents = null;
            }
        }
    }

    @Nullable
    protected HttpURLConnection connectionForRequest(@NonNull Request request) {
        if (request.url == null) {
            request.exception = new Exception("Request URL is null");
            return null;
        }
        try {
            return (HttpURLConnection)request.url.openConnection();
        }
        catch (Exception e) {
            request.exception = e;
            return null;
        }
    }

    private void sendRequest(final @NonNull Request request, @NonNull InternalProcessResponseCallback processResponseCallback) {
        int readTimeoutMs;
        boolean ranOrScheduled;
        final HttpURLConnection conn = this.connectionForRequest(request);
        if (conn == null) {
            Exception e = new Exception("Could not create connection", request.exception);
            SafetyUtil.assertFail(1000, "Sender exception: " + e.getMessage() + " " + (request.exception == null ? "" : request.exception.toString()), e, false);
            this.handleFailure(request, null, e);
            return;
        }
        Double timeout = this.config.doubleForKey("connectTimeout");
        if (timeout == null || timeout <= 0.0) {
            timeout = 15.0;
        }
        final int connectTimeoutMs = (int)(timeout * 1000.0);
        timeout = this.config.doubleForKey("readTimeout");
        if (timeout == null || timeout <= 0.0) {
            timeout = 30.0;
        }
        if (!(ranOrScheduled = SafetyUtil.runInBackground(new SafetyUtil.SafeRunnable(readTimeoutMs = (int)(timeout * 1000.0), processResponseCallback){
            final /* synthetic */ int val$readTimeoutMs;
            final /* synthetic */ InternalProcessResponseCallback val$processResponseCallback;
            {
                this.val$readTimeoutMs = n2;
                this.val$processResponseCallback = internalProcessResponseCallback;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void runImpl() {
                BufferedOutputStream os;
                InputStream is;
                block13: {
                    block12: {
                        Response response = null;
                        is = null;
                        os = null;
                        try {
                            for (Map.Entry<String, String> entry : request.headers.entrySet()) {
                                conn.setRequestProperty(entry.getKey(), entry.getValue());
                            }
                            conn.setDoInput(true);
                            conn.setConnectTimeout(connectTimeoutMs);
                            conn.setReadTimeout(this.val$readTimeoutMs);
                            conn.setUseCaches(false);
                            Logger.log(4000, TAG, null, "request : ", request.url == null ? "null" : request.url.toString());
                            if (request.postBody != null && request.postBody.length > 0) {
                                conn.setRequestMethod("POST");
                                conn.setDoOutput(true);
                                conn.setFixedLengthStreamingMode(request.postBody.length);
                                os = new BufferedOutputStream(conn.getOutputStream());
                                ((OutputStream)os).write(request.postBody);
                                ((OutputStream)os).flush();
                            } else {
                                conn.setRequestMethod("GET");
                                conn.connect();
                            }
                            response = new Response(conn.getResponseCode(), conn.getResponseMessage(), conn.getHeaderFields());
                            Logger.log(4000, TAG, null, "response code : " + response.code, response.message);
                            if (response.code < 200 || response.code >= 300) {
                                String exceptionString = "Send failed: " + response.code + " " + response.message;
                                is = conn.getErrorStream();
                                byte[] errorData = NetworkingUtil.byteArrayFromInputStream(is, 0);
                                if (errorData.length > 0 && errorData.length < 10000) {
                                    response.errorString = new String(errorData, Constants.CHARSET_UTF_8);
                                    exceptionString = exceptionString + " " + response.errorString;
                                }
                                RuntimeException e = new RuntimeException(exceptionString);
                                Sender.this.handleFailure(request, response, e);
                                SafetyUtil.closeSafely(is, true);
                                break block12;
                            }
                            String contentEncoding = conn.getContentEncoding();
                            is = conn.getInputStream();
                            if ("gzip".equalsIgnoreCase(contentEncoding)) {
                                is = new GZIPInputStream(is, 8192);
                            }
                            response.data = NetworkingUtil.byteArrayFromInputStream(is, 0);
                            this.val$processResponseCallback.processResponse(response);
                            SafetyUtil.closeSafely(is, true);
                            break block13;
                        }
                        catch (Exception e) {
                            Sender.this.handleFailure(request, response, e);
                            return;
                        }
                    }
                    SafetyUtil.closeSafely(os, true);
                    conn.disconnect();
                    return;
                }
                SafetyUtil.closeSafely(os, true);
                conn.disconnect();
                return;
                finally {
                    SafetyUtil.closeSafely(is, true);
                    SafetyUtil.closeSafely(os, true);
                    conn.disconnect();
                }
            }
        }))) {
            RejectedExecutionException e = new RejectedExecutionException("Request runnable rejected");
            SafetyUtil.assertFail(1000, "Sender exception", e, true);
            this.handleFailure(request, null, e);
        }
    }

    @NonNull
    UUID sendEvents(@NonNull JSONArray events, @Nullable String timeZone, final @Nullable WeakReference<SuccessJsonArrayCallback> weakSuccessCallback, @Nullable WeakReference<FailureCallback> weakFailureCallback) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("clientSendTimestamp", String.valueOf(System.currentTimeMillis()));
        if (StringUtil.isValid(timeZone)) {
            queryParams.put("clientTimeZone", timeZone);
        }
        final Request request = new Request("events", this.uriEvents, null, queryParams, events, null, null, null, weakFailureCallback);
        if (request.exception != null) {
            this.handleFailure(request, null, request.exception);
            return request.uuid;
        }
        this.sendRequest(request, new InternalProcessResponseCallback(){

            @Override
            public void processResponse(@NonNull Response response) {
                JSONArray jsonArray = null;
                if (response.data != null && response.data.length > 0) {
                    try {
                        String jsonString = new String(response.data, Constants.CHARSET_UTF_8);
                        jsonArray = new JSONArray(jsonString);
                    }
                    catch (Exception cause) {
                        InvalidObjectException e = new InvalidObjectException("Could not deserialize event response");
                        e.initCause(cause);
                        Sender.this.handleFailure(request, response, e);
                        return;
                    }
                }
                Sender.this.handleSuccessJsonArray(weakSuccessCallback, request, response, jsonArray);
            }
        });
        return request.uuid;
    }

    @NonNull
    UUID requestConfigWithParams(@NonNull ArrayList<String> pathParams, Long lastModified, final @NonNull WeakReference<SuccessJsonCallback> successBlock, @Nullable WeakReference<FailureCallback> weakFailureCallback) {
        final Request request = new Request("config", this.uriConfig, pathParams, null, null, null, null, null, weakFailureCallback);
        if (request.exception != null) {
            this.handleFailure(request, null, request.exception);
            return request.uuid;
        }
        if (lastModified != null) {
            String httpDateString = NetworkingUtil.httpDateStringFromMillis(lastModified);
            request.headers.put("If-Modified-Since", httpDateString);
        }
        this.sendRequest(request, new InternalProcessResponseCallback(){

            @Override
            public void processResponse(@NonNull Response response) {
                JSONObject json = new JSONObject();
                if (response.data != null && response.data.length > 0) {
                    try {
                        String jsonString = new String(response.data, Constants.CHARSET_UTF_8);
                        json = new JSONObject(jsonString);
                    }
                    catch (Exception cause) {
                        InvalidObjectException e = new InvalidObjectException("Could not deserialize config response");
                        e.initCause(cause);
                        Sender.this.handleFailure(request, response, e);
                        return;
                    }
                }
                Sender.this.handleSuccessJson(successBlock, request, response, json);
            }
        });
        return request.uuid;
    }

    private void handleSuccessJsonArray(final @Nullable WeakReference<SuccessJsonArrayCallback> weakCallback, final @NonNull Request request, final @NonNull Response response, final @NonNull JSONArray jsonArray) {
        SafetyUtil.runAsyncOnHandler(SafetyUtil.sMainHandler, new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                SafetyUtil.assertOnMain();
                SuccessJsonArrayCallback callback = null;
                if (weakCallback != null) {
                    callback = (SuccessJsonArrayCallback)weakCallback.get();
                }
                if (callback != null) {
                    callback.onSendSuccessJsonArray(Sender.this, request.uuid, response, jsonArray);
                }
                Runnable hook = null;
                if ("events".equals(request.type)) {
                    if (Sender.this.eventHistory != null) {
                        ++Sender.this.eventHistory.successCount;
                        Sender.this.eventHistory.results.add(new History.Entry<JSONArray>(request, response, jsonArray, null));
                        if (((History)Sender.this.eventHistory).postCallbackHook != null) {
                            hook = (Runnable)((History)Sender.this.eventHistory).postCallbackHook.get();
                        }
                    }
                } else {
                    SafetyUtil.assertFail(1000, "Config success expects JSONObject but received JSONArray", null, false);
                }
                if (hook != null) {
                    hook.run();
                }
            }
        });
    }

    private void handleSuccessJson(final @Nullable WeakReference<SuccessJsonCallback> weakCallback, final @NonNull Request request, final @NonNull Response response, final @NonNull JSONObject json) {
        SafetyUtil.runAsyncOnHandler(SafetyUtil.sMainHandler, new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                SafetyUtil.assertOnMain();
                SuccessJsonCallback callback = null;
                if (weakCallback != null) {
                    callback = (SuccessJsonCallback)weakCallback.get();
                }
                if (callback != null) {
                    callback.onSendSuccessJson(Sender.this, request.uuid, response, json);
                }
                Runnable hook = null;
                if ("events".equals(request.type)) {
                    SafetyUtil.assertFail(1000, "Event success expects JSONArray but received JSONObject", null, false);
                } else if (Sender.this.configHistory != null) {
                    ++Sender.this.configHistory.successCount;
                    Sender.this.configHistory.results.add(new History.Entry<JSONObject>(request, response, json, null));
                    if (((History)Sender.this.configHistory).postCallbackHook != null) {
                        hook = (Runnable)((History)Sender.this.configHistory).postCallbackHook.get();
                    }
                }
                if (hook != null) {
                    hook.run();
                }
            }
        });
    }

    private void handleFailure(final @NonNull Request request, final @Nullable Response response, final @NonNull Exception exception) {
        SafetyUtil.runAsyncOnHandler(SafetyUtil.sMainHandler, new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                SafetyUtil.assertOnMain();
                FailureCallback callback = null;
                if (request.weakFailureCallback != null) {
                    callback = (FailureCallback)request.weakFailureCallback.get();
                }
                if (callback != null) {
                    callback.onSendFailure(Sender.this, request.uuid, response, exception);
                }
                Runnable hook = null;
                if ("events".equals(request.type)) {
                    if (Sender.this.eventHistory != null) {
                        ++Sender.this.eventHistory.failCount;
                        Sender.this.eventHistory.results.add(new History.Entry<Object>(request, response, null, exception));
                        if (((History)Sender.this.eventHistory).postCallbackHook != null) {
                            hook = (Runnable)((History)Sender.this.eventHistory).postCallbackHook.get();
                        }
                    }
                } else if (Sender.this.configHistory != null) {
                    ++Sender.this.configHistory.failCount;
                    Sender.this.configHistory.results.add(new History.Entry<Object>(request, response, null, exception));
                    if (((History)Sender.this.configHistory).postCallbackHook != null) {
                        hook = (Runnable)((History)Sender.this.configHistory).postCallbackHook.get();
                    }
                }
                if (hook != null) {
                    hook.run();
                }
            }
        });
    }

    protected static class Request {
        @NonNull
        final UUID uuid;
        @NonNull
        final String type;
        @Nullable
        final URL url;
        @Nullable
        final WeakReference<FailureCallback> weakFailureCallback;
        @NonNull
        final Map<String, String> headers = new HashMap<String, String>();
        @Nullable
        byte[] postBody;
        @Nullable
        Exception exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Request(@NonNull String type, @Nullable Uri uri, @Nullable List<String> pathParamsToAdd, @Nullable Map<String, String> queryParamsToAdd, @Nullable JSONArray postJson, @Nullable JSONObject postJsonObject, @Nullable byte[] postData, @Nullable String postDataMimeType, @Nullable WeakReference<FailureCallback> weakFailureCallback) {
            RuntimeException e;
            this.uuid = UUID.randomUUID();
            this.type = type;
            this.weakFailureCallback = weakFailureCallback;
            String urlString = uri == null ? null : uri.toString();
            URL urlTemp = null;
            try {
                if (pathParamsToAdd != null && uri != null) {
                    Uri.Builder builder = uri.buildUpon();
                    for (String path : pathParamsToAdd) {
                        builder.appendPath(path);
                    }
                    uri = builder.build();
                }
                if (queryParamsToAdd != null) {
                    uri = NetworkingUtil.addQueryParams(queryParamsToAdd, uri);
                }
                if (uri == null) {
                    throw new NullPointerException("Uri null");
                }
                urlString = uri.toString();
                urlTemp = new URL(urlString);
            }
            catch (Exception e2) {
                if (this.exception == null) {
                    this.exception = e2;
                }
                SafetyUtil.assertFail(1000, "Sender issue with " + type + " url: " + urlString + " paths: " + (pathParamsToAdd == null ? "null" : pathParamsToAdd.toString()) + " queries: " + (queryParamsToAdd == null ? "null" : queryParamsToAdd.toString()), e2, false);
            }
            this.url = urlTemp;
            if (this.exception != null) {
                return;
            }
            this.postBody = null;
            if (postJson == null && postJsonObject == null && postData == null) {
                return;
            }
            if (postData == null ^ !StringUtil.isValid(postDataMimeType)) {
                RuntimeException e3 = new RuntimeException("Unable to send request, postData and postDataMimeType must exist as pair.");
                if (this.exception == null) {
                    this.exception = e3;
                }
                SafetyUtil.assertFail(1000, "Sender exception", e3, true);
                return;
            }
            String jsonString = null;
            if (postJson != null && (jsonString = postJson.toString()) == null) {
                e = new RuntimeException("Unable to send request, could not serialize JSON");
                if (this.exception == null) {
                    this.exception = e;
                }
                SafetyUtil.assertFail(1000, "Sender exception", e, true);
                return;
            }
            if (postJsonObject != null && (jsonString = postJsonObject.toString()) == null) {
                e = new RuntimeException("Unable to send request, could not serialize JSON");
                if (this.exception == null) {
                    this.exception = e;
                }
                SafetyUtil.assertFail(1000, "Sender exception", e, true);
                return;
            }
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            GZIPOutputStream gzipBodyByteStream = null;
            try {
                gzipBodyByteStream = new GZIPOutputStream(byteStream);
                if (jsonString != null && postData != null) {
                    String uuidString = this.uuid.toString();
                    this.headers.put("Content-Type", "multipart/form-data; boundary=" + uuidString);
                    gzipBodyByteStream.write(("--" + uuidString + "\r\n").getBytes(Constants.CHARSET_UTF_8));
                    gzipBodyByteStream.write("Content-Disposition: form-data; name=\"meta\"\r\n".getBytes(Constants.CHARSET_UTF_8));
                    gzipBodyByteStream.write("Content-Type: application/json\\r\\n\\r\\n".getBytes(Constants.CHARSET_UTF_8));
                    gzipBodyByteStream.write(jsonString.getBytes(Constants.CHARSET_UTF_8));
                    gzipBodyByteStream.write("\r\n".getBytes(Constants.CHARSET_UTF_8));
                    int index = postDataMimeType.indexOf(47);
                    String fieldName = index > 0 ? postDataMimeType.substring(0, index) : "undefined";
                    gzipBodyByteStream.write(("--" + uuidString + "\r\n").getBytes(Constants.CHARSET_UTF_8));
                    gzipBodyByteStream.write(("Content-Disposition: form-data; name=\"" + fieldName + "\"; size=" + String.valueOf(postData.length) + "\r\n").getBytes(Constants.CHARSET_UTF_8));
                    gzipBodyByteStream.write(("Content-Type: " + postDataMimeType + "\r\n\r\n").getBytes(Constants.CHARSET_UTF_8));
                    gzipBodyByteStream.write(postData);
                    gzipBodyByteStream.write("\r\n".getBytes(Constants.CHARSET_UTF_8));
                    gzipBodyByteStream.write(("--" + uuidString + "--\r\n").getBytes(Constants.CHARSET_UTF_8));
                } else if (jsonString != null) {
                    this.headers.put("Content-Type", "application/json;charset=utf-8");
                    gzipBodyByteStream.write(jsonString.getBytes(Constants.CHARSET_UTF_8));
                } else {
                    this.headers.put("Content-Type", postDataMimeType);
                    gzipBodyByteStream.write(postData);
                }
                gzipBodyByteStream.flush();
                gzipBodyByteStream.close();
                this.postBody = byteStream.toByteArray();
                this.headers.put("Content-Encoding", "gzip");
            }
            catch (Exception e4) {
                if (this.exception == null) {
                    this.exception = e4;
                }
                SafetyUtil.assertFail(1000, "Sender exception, unable to create request", e4, true);
            }
            finally {
                SafetyUtil.closeSafely(gzipBodyByteStream, true);
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Type {
            public static final String CONFIG = "config";
            public static final String EVENTS = "events";
        }
    }

    static class Response {
        final int code;
        final String message;
        final Map<String, List<String>> headers;
        byte[] data;
        String errorString;

        private Response(int code, String message, Map<String, List<String>> headers) {
            this.code = code;
            this.message = message;
            this.headers = headers;
        }
    }

    static class History<T> {
        final List<Entry<T>> results = new ArrayList<Entry<T>>();
        private volatile WeakReference<Runnable> postCallbackHook;
        volatile int successCount = 0;
        volatile int failCount = 0;

        History() {
        }

        private void reset() {
            this.results.clear();
            this.successCount = 0;
            this.failCount = 0;
        }

        @Nullable
        Entry<T> getLastResult() {
            return this.results.isEmpty() ? null : this.results.get(this.results.size() - 1);
        }

        static class Entry<T> {
            @NonNull
            final Request request;
            @Nullable
            final Response response;
            @Nullable
            final T output;
            @Nullable
            final Exception exception;

            Entry(@NonNull Request request, @Nullable Response response, @Nullable T output, @Nullable Exception exception) {
                this.request = request;
                this.response = response;
                this.output = output;
                this.exception = exception;
            }
        }
    }

    private static interface InternalProcessResponseCallback {
        public void processResponse(@NonNull Response var1);
    }

    static interface FailureCallback {
        public void onSendFailure(@NonNull Object var1, @NonNull UUID var2, @Nullable Response var3, @NonNull Exception var4);
    }

    static interface SuccessJsonArrayCallback {
        public void onSendSuccessJsonArray(@NonNull Object var1, @NonNull UUID var2, @NonNull Response var3, @NonNull JSONArray var4);
    }

    static interface SuccessJsonCallback {
        public void onSendSuccessJson(@NonNull Object var1, @NonNull UUID var2, @NonNull Response var3, @NonNull JSONObject var4);
    }
}

