/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import android.app.Application;
import android.app.NotificationManager;
import android.os.Build;
import android.os.Process;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import com.evergage.android.Evergage;
import com.evergage.android.internal.Config;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.EvergageImpl;
import com.evergage.android.internal.QueuedEventSender;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.SafetyUtil;
import com.evergage.android.internal.util.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;

class PushTokenManager {
    protected static final String TAG = PushTokenManager.class.getSimpleName();
    private static final String SIMULATED_ENDPOINT = "ptu";
    private static final String KEY_FIREBASE_PLATFORM = "GCM";
    private static final String KEY_LATEST_TOKEN = "token";
    private static final String KEY_PREVIOUS_TOKEN = "previous";
    private static final DependencyManager.LazyNullable<Runnable> firebaseTokenFetcher = PushTokenManager.createLazyFirebaseTokenFetcher();
    private static final String FETCH_MESSAGE = "Please see Evergage.setFirebaseToken method doc on when to additionally call the method to ensure timely token updates.";
    private Config config;
    private QueuedEventSender queuedEventSender;
    private String pushToken;
    private String previousPushToken;
    private boolean running;

    PushTokenManager() {
        this.getDependencies();
    }

    private void getDependencies() {
        this.config = DependencyManager.getConfig();
        this.queuedEventSender = DependencyManager.getQueuedEventSender();
    }

    void startSystemsAsNecessary() {
        SafetyUtil.assertOnMain();
        if (!this.usePushNotifications()) {
            this.stop(true);
            return;
        }
        boolean wasAlreadyRunning = this.running;
        this.running = true;
        if (!wasAlreadyRunning || this.previousPushToken != null) {
            this.enqueuePushTokenUpdateEvent();
        }
        if (this.pushToken == null) {
            this.tryFetchingFirebaseFCMToken();
        }
    }

    void stopSystemsAsNecessary() {
        SafetyUtil.assertOnMain();
        EvergageImpl evergage = DependencyManager.lazyGetEvergage().get();
        if (evergage.isDisabled()) {
            this.stop(true);
        } else if (!evergage.isStarted()) {
            this.stop(false);
        }
    }

    void reset() {
        SafetyUtil.assertOnMain();
        this.getDependencies();
    }

    void handlePushToken(final String token) {
        if (!StringUtil.isValid(token)) {
            return;
        }
        final String tokenTrimmed = token.substring(0, Math.min(token.length(), 4)) + "...";
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                SafetyUtil.assertOnMain();
                if (!PushTokenManager.this.running) {
                    return;
                }
                if (!PushTokenManager.this.isFirebaseTokenValid(token)) {
                    return;
                }
                if (token.equals(PushTokenManager.this.pushToken)) {
                    return;
                }
                if (!PushTokenManager.this.passesPermissionChecks(tokenTrimmed)) {
                    return;
                }
                PushTokenManager.this.previousPushToken = PushTokenManager.this.pushToken;
                PushTokenManager.this.pushToken = token;
                Logger.log(3000, TAG, null, "Accepting token: " + tokenTrimmed);
                PushTokenManager.this.enqueuePushTokenUpdateEvent();
            }
        });
    }

    private boolean passesPermissionChecks(String tokenTrimmed) {
        int result;
        Application application = DependencyManager.getApplication();
        if (application == null) {
            Logger.log(2000, TAG, null, "No Application (SDK not initialized appropriately), cannot accept token: " + tokenTrimmed);
            return false;
        }
        NotificationManager notificationManager = (NotificationManager)application.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 24 && !notificationManager.areNotificationsEnabled()) {
            Logger.log(4000, TAG, null, "Notifications not enabled, cannot accept token: " + tokenTrimmed);
            return false;
        }
        if (Build.VERSION.SDK_INT >= 33 && (result = application.checkPermission("android.permission.POST_NOTIFICATIONS", Process.myPid(), Process.myUid())) != 0) {
            Logger.log(4000, TAG, null, "Permission not granted, cannot accept token: " + tokenTrimmed);
            return false;
        }
        return true;
    }

    void enqueuePushTokenUpdateEvent() {
        SafetyUtil.assertOnMain();
        if (!this.usePushNotifications() || !this.running || this.pushToken == null && this.previousPushToken == null) {
            return;
        }
        DependencyManager.LazyNonNull<EvergageImpl> lazyEvergage = DependencyManager.lazyGetEvergage();
        JSONObject event = lazyEvergage.get().buildBaseParams();
        if (event == null) {
            return;
        }
        JSONObject tokenInfoByPlatform = new JSONObject();
        JSONObject firebaseTokenInfo = new JSONObject();
        if (this.pushToken != null) {
            JSONUtil.put(firebaseTokenInfo, KEY_LATEST_TOKEN, this.pushToken);
        }
        if (this.previousPushToken != null) {
            JSONUtil.put(firebaseTokenInfo, KEY_PREVIOUS_TOKEN, this.previousPushToken);
        }
        JSONUtil.put(tokenInfoByPlatform, KEY_FIREBASE_PLATFORM, firebaseTokenInfo);
        JSONUtil.put(event, "_ptu", tokenInfoByPlatform.toString());
        JSONUtil.put(event, ".se", SIMULATED_ENDPOINT);
        Logger.log(3000, TAG, null, "Firebase push token update event");
        this.queuedEventSender.addEvent(event);
        this.previousPushToken = null;
    }

    private void stop(boolean clearTokens) {
        SafetyUtil.assertOnMain();
        this.running = false;
        if (clearTokens) {
            this.pushToken = null;
            this.previousPushToken = null;
        }
    }

    private boolean isFirebaseTokenValid(String token) {
        return StringUtil.isValid(token) && !token.equals("MESSENGER") && !token.equals("AP");
    }

    private boolean usePushNotifications() {
        SafetyUtil.assertOnMain();
        Boolean bool = this.config.boolForKey("usePushNotifications");
        return bool != null && bool != false;
    }

    void onConfigUpdate() {
        SafetyUtil.assertOnMain();
        if (this.running && !this.usePushNotifications()) {
            this.stop(true);
        }
    }

    private void tryFetchingFirebaseFCMToken() {
        Config config = DependencyManager.getConfig();
        Boolean allowTokenFetch = config.boolForKey("allowPushTokenFetch");
        if (allowTokenFetch == null || !allowTokenFetch.booleanValue()) {
            return;
        }
        Runnable fetcher = firebaseTokenFetcher.get();
        if (fetcher != null) {
            fetcher.run();
        }
    }

    private static DependencyManager.LazyNullable<Runnable> createLazyFirebaseTokenFetcher() {
        return new DependencyManager.LazyNullable<Runnable>(){

            @Override
            @Nullable
            protected Runnable provideOnce() {
                Class<?> classMessaging;
                Class<?> classInstanceId = null;
                try {
                    classMessaging = Class.forName("com.google.firebase.messaging.FirebaseMessaging");
                }
                catch (Exception e) {
                    Logger.log(3000, TAG, null, "Class FirebaseMessaging not found. If you are using a newer/different version of Firebase: Please see Evergage.setFirebaseToken method doc on when to additionally call the method to ensure timely token updates.");
                    return null;
                }
                Runnable runnable = PushTokenManager.tryFetcherMessagingGetToken(classMessaging);
                if (runnable != null) {
                    return runnable;
                }
                try {
                    classInstanceId = Class.forName("com.google.firebase.iid.FirebaseInstanceId");
                    runnable = PushTokenManager.tryFetcherInstanceIdTask(classInstanceId);
                    if (runnable != null) {
                        return runnable;
                    }
                    runnable = PushTokenManager.tryFetcherInstanceIdGetToken(classInstanceId);
                    if (runnable != null) {
                        return runnable;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Logger.log(2000, TAG, null, "Unable to automatically fetch Firebase token. Please see Evergage.setFirebaseToken method doc on when to additionally call the method to ensure timely token updates.");
                return null;
            }
        };
    }

    private static Runnable tryFetcherMessagingGetToken(Class<?> classMessaging) {
        try {
            Method methodGetInstance = classMessaging.getDeclaredMethod("getInstance", new Class[0]);
            Method methodGetToken = classMessaging.getDeclaredMethod("getToken", new Class[0]);
            String warningMessage = "Unable to fetch Firebase token via FirebaseMessaging.getInstance().getToken().addOnSuccessListener(...).Please see Evergage.setFirebaseToken method doc on when to additionally call the method to ensure timely token updates.";
            Class<?> classOnSuccessListener = Class.forName("com.google.android.gms.tasks.OnSuccessListener");
            AtomicReference<Object> taskReference = new AtomicReference<Object>(null);
            Object onSuccessListener = Proxy.newProxyInstance(classOnSuccessListener.getClassLoader(), new Class[]{classOnSuccessListener}, (o, method, objects) -> {
                try {
                    if (!"onSuccess".equals(method.getName())) {
                        throw new RuntimeException("Unexpected method name: " + method.getName());
                    }
                    String deviceToken = (String)objects[0];
                    Evergage.getInstance().setFirebaseToken(deviceToken);
                }
                catch (Exception e) {
                    Logger.log(2000, TAG, null, "Unable to fetch Firebase token via FirebaseMessaging.getInstance().getToken().addOnSuccessListener(...).Please see Evergage.setFirebaseToken method doc on when to additionally call the method to ensure timely token updates.");
                }
                return taskReference.get();
            });
            Class<?> classTask = Class.forName("com.google.android.gms.tasks.Task");
            Method methodAddOnSuccessListener = classTask.getDeclaredMethod("addOnSuccessListener", classOnSuccessListener);
            return () -> {
                try {
                    Object instance = methodGetInstance.invoke(null, new Object[0]);
                    Object task = methodGetToken.invoke(instance, new Object[0]);
                    taskReference.set(task);
                    methodAddOnSuccessListener.invoke(task, onSuccessListener);
                }
                catch (Exception e) {
                    Logger.log(2000, TAG, null, "Unable to fetch Firebase token via FirebaseMessaging.getInstance().getToken().addOnSuccessListener(...).Please see Evergage.setFirebaseToken method doc on when to additionally call the method to ensure timely token updates.");
                }
            };
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Runnable tryFetcherInstanceIdTask(Class<?> classInstanceId) {
        try {
            Method methodGetInstance = classInstanceId.getDeclaredMethod("getInstance", new Class[0]);
            Method methodGetInstanceId = classInstanceId.getDeclaredMethod("getInstanceId", new Class[0]);
            Class<?> classInstanceIdResult = Class.forName("com.google.firebase.iid.InstanceIdResult");
            Method methodGetToken = classInstanceIdResult.getDeclaredMethod("getToken", new Class[0]);
            String warningMessage = "Unable to fetch Firebase token via FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener(...).Please see Evergage.setFirebaseToken method doc on when to additionally call the method to ensure timely token updates.";
            Class<?> classOnSuccessListener = Class.forName("com.google.android.gms.tasks.OnSuccessListener");
            AtomicReference<Object> taskReference = new AtomicReference<Object>(null);
            Object onSuccessListener = Proxy.newProxyInstance(classOnSuccessListener.getClassLoader(), new Class[]{classOnSuccessListener}, (o, method, objects) -> {
                try {
                    if (!"onSuccess".equals(method.getName())) {
                        throw new RuntimeException("Unexpected method name: " + method.getName());
                    }
                    String deviceToken = (String)methodGetToken.invoke(objects[0], new Object[0]);
                    Evergage.getInstance().setFirebaseToken(deviceToken);
                }
                catch (Exception e) {
                    Logger.log(2000, TAG, null, "Unable to fetch Firebase token via FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener(...).Please see Evergage.setFirebaseToken method doc on when to additionally call the method to ensure timely token updates.");
                }
                return taskReference.get();
            });
            Class<?> classTask = Class.forName("com.google.android.gms.tasks.Task");
            Method methodAddOnSuccessListener = classTask.getDeclaredMethod("addOnSuccessListener", classOnSuccessListener);
            return () -> {
                try {
                    Object instance = methodGetInstance.invoke(null, new Object[0]);
                    Object task = methodGetInstanceId.invoke(instance, new Object[0]);
                    taskReference.set(task);
                    methodAddOnSuccessListener.invoke(task, onSuccessListener);
                }
                catch (Exception e) {
                    Logger.log(2000, TAG, null, "Unable to fetch Firebase token via FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener(...).Please see Evergage.setFirebaseToken method doc on when to additionally call the method to ensure timely token updates.");
                }
            };
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Runnable tryFetcherInstanceIdGetToken(Class<?> classInstanceId) {
        try {
            final Method methodGetToken = classInstanceId.getDeclaredMethod("getToken", new Class[0]);
            final Method methodGetInstance = classInstanceId.getDeclaredMethod("getInstance", new Class[0]);
            SafetyUtil.SafeRunnable bgTask = new SafetyUtil.SafeRunnable(){

                @Override
                public void runImpl() {
                    try {
                        Object instance = methodGetInstance.invoke(null, new Object[0]);
                        String token = (String)methodGetToken.invoke(instance, new Object[0]);
                        Evergage.getInstance().setFirebaseToken(token);
                    }
                    catch (Exception e) {
                        Logger.log(2000, TAG, null, "Unable to fetch Firebase token via FirebaseInstanceId.getInstance().getToken(). Please see Evergage.setFirebaseToken method doc on when to additionally call the method to ensure timely token updates.");
                    }
                }
            };
            return () -> SafetyUtil.runInBackground(bgTask);
        }
        catch (Exception e) {
            return null;
        }
    }
}

