/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.Layout;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.Context;
import com.evergage.android.R;
import com.evergage.android.internal.CampaignImpl;
import com.evergage.android.internal.Config;
import com.evergage.android.internal.Constants;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.ScreenImpl;
import com.evergage.android.internal.UIManager;
import com.evergage.android.internal.util.DeviceUtil;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.NetworkingUtil;
import com.evergage.android.internal.util.SafetyUtil;
import com.evergage.android.internal.util.StringUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

class InAppMessage {
    private static final String TAG = "InAppMessage";
    @Nullable
    private android.content.Context appContext = DependencyManager.getAppContext();
    @NonNull
    private Context globalContext;
    @NonNull
    private UIManager uiManager;
    @NonNull
    final CampaignImpl.InAppMessageCampaign campaign;
    private long animDurationMs;
    private String position;
    private int heightMin;
    private int widthMin;
    private int marginHorizontal;
    private int marginVertical;
    private int paddingHorizontal;
    private int paddingVertical;
    private int backgroundColor;
    private float cornerRadius;
    private int borderWidth;
    private int borderColor;
    private int buttonsHeightMin;
    private int buttonsWidthMin;
    private int buttonsSpacing;
    private boolean buttonsWidthStrict;
    private int swipeAxisLockThreshold;
    private int swipeKeepHoldThreshold;
    private long swipeTimeThresholdMs;
    private int swipeVelocityThreshold;
    private long swipeResetAnimDurationMs;
    private long tapThresholdMs;
    private boolean animAcrossActivities;
    private boolean usePrivateRawCoords;
    private boolean useDisplayFrame;
    private boolean useDisplaySize;
    private int velMaxSamples;
    private int velLookbackIntervalMs;
    @Nullable
    private BaseLayout baseLayout;
    private boolean trackedImpression;
    private Field fieldNativePtr;
    private int historyPos;
    private Method methodNativeGetRawAxisValue;

    InAppMessage(@NonNull CampaignImpl.InAppMessageCampaign campaign) {
        JSONObject settingsJSON;
        String stringVal;
        Integer intVal;
        Boolean boolVal;
        Config config = DependencyManager.getConfig();
        this.globalContext = DependencyManager.getGlobalContext();
        this.uiManager = DependencyManager.getUiManager();
        this.campaign = campaign;
        JSONObject json = campaign.getData();
        this.animDurationMs = 300L;
        this.position = "top";
        this.widthMin = this.heightMin = 44;
        this.marginHorizontal = 10;
        this.marginVertical = 10;
        this.paddingHorizontal = 10;
        this.paddingVertical = 10;
        this.backgroundColor = -16777216;
        this.cornerRadius = 0.0f;
        this.borderWidth = 0;
        this.borderColor = -1;
        this.buttonsSpacing = 10;
        this.buttonsHeightMin = 36;
        this.buttonsWidthMin = this.buttonsHeightMin * 3;
        this.buttonsWidthStrict = true;
        this.swipeAxisLockThreshold = 10;
        this.swipeKeepHoldThreshold = 20;
        this.swipeTimeThresholdMs = 100L;
        this.swipeVelocityThreshold = 500;
        this.swipeResetAnimDurationMs = 300L;
        this.tapThresholdMs = 300L;
        this.animAcrossActivities = true;
        this.usePrivateRawCoords = true;
        this.useDisplayFrame = true;
        this.useDisplaySize = true;
        this.velMaxSamples = 20;
        this.velLookbackIntervalMs = 100;
        Double doubleVal = config.doubleForKey("tapThreshold");
        if (doubleVal != null) {
            this.tapThresholdMs = (long)(doubleVal * 1000.0);
        }
        if ((boolVal = config.boolForKey("uiAnimAcrossActivities")) != null) {
            this.animAcrossActivities = boolVal;
        }
        if ((boolVal = config.boolForKey("uiUseRawCoords")) != null) {
            this.usePrivateRawCoords = boolVal;
        }
        if ((boolVal = config.boolForKey("uiUseDisplayFrame")) != null) {
            this.useDisplayFrame = boolVal;
        }
        if ((boolVal = config.boolForKey("uiUseDisplaySize")) != null) {
            this.useDisplaySize = boolVal;
        }
        if ((intVal = config.intForKey("velMaxSamples")) != null) {
            this.velMaxSamples = intVal;
        }
        if ((doubleVal = config.doubleForKey("velLookbackInterval")) != null) {
            this.velLookbackIntervalMs = (int)(doubleVal * 1000.0);
        }
        if ((doubleVal = JSONUtil.getDouble(json, "animDuration")) != null) {
            this.animDurationMs = (long)(doubleVal * 1000.0);
        }
        if ((stringVal = JSONUtil.getString(json, "position")) != null) {
            switch (stringVal = stringVal.toLowerCase(Constants.LOCALE_POSIX)) {
                case "top": 
                case "bottom": 
                case "center": {
                    this.position = stringVal;
                }
            }
        }
        if ((intVal = JSONUtil.getInteger(json, "heightMin")) != null) {
            this.heightMin = intVal;
        }
        if ((intVal = JSONUtil.getInteger(json, "widthMin")) != null) {
            this.widthMin = intVal;
        }
        if ((intVal = JSONUtil.getInteger(json, "marginHorizontal")) != null) {
            this.marginHorizontal = intVal;
        }
        if ((intVal = JSONUtil.getInteger(json, "marginVertical")) != null) {
            this.marginVertical = intVal;
        }
        if ((intVal = JSONUtil.getInteger(json, "paddingHorizontal")) != null) {
            this.paddingHorizontal = intVal;
        }
        if ((intVal = JSONUtil.getInteger(json, "paddingVertical")) != null) {
            this.paddingVertical = intVal;
        }
        if ((stringVal = JSONUtil.getString(json, "backgroundColor")) != null && (intVal = StringUtil.colorFromHexString(stringVal)) != null) {
            this.backgroundColor = intVal;
        }
        if ((doubleVal = JSONUtil.getDouble(json, "cornerRadius")) != null) {
            this.cornerRadius = doubleVal.floatValue();
        }
        if ((intVal = JSONUtil.getInteger(json, "borderWidth")) != null) {
            this.borderWidth = intVal;
        }
        if ((stringVal = JSONUtil.getString(json, "borderColor")) != null && (intVal = StringUtil.colorFromHexString(stringVal)) != null) {
            this.borderColor = intVal;
        }
        if ((settingsJSON = JSONUtil.getJSONObject(json, "interactionSettings")) != null) {
            intVal = JSONUtil.getInteger(settingsJSON, "buttonsHeightMin");
            if (intVal != null) {
                this.buttonsHeightMin = intVal;
            }
            if ((intVal = JSONUtil.getInteger(settingsJSON, "buttonsWidthMin")) != null) {
                this.buttonsWidthMin = intVal;
            }
            if ((intVal = JSONUtil.getInteger(settingsJSON, "buttonsSpacing")) != null) {
                this.buttonsSpacing = intVal;
            }
            if ((boolVal = JSONUtil.getBoolean(settingsJSON, "buttonsWidthStrict")) != null) {
                this.buttonsWidthStrict = boolVal;
            }
            if ((intVal = JSONUtil.getInteger(settingsJSON, "swipesAxisLockThreshold")) != null) {
                this.swipeAxisLockThreshold = intVal;
            }
            if ((intVal = JSONUtil.getInteger(settingsJSON, "swipesKeepHoldThreshold")) != null) {
                this.swipeKeepHoldThreshold = intVal;
            }
            if ((doubleVal = JSONUtil.getDouble(settingsJSON, "swipesTimeThreshold")) != null) {
                this.swipeTimeThresholdMs = (long)(doubleVal * 1000.0);
            }
            if ((intVal = JSONUtil.getInteger(settingsJSON, "swipesVelocityThreshold")) != null) {
                this.swipeVelocityThreshold = intVal;
            }
            if ((doubleVal = JSONUtil.getDouble(settingsJSON, "swipesResetAnimDuration")) != null) {
                this.swipeResetAnimDurationMs = (long)(doubleVal * 1000.0);
            }
        }
        if (this.usePrivateRawCoords) {
            try {
                this.fieldNativePtr = MotionEvent.class.getDeclaredField("mNativePtr");
                this.fieldNativePtr.setAccessible(true);
                Field fieldHistoryPos = MotionEvent.class.getDeclaredField("HISTORY_CURRENT");
                fieldHistoryPos.setAccessible(true);
                this.historyPos = fieldHistoryPos.getInt(null);
                try {
                    this.methodNativeGetRawAxisValue = MotionEvent.class.getDeclaredMethod("nativeGetRawAxisValue", Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                }
                catch (NoSuchMethodException e) {
                    this.methodNativeGetRawAxisValue = MotionEvent.class.getDeclaredMethod("nativeGetRawAxisValue", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                }
                if (this.methodNativeGetRawAxisValue.getReturnType() != Float.TYPE) {
                    throw new RuntimeException("Expected float class but found: " + this.methodNativeGetRawAxisValue.getReturnType());
                }
                this.methodNativeGetRawAxisValue.setAccessible(true);
            }
            catch (Exception e) {
                this.usePrivateRawCoords = false;
                Logger.log(4000, TAG, e, "Unable to access private raw coords, falling back to public relative coords");
            }
        }
    }

    @MainThread
    void showOrUpdateView() {
        SafetyUtil.assertOnMain();
        if (this.appContext == null) {
            return;
        }
        Activity activity = ScreenImpl.lastRunningActivity();
        if (activity == null) {
            Logger.log(4000, TAG, null, "Unable to show/update view, no running activity yet");
            return;
        }
        View activityView = InAppMessage.viewForActivity(activity);
        if (activityView == null) {
            SafetyUtil.assertFail(2000, "Unable to show/update view, no view for Activity: " + activity.toString(), null, false);
            return;
        }
        if (activityView.getApplicationWindowToken() == null) {
            Logger.log(4000, TAG, null, "Waiting for activity to attach to window");
            activityView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                    v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    if (InAppMessage.this.uiManager.currentInAppMessage() != InAppMessage.this) {
                        return;
                    }
                    Activity activity = ScreenImpl.lastRunningActivity();
                    if (activity == null || v != InAppMessage.viewForActivity(activity)) {
                        return;
                    }
                    InAppMessage.this.updateViewWindow(activity);
                }

                public void onViewDetachedFromWindow(View v) {
                    v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                }
            });
            return;
        }
        this.updateViewWindow(activity);
    }

    @MainThread
    void removeView(boolean animated) {
        SafetyUtil.assertOnMain();
        if (this.baseLayout == null) {
            return;
        }
        this.baseLayout.removeViewFromWindow(animated);
        this.baseLayout = null;
    }

    @MainThread
    static void removeViewFromActivityIfFound(@NonNull Activity activity) {
        Object tag;
        SafetyUtil.assertOnMain();
        View activityView = InAppMessage.viewForActivity(activity);
        if (activityView != null && (tag = activityView.getTag(R.id.evergage_in_app_message)) != null) {
            if (!(tag instanceof BaseLayout)) {
                Logger.log(2000, TAG, null, "Unexpectedly found as tag on Activity: " + tag);
            } else {
                BaseLayout baseLayout = (BaseLayout)((Object)tag);
                if (baseLayout.weakParentActivity.get() != activity) {
                    Logger.log(2000, TAG, null, "Unexpectedly found Activity mismatch on tag");
                    activityView.setTag(R.id.evergage_in_app_message, null);
                }
                baseLayout.removeViewFromWindow(false);
            }
        }
    }

    private void updateViewWindow(@NonNull Activity parentActivity) {
        block7: {
            if (this.appContext == null) {
                return;
            }
            WindowManager windowManager = parentActivity.getWindowManager();
            if (windowManager == null) {
                SafetyUtil.assertFail(2000, "Unable to update view, windowManager null, activity: " + parentActivity.toString(), null, false);
                return;
            }
            float previousAlpha = 0.0f;
            if (this.baseLayout != null) {
                if (this.baseLayout.weakParentActivity.get() == parentActivity && this.baseLayout.getParent() != null) {
                    return;
                }
                if (this.animAcrossActivities) {
                    previousAlpha = this.baseLayout.contentLayout.getAlpha();
                }
                this.removeView(true);
            }
            try {
                this.baseLayout = new BaseLayout(this.appContext, windowManager, previousAlpha, parentActivity);
                this.baseLayout.addViewToWindow();
            }
            catch (SafetyUtil.ConstructionException e) {
                if (this.uiManager.currentInAppMessage() != this) break block7;
                Logger.log(1000, TAG, e, "Unable to parse view");
                this.uiManager.hideInAppMessage();
            }
        }
    }

    @Nullable
    private static View viewForActivity(@NonNull Activity activity) {
        if (activity.getWindow() == null) {
            return null;
        }
        return activity.getWindow().getDecorView();
    }

    private static int dpToPx(@NonNull DisplayMetrics displayMetrics, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)displayMetrics);
    }

    @SuppressLint(value={"RtlHardcoded"})
    private static int gravityFromString(@Nullable String string, int fallback) {
        if (string != null) {
            switch (string = string.toLowerCase(Constants.LOCALE_POSIX)) {
                case "center": {
                    return 17;
                }
                case "left": {
                    return 19;
                }
                case "right": {
                    return 21;
                }
                case "start": {
                    return 8388627;
                }
                case "end": {
                    return 8388629;
                }
            }
        }
        Logger.log(2000, TAG, null, "Gravity/Alignment not supported: ", string);
        return fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Float textSizeForStyle(@NonNull android.content.Context context, @Nullable String style2) {
        int styleInt = 0;
        if (style2 != null) {
            switch (style2 = style2.toLowerCase(Constants.LOCALE_POSIX)) {
                case "small": {
                    styleInt = 16973894;
                    break;
                }
                case "medium": {
                    styleInt = 16973892;
                    break;
                }
                case "large": {
                    styleInt = 16973890;
                }
            }
        }
        if (styleInt != 0) {
            TypedArray ta = null;
            int[] attrs = new int[]{16842901};
            try {
                String textSizeSpString;
                ta = context.obtainStyledAttributes(styleInt, attrs);
                if (ta.length() != 0 && (textSizeSpString = ta.getString(0)) != null && textSizeSpString.length() >= 3 && textSizeSpString.endsWith("sp")) {
                    Float f = Float.valueOf(Float.parseFloat(textSizeSpString.substring(0, textSizeSpString.length() - 2)));
                    return f;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (ta != null) {
                    ta.recycle();
                }
            }
        }
        Logger.log(2000, TAG, null, "Style not obtainable: ", style2);
        return null;
    }

    private class BaseLayout
    extends FrameLayout {
        @NonNull
        private final WindowManager windowManager;
        @NonNull
        private final DisplayMetrics displayMetrics;
        @NonNull
        private final WeakReference<Activity> weakParentActivity;
        private final int swipeAxisLockThresholdPx;
        private final int swipeKeepHoldThresholdPx;
        private final int swipeVelocityThresholdPx;
        @NonNull
        private final LinearLayout contentLayout;
        @NonNull
        private final Rect displayFrame;
        @NonNull
        private final Point displaySize;
        private boolean removingOnAnimationEnd;
        @Nullable
        private String urlToOpenOnAnimationEnd;
        @Nullable
        private ValueAnimator positionAnimator;

        private BaseLayout(@NonNull android.content.Context context, final WindowManager windowManager, @NonNull float initialAlpha, Activity parentActivity) throws SafetyUtil.ConstructionException {
            LinearLayout.LayoutParams linearLayoutParams;
            super(context);
            this.windowManager = windowManager;
            this.weakParentActivity = new WeakReference<Activity>(parentActivity);
            this.displayMetrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(this.displayMetrics);
            this.displayFrame = new Rect(0, 0, 0, 0);
            this.displaySize = new Point(0, 0);
            if (InAppMessage.this.useDisplaySize) {
                windowManager.getDefaultDisplay().getSize(this.displaySize);
            }
            int heightMinPx = InAppMessage.dpToPx(this.displayMetrics, InAppMessage.this.heightMin);
            int widthMinPx = InAppMessage.dpToPx(this.displayMetrics, InAppMessage.this.widthMin);
            int marginHorizontalPx = InAppMessage.dpToPx(this.displayMetrics, InAppMessage.this.marginHorizontal);
            int marginVerticalPx = InAppMessage.dpToPx(this.displayMetrics, InAppMessage.this.marginVertical);
            int paddingHorizontalPx = InAppMessage.dpToPx(this.displayMetrics, InAppMessage.this.paddingHorizontal);
            int paddingVerticalPx = InAppMessage.dpToPx(this.displayMetrics, InAppMessage.this.paddingVertical);
            int buttonsHeightMinPx = InAppMessage.dpToPx(this.displayMetrics, InAppMessage.this.buttonsHeightMin);
            int buttonsWidthMinPx = InAppMessage.dpToPx(this.displayMetrics, InAppMessage.this.buttonsWidthMin);
            int buttonsSpacingPx = InAppMessage.dpToPx(this.displayMetrics, InAppMessage.this.buttonsSpacing);
            this.swipeAxisLockThresholdPx = InAppMessage.dpToPx(this.displayMetrics, InAppMessage.this.swipeAxisLockThreshold);
            this.swipeKeepHoldThresholdPx = InAppMessage.dpToPx(this.displayMetrics, InAppMessage.this.swipeKeepHoldThreshold);
            this.swipeVelocityThresholdPx = InAppMessage.dpToPx(this.displayMetrics, InAppMessage.this.swipeVelocityThreshold);
            this.contentLayout = new LinearLayout(context);
            this.contentLayout.setOrientation(1);
            this.contentLayout.setGravity(17);
            GradientDrawable bgDrawable = new GradientDrawable();
            bgDrawable.setColor(InAppMessage.this.backgroundColor);
            bgDrawable.setCornerRadius((float)InAppMessage.dpToPx(this.displayMetrics, InAppMessage.this.cornerRadius));
            bgDrawable.setStroke(InAppMessage.dpToPx(this.displayMetrics, InAppMessage.this.borderWidth), InAppMessage.this.borderColor);
            if (Build.VERSION.SDK_INT >= 16) {
                this.contentLayout.setBackground((Drawable)bgDrawable);
            } else {
                this.contentLayout.setBackgroundDrawable((Drawable)bgDrawable);
            }
            this.contentLayout.setMinimumWidth(widthMinPx);
            this.contentLayout.setMinimumHeight(heightMinPx);
            this.contentLayout.setPadding(paddingHorizontalPx, paddingVerticalPx, paddingHorizontalPx, paddingVerticalPx);
            FrameLayout.LayoutParams frameLayoutParams = new FrameLayout.LayoutParams(-1, -1);
            frameLayoutParams.setMargins(marginHorizontalPx, marginVerticalPx, marginHorizontalPx, marginVerticalPx);
            this.addView((View)this.contentLayout, (ViewGroup.LayoutParams)frameLayoutParams);
            JSONObject textViewJSON = JSONUtil.getJSONObject(InAppMessage.this.campaign.getData(), "title");
            if (textViewJSON != null) {
                MeasureStateTextView titleTextView = new MeasureStateTextView(context);
                this.configureTextView(titleTextView, textViewJSON, 1, "small");
                titleTextView.setTypeface(Typeface.DEFAULT, 1);
                if (StringUtil.isValid(titleTextView.getText())) {
                    linearLayoutParams = new LinearLayout.LayoutParams(-1, -2);
                    this.contentLayout.addView((View)titleTextView, (ViewGroup.LayoutParams)linearLayoutParams);
                }
            }
            if ((textViewJSON = JSONUtil.getJSONObject(InAppMessage.this.campaign.getData(), "body")) != null) {
                MeasureStateTextView bodyTextView = new MeasureStateTextView(context);
                this.configureTextView(bodyTextView, textViewJSON, 2, "small");
                if (StringUtil.isValid(bodyTextView.getText())) {
                    linearLayoutParams = new LinearLayout.LayoutParams(-1, -2);
                    this.contentLayout.addView((View)bodyTextView, (ViewGroup.LayoutParams)linearLayoutParams);
                }
            }
            LinearLayout buttonLayout = null;
            JSONObject buttonMapJSON = JSONUtil.getJSONObject(InAppMessage.this.campaign.getData(), "buttonMap");
            if (buttonMapJSON != null) {
                String indexString;
                JSONObject buttonJSON;
                buttonLayout = new LinearLayout(context);
                buttonLayout.setMeasureWithLargestChildEnabled(InAppMessage.this.buttonsWidthStrict);
                buttonLayout.setOrientation(0);
                buttonLayout.setGravity(17);
                Button lastButton = null;
                for (int i = 0; i < buttonMapJSON.length() && (buttonJSON = JSONUtil.getJSONObject(buttonMapJSON, indexString = Integer.toString(i))) != null; ++i) {
                    Button button = this.buttonFromJSON(buttonJSON, indexString);
                    if (button == null) continue;
                    button.setMinHeight(buttonsHeightMinPx);
                    button.setMinimumHeight(buttonsHeightMinPx);
                    button.setMinWidth(buttonsWidthMinPx);
                    button.setMinimumWidth(buttonsWidthMinPx);
                    LinearLayout.LayoutParams linearLayoutParams2 = new LinearLayout.LayoutParams(-2, -2);
                    linearLayoutParams2.weight = 1.0f;
                    if (InAppMessage.this.buttonsWidthStrict) {
                        linearLayoutParams2.width = 0;
                    }
                    if (lastButton != null) {
                        linearLayoutParams2.leftMargin = buttonsSpacingPx;
                    }
                    buttonLayout.addView((View)button, (ViewGroup.LayoutParams)linearLayoutParams2);
                    lastButton = button;
                }
                if (lastButton != null) {
                    LinearLayout.LayoutParams linearLayoutParams3 = new LinearLayout.LayoutParams(InAppMessage.this.buttonsWidthStrict ? -1 : -2, -2);
                    if (this.contentLayout.getChildCount() > 0) {
                        linearLayoutParams3.topMargin = paddingVerticalPx;
                    }
                    this.contentLayout.addView((View)buttonLayout, (ViewGroup.LayoutParams)linearLayoutParams3);
                } else {
                    buttonLayout = null;
                }
            }
            JSONObject interactionMapJSON = JSONUtil.getJSONObject(InAppMessage.this.campaign.getData(), "interactionMap");
            this.contentLayout.setOnTouchListener((View.OnTouchListener)new SwipeAndTapListener(interactionMapJSON, buttonLayout == null));
            if (InAppMessage.this.useDisplaySize) {
                this.contentLayout.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        if (InAppMessage.this.useDisplaySize) {
                            windowManager.getDefaultDisplay().getSize(BaseLayout.this.displaySize);
                        }
                    }
                });
            }
            this.setEnabled(false);
            this.contentLayout.setAlpha(initialAlpha);
        }

        private void configureTextView(@NonNull TextView textView, @NonNull JSONObject json, int numLines, @Nullable String style2) {
            Integer intVal;
            Float floatVal;
            textView.setMaxLines(numLines);
            textView.setEllipsize(TextUtils.TruncateAt.END);
            textView.setTypeface(Typeface.DEFAULT);
            textView.setAllCaps(false);
            String stringVal = JSONUtil.getString(json, "textStyle");
            if (stringVal != null) {
                style2 = stringVal;
            }
            if (style2 != null && (floatVal = InAppMessage.textSizeForStyle(textView.getContext(), style2)) != null) {
                textView.setTextSize(floatVal.floatValue());
            }
            if ((stringVal = JSONUtil.getString(json, "textColor")) != null && (intVal = StringUtil.colorFromHexString(stringVal)) != null) {
                textView.setTextColor(intVal.intValue());
            } else {
                textView.setTextColor(-1);
            }
            stringVal = JSONUtil.getString(json, "textAlignment");
            if (stringVal != null) {
                textView.setGravity(InAppMessage.gravityFromString(stringVal, 17));
            } else {
                textView.setGravity(17);
            }
            stringVal = JSONUtil.getString(json, "text");
            if (stringVal != null) {
                textView.setText((CharSequence)stringVal);
            }
        }

        @Nullable
        private Button buttonFromJSON(@NonNull JSONObject json, @NonNull String indexString) {
            Double doubleVal;
            Integer intVal;
            String logPrefix = "Button [" + indexString + "]: ";
            if (json == null) {
                Logger.log(2000, InAppMessage.TAG, null, logPrefix, "Missing JSON");
                return null;
            }
            MeasureStateButton button = new MeasureStateButton(this.getContext());
            this.configureTextView((TextView)button, json, 1, "small");
            if (!StringUtil.isValid(button.getText())) {
                Logger.log(2000, InAppMessage.TAG, null, logPrefix, "Missing text");
                return null;
            }
            GradientDrawable bgDrawable = new GradientDrawable();
            int bgColor = 0;
            float cornerRadiusPx = InAppMessage.dpToPx(this.displayMetrics, 10.0f);
            int borderWidthPx = 0;
            int borderColor = -16777216;
            int paddingHorizontalPx = InAppMessage.dpToPx(this.displayMetrics, 10.0f);
            int paddingVerticalPx = 0;
            String stringVal = JSONUtil.getString(json, "backgroundColor");
            if (stringVal != null && (intVal = StringUtil.colorFromHexString(stringVal)) != null) {
                bgColor = intVal;
            }
            if ((doubleVal = JSONUtil.getDouble(json, "cornerRadius")) != null) {
                cornerRadiusPx = InAppMessage.dpToPx(this.displayMetrics, doubleVal.floatValue());
            }
            if ((stringVal = JSONUtil.getString(json, "borderColor")) != null && (intVal = StringUtil.colorFromHexString(stringVal)) != null) {
                borderColor = intVal;
            }
            if ((doubleVal = JSONUtil.getDouble(json, "borderWidth")) != null) {
                borderWidthPx = InAppMessage.dpToPx(this.displayMetrics, doubleVal.intValue());
            }
            if ((doubleVal = JSONUtil.getDouble(json, "paddingHorizontal")) != null) {
                paddingHorizontalPx = InAppMessage.dpToPx(this.displayMetrics, doubleVal.floatValue());
            }
            if ((doubleVal = JSONUtil.getDouble(json, "paddingVertical")) != null) {
                paddingVerticalPx = InAppMessage.dpToPx(this.displayMetrics, doubleVal.floatValue());
            }
            bgDrawable.setColor(bgColor);
            bgDrawable.setCornerRadius(cornerRadiusPx);
            bgDrawable.setStroke(borderWidthPx, borderColor);
            if (Build.VERSION.SDK_INT >= 16) {
                button.setBackground((Drawable)bgDrawable);
            } else {
                button.setBackgroundDrawable((Drawable)bgDrawable);
            }
            button.setPadding(paddingHorizontalPx, paddingVerticalPx, paddingHorizontalPx, paddingVerticalPx);
            JSONObject actionJSON = JSONUtil.getJSONObject(json, "tap");
            if (actionJSON == null) {
                actionJSON = new JSONObject();
                Logger.log(4000, InAppMessage.TAG, null, "No button action defined, will use default tap action");
            }
            final Action tapAction = new Action(actionJSON, "button" + indexString + "-tap");
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    tapAction.performAction();
                }
            });
            return button;
        }

        public boolean onInterceptTouchEvent(MotionEvent ev) {
            return !this.isEnabled();
        }

        public boolean onTouchEvent(MotionEvent event) {
            return !this.isEnabled() || super.onTouchEvent(event);
        }

        private void addViewToWindow() {
            WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams(-1, -2, 2, 40, -2);
            layoutParams.setTitle((CharSequence)"EvergageInAppMessage");
            switch (InAppMessage.this.position) {
                case "center": {
                    break;
                }
                case "bottom": {
                    layoutParams.gravity = 81;
                    break;
                }
                default: {
                    layoutParams.gravity = 49;
                }
            }
            Logger.log(3000, InAppMessage.TAG, null, "Adding view");
            Activity parentActivity = (Activity)this.weakParentActivity.get();
            try {
                View activityView;
                this.windowManager.addView((View)this, (ViewGroup.LayoutParams)layoutParams);
                if (parentActivity != null && (activityView = InAppMessage.viewForActivity(parentActivity)) != null) {
                    activityView.setTag(R.id.evergage_in_app_message, (Object)this);
                }
            }
            catch (Exception e) {
                SafetyUtil.assertFail(2000, "Unable to add view to windowManager, parentActivity: " + (parentActivity == null ? null : parentActivity.toString()), e, false);
            }
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            Logger.log(4000, InAppMessage.TAG, null, "View attached");
            if (InAppMessage.this.useDisplaySize) {
                this.windowManager.getDefaultDisplay().getSize(this.displaySize);
            }
            if (InAppMessage.this.useDisplayFrame) {
                this.getWindowVisibleDisplayFrame(this.displayFrame);
            }
            this.animateAddAlpha();
        }

        private void removeViewFromWindow(boolean animated) {
            if (animated) {
                this.animateRemoveAlpha();
                return;
            }
            if (this.positionAnimator != null) {
                this.positionAnimator.cancel();
            }
            this.contentLayout.animate().cancel();
            if (this.getParent() == null) {
                return;
            }
            Logger.log(3000, InAppMessage.TAG, null, "Removing view");
            Activity parentActivity = (Activity)this.weakParentActivity.get();
            try {
                View activityView;
                this.windowManager.removeViewImmediate((View)this);
                if (parentActivity != null && (activityView = InAppMessage.viewForActivity(parentActivity)) != null) {
                    activityView.setTag(R.id.evergage_in_app_message, null);
                }
            }
            catch (Exception e) {
                SafetyUtil.assertFail(1000, "Unable to remove view from windowManager, parentActivity: " + (parentActivity == null ? null : parentActivity.toString()), e, false);
                this.setVisibility(8);
            }
        }

        private void animateAddAlpha() {
            long duration = (long)((float)InAppMessage.this.animDurationMs * (1.0f - this.contentLayout.getAlpha() / 1.0f));
            this.contentLayout.animate().setListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (BaseLayout.this.contentLayout.getAlpha() == 1.0f) {
                        Logger.log(3000, InAppMessage.TAG, null, "View enabled");
                        BaseLayout.this.setEnabled(true);
                        if (!InAppMessage.this.trackedImpression) {
                            InAppMessage.this.trackedImpression = true;
                            InAppMessage.this.globalContext.trackImpression(InAppMessage.this.campaign);
                        }
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            }).setDuration(duration).alpha(1.0f);
        }

        private void animateRemoveAlpha() {
            if (this.removingOnAnimationEnd) {
                return;
            }
            this.removingOnAnimationEnd = true;
            this.contentLayout.animate().cancel();
            if (this.getParent() == null) {
                return;
            }
            Logger.log(4000, InAppMessage.TAG, null, "View animating out");
            long duration = (long)((float)InAppMessage.this.animDurationMs * this.contentLayout.getAlpha() / 1.0f);
            this.setEnabled(false);
            this.contentLayout.animate().setListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    BaseLayout.this.removeViewFromWindow(false);
                    if (BaseLayout.this.urlToOpenOnAnimationEnd != null) {
                        NetworkingUtil.openURLFromString(BaseLayout.this.getContext(), BaseLayout.this.urlToOpenOnAnimationEnd);
                        BaseLayout.this.urlToOpenOnAnimationEnd = null;
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            }).setDuration(duration).alpha(0.0f);
        }

        private class SwipeAndTapListener
        implements View.OnTouchListener {
            @NonNull
            private final Map<String, Action> swipeDirectionActionMap;
            @Nullable
            private final Action tapAction;
            private int activePointerId = -1;
            private float startX = 0.0f;
            private float startY = 0.0f;
            private float totalDX = 0.0f;
            private float totalDY = 0.0f;
            private Rect exitThresholds = new Rect();
            private float axisLockOffsetX;
            private float axisLockOffsetY;
            private float lastX = 0.0f;
            private float lastY = 0.0f;
            private long lastTimeMs = 0L;
            @NonNull
            private VelocityTracker velocityTracker;

            private SwipeAndTapListener(JSONObject interactionMapJSON, boolean withTapAction) {
                JSONObject tapActionJSON = null;
                if (interactionMapJSON != null) {
                    tapActionJSON = JSONUtil.getJSONObject(interactionMapJSON, "tap");
                }
                if (!withTapAction) {
                    if (tapActionJSON != null) {
                        Logger.log(4000, InAppMessage.TAG, null, "Ignoring defined tap action: ", tapActionJSON.toString());
                    }
                    this.tapAction = null;
                } else {
                    if (tapActionJSON == null) {
                        tapActionJSON = new JSONObject();
                        Logger.log(4000, InAppMessage.TAG, null, "No tap action defined, will use default tap action");
                    }
                    this.tapAction = new Action(tapActionJSON, "message-tap");
                }
                HashMap<String, Action> map = new HashMap<String, Action>();
                if (interactionMapJSON != null) {
                    String[] directions;
                    for (String direction : directions = new String[]{"swipeLeft", "swipeRight", "swipeUp", "swipeDown"}) {
                        JSONObject actionJSON = JSONUtil.getJSONObject(interactionMapJSON, direction);
                        if (actionJSON == null) continue;
                        Action action = new Action(actionJSON, direction);
                        map.put(direction, action);
                    }
                }
                this.swipeDirectionActionMap = Collections.unmodifiableMap(map);
                Logger.log(4000, InAppMessage.TAG, null, "Swipe directions: ", map.keySet().toString());
                this.velocityTracker = new VelocityTracker(0L, InAppMessage.this.velMaxSamples, InAppMessage.this.velLookbackIntervalMs);
            }

            private void getCoords(@NonNull MotionEvent motionEvent, int pointerIndex) {
                this.lastTimeMs = motionEvent.getEventTime();
                if (InAppMessage.this.usePrivateRawCoords) {
                    try {
                        if (InAppMessage.this.fieldNativePtr.getType() == Long.TYPE) {
                            long nativePtr = InAppMessage.this.fieldNativePtr.getLong(motionEvent);
                            this.lastX = ((Float)InAppMessage.this.methodNativeGetRawAxisValue.invoke(null, nativePtr, 0, pointerIndex, InAppMessage.this.historyPos)).floatValue();
                            this.lastY = ((Float)InAppMessage.this.methodNativeGetRawAxisValue.invoke(null, nativePtr, 1, pointerIndex, InAppMessage.this.historyPos)).floatValue();
                        } else {
                            int nativePtr = InAppMessage.this.fieldNativePtr.getInt(motionEvent);
                            this.lastX = ((Float)InAppMessage.this.methodNativeGetRawAxisValue.invoke(null, nativePtr, 0, pointerIndex, InAppMessage.this.historyPos)).floatValue();
                            this.lastY = ((Float)InAppMessage.this.methodNativeGetRawAxisValue.invoke(null, nativePtr, 1, pointerIndex, InAppMessage.this.historyPos)).floatValue();
                        }
                        return;
                    }
                    catch (Exception e) {
                        InAppMessage.this.usePrivateRawCoords = false;
                        Logger.log(4000, InAppMessage.TAG, e, "Unable to get private raw coords, falling back to public relative coords");
                    }
                }
                this.lastX = motionEvent.getX(pointerIndex);
                this.lastY = motionEvent.getY(pointerIndex);
            }

            private void updateExitThresholds() {
                int containerWidth = Integer.MAX_VALUE;
                if (BaseLayout.this.displayFrame.width() > 0) {
                    containerWidth = BaseLayout.this.displayFrame.width();
                }
                if (((BaseLayout)BaseLayout.this).displaySize.x > 0 && ((BaseLayout)BaseLayout.this).displaySize.x < containerWidth) {
                    containerWidth = ((BaseLayout)BaseLayout.this).displaySize.x;
                }
                int containerHeight = Integer.MAX_VALUE;
                if (BaseLayout.this.displayFrame.height() > 0) {
                    containerHeight = BaseLayout.this.displayFrame.height();
                }
                if (((BaseLayout)BaseLayout.this).displaySize.y > 0 && ((BaseLayout)BaseLayout.this).displaySize.y < containerHeight) {
                    containerHeight = ((BaseLayout)BaseLayout.this).displaySize.y;
                }
                if (containerWidth == Integer.MAX_VALUE || containerHeight == Integer.MAX_VALUE) {
                    this.exitThresholds.set(0, 0, 0, 0);
                    return;
                }
                this.exitThresholds.right = (containerWidth + BaseLayout.this.contentLayout.getWidth()) / 2;
                this.exitThresholds.left = -this.exitThresholds.right;
                if ("top".equals(InAppMessage.this.position)) {
                    this.exitThresholds.top = -BaseLayout.this.contentLayout.getHeight();
                    this.exitThresholds.bottom = containerHeight;
                } else if ("bottom".equals(InAppMessage.this.position)) {
                    this.exitThresholds.top = -containerHeight;
                    this.exitThresholds.bottom = BaseLayout.this.contentLayout.getHeight();
                } else {
                    this.exitThresholds.bottom = (containerHeight + BaseLayout.this.contentLayout.getHeight()) / 2;
                    this.exitThresholds.top = -this.exitThresholds.bottom;
                }
            }

            private void updateAlphaForTranslation(@NonNull WindowManager.LayoutParams params) {
                int translationY;
                this.updateExitThresholds();
                if (this.exitThresholds.isEmpty()) {
                    return;
                }
                int translationX = params.x;
                int n = translationY = (params.gravity & 0x50) == 80 ? -params.y : params.y;
                float alphaX = translationX > 0 ? Math.max(0.0f, 1.0f - (float)translationX / (float)this.exitThresholds.right) : (translationX < 0 ? Math.max(0.0f, 1.0f - (float)translationX / (float)this.exitThresholds.left) : 1.0f);
                float alphaY = translationY > 0 ? Math.max(0.0f, 1.0f - (float)translationY / (float)this.exitThresholds.bottom) : (translationY < 0 ? Math.max(0.0f, 1.0f - (float)translationY / (float)this.exitThresholds.top) : 1.0f);
                BaseLayout.this.contentLayout.setAlpha(Math.min(alphaX, alphaY));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onTouch(View view, MotionEvent motionEvent) {
                int action = motionEvent.getActionMasked();
                switch (action) {
                    case 0: {
                        Logger.log(3000, InAppMessage.TAG, null, "onTouch down");
                        this.activePointerId = -1;
                        this.startX = 0.0f;
                        this.startY = 0.0f;
                        this.totalDX = 0.0f;
                        this.totalDY = 0.0f;
                        this.axisLockOffsetX = 0.0f;
                        this.axisLockOffsetY = 0.0f;
                        this.lastX = 0.0f;
                        this.lastY = 0.0f;
                        this.lastTimeMs = 0L;
                        if (BaseLayout.this.displayFrame.isEmpty() && (((BaseLayout)BaseLayout.this).displaySize.x == 0 || ((BaseLayout)BaseLayout.this).displaySize.y == 0)) {
                            Logger.log(2000, InAppMessage.TAG, null, "Unable to move/drag window, couldn't determine display frame/size");
                            return true;
                        }
                        try {
                            WindowManager.LayoutParams params = (WindowManager.LayoutParams)BaseLayout.this.getLayoutParams();
                            params.flags |= 0x200;
                            BaseLayout.this.windowManager.updateViewLayout((View)BaseLayout.this, (ViewGroup.LayoutParams)params);
                        }
                        catch (Exception e) {
                            Logger.log(2000, InAppMessage.TAG, e, "Unable to move/drag window, couldn't update window flags");
                            return true;
                        }
                        int pointerIndex = motionEvent.getActionIndex();
                        this.activePointerId = motionEvent.getPointerId(pointerIndex);
                        this.getCoords(motionEvent, pointerIndex);
                        this.startX = this.lastX;
                        this.startY = this.lastY;
                        this.velocityTracker.reset(motionEvent.getEventTime());
                        break;
                    }
                    case 2: {
                        if (this.activePointerId == -1) {
                            Logger.log(4000, InAppMessage.TAG, null, "Ignoring unexpected move while active pointer invalid");
                            return true;
                        }
                        int pointerIndex = motionEvent.findPointerIndex(this.activePointerId);
                        if (pointerIndex < 0) {
                            Logger.log(2000, InAppMessage.TAG, null, "Unable to move/drag window, couldn't find pointer index");
                            return true;
                        }
                        this.getCoords(motionEvent, pointerIndex);
                        if (InAppMessage.this.usePrivateRawCoords) {
                            this.totalDX = this.lastX - this.startX;
                            this.totalDY = this.lastY - this.startY;
                        } else {
                            this.totalDX += this.lastX - this.startX;
                            this.totalDY += this.lastY - this.startY;
                        }
                        float translationX = this.totalDX;
                        float translationY = this.totalDY;
                        if (this.axisLockOffsetX != 0.0f) {
                            translationX -= this.axisLockOffsetX;
                            translationY = 0.0f;
                        } else if (this.axisLockOffsetY != 0.0f) {
                            translationX = 0.0f;
                            translationY -= this.axisLockOffsetY;
                        }
                        float absTranslationX = Math.abs(this.totalDX);
                        float absTranslationY = Math.abs(this.totalDY);
                        boolean horizontalAllowed = false;
                        if (translationX < 0.0f && this.swipeDirectionActionMap.get("swipeLeft") != null || translationX > 0.0f && this.swipeDirectionActionMap.get("swipeRight") != null) {
                            horizontalAllowed = true;
                        }
                        boolean verticalAllowed = false;
                        if (translationY < 0.0f && this.swipeDirectionActionMap.get("swipeUp") != null || translationY > 0.0f && this.swipeDirectionActionMap.get("swipeDown") != null) {
                            verticalAllowed = true;
                        }
                        if (BaseLayout.this.swipeAxisLockThresholdPx > 0 && this.axisLockOffsetX == 0.0f && this.axisLockOffsetY == 0.0f) {
                            if (horizontalAllowed && absTranslationX >= (float)BaseLayout.this.swipeAxisLockThresholdPx && (!verticalAllowed || absTranslationX >= absTranslationY)) {
                                verticalAllowed = false;
                                this.axisLockOffsetX = Math.copySign(BaseLayout.this.swipeAxisLockThresholdPx, translationX);
                                translationX -= this.axisLockOffsetX;
                            } else if (verticalAllowed & absTranslationY >= (float)BaseLayout.this.swipeAxisLockThresholdPx) {
                                horizontalAllowed = false;
                                this.axisLockOffsetY = Math.copySign(BaseLayout.this.swipeAxisLockThresholdPx, translationY);
                                translationY -= this.axisLockOffsetY;
                            } else {
                                horizontalAllowed = false;
                                verticalAllowed = false;
                            }
                        }
                        if (BaseLayout.this.swipeKeepHoldThresholdPx > 0) {
                            float locInViewX = motionEvent.getX(pointerIndex);
                            float locInViewY = motionEvent.getY(pointerIndex);
                            if (!horizontalAllowed && (locInViewX < (float)(0 - BaseLayout.this.swipeKeepHoldThresholdPx) || locInViewX > (float)(BaseLayout.this.contentLayout.getWidth() + BaseLayout.this.swipeKeepHoldThresholdPx)) || !verticalAllowed && (locInViewY < (float)(0 - BaseLayout.this.swipeKeepHoldThresholdPx) || locInViewY > (float)(BaseLayout.this.contentLayout.getHeight() + BaseLayout.this.swipeKeepHoldThresholdPx))) {
                                Logger.log(4000, InAppMessage.TAG, null, "Swipe lost hold");
                                BaseLayout.this.setEnabled(false);
                                return true;
                            }
                        }
                        try {
                            WindowManager.LayoutParams params = (WindowManager.LayoutParams)BaseLayout.this.getLayoutParams();
                            int n = params.x = !horizontalAllowed ? 0 : (int)translationX;
                            params.y = !verticalAllowed ? 0 : ((params.gravity & 0x50) == 80 ? -((int)translationY) : (int)translationY);
                            BaseLayout.this.windowManager.updateViewLayout((View)BaseLayout.this, (ViewGroup.LayoutParams)params);
                            this.updateAlphaForTranslation(params);
                        }
                        catch (Exception e) {
                            Logger.log(2000, InAppMessage.TAG, null, "Unable to move/drag window, couldn't update window position");
                        }
                        this.velocityTracker.addMovement(motionEvent.getEventTime(), this.totalDX, this.totalDY);
                        break;
                    }
                    case 1: 
                    case 3: {
                        boolean isUpAction;
                        boolean bl = isUpAction = action == 1;
                        if (this.activePointerId == -1) {
                            Logger.log(4000, InAppMessage.TAG, null, "Unexpected ", isUpAction ? "up" : "cancel", " while active pointer invalid, processing as cancel");
                            isUpAction = false;
                        }
                        Logger.log(3000, InAppMessage.TAG, null, "onTouch ", isUpAction ? "up" : "cancel");
                        long timeSinceDown = motionEvent.getEventTime() - motionEvent.getDownTime();
                        try {
                            WindowManager.LayoutParams params = (WindowManager.LayoutParams)BaseLayout.this.getLayoutParams();
                            boolean isTap = false;
                            if (isUpAction && this.tapAction != null && timeSinceDown <= InAppMessage.this.tapThresholdMs && params.x == 0 && params.y == 0) {
                                isTap = true;
                                this.tapAction.performAction();
                            }
                            if (isUpAction && !isTap && this.animateSwipe(motionEvent.getEventTime() - this.lastTimeMs, params)) break;
                            this.animateRecenter(params);
                            break;
                        }
                        catch (Exception e) {
                            Logger.log(2000, InAppMessage.TAG, e, "Unable to recenter/swipe");
                            BaseLayout.this.animateRemoveAlpha();
                            if (InAppMessage.this.uiManager.currentInAppMessage() != InAppMessage.this) break;
                            InAppMessage.this.uiManager.hideInAppMessage();
                            break;
                        }
                        finally {
                            this.activePointerId = -1;
                            this.startX = 0.0f;
                            this.startY = 0.0f;
                            this.totalDX = 0.0f;
                            this.totalDY = 0.0f;
                            this.axisLockOffsetX = 0.0f;
                            this.axisLockOffsetY = 0.0f;
                            this.lastX = 0.0f;
                            this.lastY = 0.0f;
                            this.lastTimeMs = 0L;
                            this.velocityTracker.reset(0L);
                        }
                    }
                    case 6: {
                        int pointerIndex = motionEvent.getActionIndex();
                        int pointerId = motionEvent.getPointerId(pointerIndex);
                        if (pointerId != this.activePointerId) break;
                        this.getCoords(motionEvent, pointerIndex);
                        float startDX = this.lastX - this.startX;
                        float startDY = this.lastY - this.startY;
                        int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                        this.activePointerId = motionEvent.getPointerId(newPointerIndex);
                        this.getCoords(motionEvent, pointerIndex);
                        this.startX = this.lastX - startDX;
                        this.startY = this.lastY - startDY;
                        break;
                    }
                }
                return true;
            }

            private boolean animateSwipe(long timeSincePositionUpdate, @NonNull WindowManager.LayoutParams params) {
                String actionDirection;
                float duration;
                final int startTranslationX = params.x;
                final int startTranslationY = (params.gravity & 0x50) == 80 ? -params.y : params.y;
                this.velocityTracker.computeCurrentVelocity();
                float velX = this.velocityTracker.getXVelocity();
                float velY = this.velocityTracker.getYVelocity();
                Logger.log(4000, InAppMessage.TAG, null, "View drag release, evaluating for swipe, ", "timeSincePositionUpdate: ", Long.toString(timeSincePositionUpdate), " X: ", Float.toString(startTranslationX), " Y: ", Float.toString(startTranslationY), " velX: ", Float.toString(velX), " velY: ", Float.toString(velY));
                this.updateExitThresholds();
                if (this.exitThresholds.isEmpty()) {
                    return false;
                }
                if (this.axisLockOffsetX != 0.0f) {
                    velY = 0.0f;
                } else if (this.axisLockOffsetY != 0.0f) {
                    velX = 0.0f;
                }
                boolean horizontalAllowed = false;
                if (velX < 0.0f && this.swipeDirectionActionMap.get("swipeLeft") != null || velX > 0.0f && this.swipeDirectionActionMap.get("swipeRight") != null) {
                    horizontalAllowed = true;
                }
                boolean verticalAllowed = false;
                if (velY < 0.0f && this.swipeDirectionActionMap.get("swipeUp") != null || velY > 0.0f && this.swipeDirectionActionMap.get("swipeDown") != null) {
                    verticalAllowed = true;
                }
                float absVelX = Math.abs(velX);
                float absVelY = Math.abs(velY);
                if (!(horizontalAllowed && !(absVelX < (float)BaseLayout.this.swipeVelocityThresholdPx) || verticalAllowed && !(absVelY < (float)BaseLayout.this.swipeVelocityThresholdPx))) {
                    return false;
                }
                if (timeSincePositionUpdate > InAppMessage.this.swipeTimeThresholdMs) {
                    Logger.log(DeviceUtil.isEmulator() ? 2000 : 3000, InAppMessage.TAG, null, "Will recenter instead of swipe animation, ms between last movement and 'release' : ", Long.toString(timeSincePositionUpdate), " ms. If using an emulator, try physically clicking & releasing the mouse/trackpad.");
                    return false;
                }
                Logger.log(3000, InAppMessage.TAG, null, "View swipe");
                float distToEdgeX = Math.max(0.0f, velX >= 0.0f ? (float)this.exitThresholds.right - (float)startTranslationX : (float)startTranslationX - (float)this.exitThresholds.left);
                float distToEdgeY = Math.max(0.0f, velY >= 0.0f ? (float)this.exitThresholds.bottom - (float)startTranslationY : (float)startTranslationY - (float)this.exitThresholds.top);
                float durationX = Float.MAX_VALUE;
                if (absVelX != 0.0f && horizontalAllowed) {
                    durationX = distToEdgeX / absVelX;
                }
                float durationY = Float.MAX_VALUE;
                if (absVelY != 0.0f && verticalAllowed) {
                    durationY = distToEdgeY / absVelY;
                }
                if (durationX <= durationY) {
                    duration = durationX;
                    actionDirection = velX < 0.0f ? "swipeLeft" : "swipeRight";
                } else {
                    duration = durationY;
                    actionDirection = velY < 0.0f ? "swipeUp" : "swipeDown";
                }
                final float finalDeltaX = horizontalAllowed ? velX * duration : 0.0f;
                final float finalDeltaY = verticalAllowed ? velY * duration : 0.0f;
                final float startAlpha = BaseLayout.this.contentLayout.getAlpha();
                if (duration > (float)InAppMessage.this.animDurationMs) {
                    duration = InAppMessage.this.animDurationMs;
                }
                BaseLayout.this.removingOnAnimationEnd = true;
                if (BaseLayout.this.positionAnimator != null) {
                    BaseLayout.this.positionAnimator.cancel();
                }
                BaseLayout.this.setEnabled(false);
                BaseLayout.this.positionAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                BaseLayout.this.positionAnimator.setDuration((long)(duration * 1000.0f));
                BaseLayout.this.positionAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator valueAnimator) {
                        try {
                            float animValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                            WindowManager.LayoutParams params = (WindowManager.LayoutParams)BaseLayout.this.getLayoutParams();
                            params.x = (int)((float)startTranslationX + animValue * finalDeltaX);
                            int translationY = (int)((float)startTranslationY + animValue * finalDeltaY);
                            params.y = (params.gravity & 0x50) == 80 ? -translationY : translationY;
                            BaseLayout.this.windowManager.updateViewLayout((View)BaseLayout.this, (ViewGroup.LayoutParams)params);
                            BaseLayout.this.contentLayout.setAlpha(startAlpha * (1.0f - animValue));
                        }
                        catch (Exception e) {
                            Logger.log(2000, InAppMessage.TAG, null, "Unable to animate swipe, couldn't update window position");
                            valueAnimator.cancel();
                        }
                    }
                });
                BaseLayout.this.positionAnimator.addListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animator) {
                    }

                    public void onAnimationEnd(Animator animator) {
                        Action action;
                        Logger.log(4000, InAppMessage.TAG, null, "Swiped ", actionDirection);
                        BaseLayout.this.removeViewFromWindow(false);
                        if (InAppMessage.this.uiManager.currentInAppMessage() == InAppMessage.this) {
                            InAppMessage.this.uiManager.hideInAppMessage();
                        }
                        if ((action = (Action)SwipeAndTapListener.this.swipeDirectionActionMap.get(actionDirection)) != null) {
                            action.performAction();
                        }
                    }

                    public void onAnimationCancel(Animator animator) {
                    }

                    public void onAnimationRepeat(Animator animator) {
                    }
                });
                BaseLayout.this.positionAnimator.start();
                return true;
            }

            private void animateRecenter(@NonNull WindowManager.LayoutParams startParams) {
                final int startTranslationX = startParams.x;
                final int startTranslationY = startParams.y;
                if (startTranslationX == 0 && startTranslationY == 0) {
                    BaseLayout.this.setEnabled(true);
                    return;
                }
                Logger.log(3000, InAppMessage.TAG, null, "View recenter");
                if (BaseLayout.this.positionAnimator != null) {
                    BaseLayout.this.positionAnimator.cancel();
                }
                BaseLayout.this.setEnabled(false);
                BaseLayout.this.positionAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
                BaseLayout.this.positionAnimator.setDuration(InAppMessage.this.swipeResetAnimDurationMs);
                BaseLayout.this.positionAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator valueAnimator) {
                        try {
                            WindowManager.LayoutParams params = (WindowManager.LayoutParams)BaseLayout.this.getLayoutParams();
                            params.x = (int)((float)startTranslationX * ((Float)valueAnimator.getAnimatedValue()).floatValue());
                            params.y = (int)((float)startTranslationY * ((Float)valueAnimator.getAnimatedValue()).floatValue());
                            BaseLayout.this.windowManager.updateViewLayout((View)BaseLayout.this, (ViewGroup.LayoutParams)params);
                            if (!BaseLayout.this.removingOnAnimationEnd) {
                                SwipeAndTapListener.this.updateAlphaForTranslation(params);
                            }
                        }
                        catch (Exception e) {
                            Logger.log(2000, InAppMessage.TAG, null, "Unable to recenter, couldn't update window position");
                            valueAnimator.cancel();
                        }
                    }
                });
                BaseLayout.this.positionAnimator.addListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animator) {
                    }

                    public void onAnimationEnd(Animator animator) {
                        if (!BaseLayout.this.removingOnAnimationEnd) {
                            BaseLayout.this.setEnabled(true);
                        }
                    }

                    public void onAnimationCancel(Animator animator) {
                    }

                    public void onAnimationRepeat(Animator animator) {
                    }
                });
                BaseLayout.this.positionAnimator.start();
            }
        }

        private class Action {
            private boolean actionHide = true;
            private boolean actionDismiss = true;
            @Nullable
            private String actionLink = null;
            @Nullable
            private String actionTrack = null;
            private final String logPrefix;

            private Action(@NonNull JSONObject json, String logName) {
                String string;
                this.logPrefix = "Action [" + logName + "]: ";
                Boolean bool = JSONUtil.getBoolean(json, "hide");
                if (bool != null) {
                    this.actionHide = bool;
                }
                if ((bool = JSONUtil.getBoolean(json, "trackDismissal")) != null) {
                    this.actionDismiss = bool;
                }
                if ((string = JSONUtil.getString(json, "link")) != null) {
                    this.actionLink = string;
                }
                if ((string = JSONUtil.getString(json, "trackAction")) != null) {
                    this.actionTrack = string;
                }
            }

            @MainThread
            private void performAction() {
                SafetyUtil.assertOnMain();
                Logger.log(3000, InAppMessage.TAG, null, this.logPrefix, "Performing");
                if (StringUtil.isValid(this.actionLink)) {
                    InAppMessage.this.globalContext.trackClickthrough(InAppMessage.this.campaign);
                }
                if (this.actionDismiss) {
                    InAppMessage.this.globalContext.trackDismissal(InAppMessage.this.campaign);
                }
                BaseLayout.this.urlToOpenOnAnimationEnd = this.actionLink;
                if (this.actionHide) {
                    BaseLayout.this.animateRemoveAlpha();
                    if (InAppMessage.this.uiManager.currentInAppMessage() == InAppMessage.this) {
                        InAppMessage.this.uiManager.hideInAppMessage();
                    }
                }
                if (StringUtil.isValid(this.actionTrack)) {
                    InAppMessage.this.globalContext.trackAction(this.actionTrack);
                }
                if (StringUtil.isValid(this.actionLink) && (BaseLayout.this.getParent() == null || !BaseLayout.this.removingOnAnimationEnd)) {
                    NetworkingUtil.openURLFromString(BaseLayout.this.getContext(), this.actionLink);
                    BaseLayout.this.urlToOpenOnAnimationEnd = null;
                }
            }
        }
    }

    private static class VelocityTracker {
        private int lookbackMs;
        private int length;
        private long[] timesMs;
        private float[] xTotalDeltas;
        private float[] yTotalDeltas;
        private float xVelComputed;
        private float yVelComputed;

        private VelocityTracker(long startTimeMs, int maxHistory, int lookbackIntervalMs) {
            if (maxHistory <= 0) {
                maxHistory = 20;
            }
            this.lookbackMs = lookbackIntervalMs > 0 ? lookbackIntervalMs : 100;
            this.timesMs = new long[maxHistory];
            this.xTotalDeltas = new float[maxHistory];
            this.yTotalDeltas = new float[maxHistory];
            this.xVelComputed = 0.0f;
            this.yVelComputed = 0.0f;
            this.reset(startTimeMs);
        }

        private void reset(long startTimeMs) {
            this.timesMs[0] = startTimeMs;
            this.xTotalDeltas[0] = 0.0f;
            this.yTotalDeltas[0] = 0.0f;
            this.length = 1;
        }

        private void addMovement(long timeMs, float xTotalDelta, float yTotalDelta) {
            if (this.length == this.timesMs.length) {
                System.arraycopy(this.timesMs, 1, this.timesMs, 0, this.length - 1);
                System.arraycopy(this.xTotalDeltas, 1, this.xTotalDeltas, 0, this.length - 1);
                System.arraycopy(this.yTotalDeltas, 1, this.yTotalDeltas, 0, this.length - 1);
                --this.length;
            }
            this.timesMs[this.length] = timeMs;
            this.xTotalDeltas[this.length] = xTotalDelta;
            this.yTotalDeltas[this.length] = yTotalDelta;
            ++this.length;
        }

        private void computeCurrentVelocity() {
            int stopIndex;
            long latestTimeMs = this.timesMs[this.length - 1];
            if (this.length < 2 || this.timesMs[0] == latestTimeMs) {
                this.xVelComputed = 0.0f;
                this.yVelComputed = 0.0f;
                return;
            }
            for (stopIndex = this.length - 2; stopIndex >= 0 && latestTimeMs - this.timesMs[stopIndex] <= (long)this.lookbackMs; --stopIndex) {
            }
            if (this.timesMs[stopIndex + 1] != latestTimeMs) {
                ++stopIndex;
            }
            float timeDeltaSec = (float)(latestTimeMs - this.timesMs[stopIndex]) / 1000.0f;
            this.xVelComputed = (this.xTotalDeltas[this.length - 1] - this.xTotalDeltas[stopIndex]) / timeDeltaSec;
            this.yVelComputed = (this.yTotalDeltas[this.length - 1] - this.yTotalDeltas[stopIndex]) / timeDeltaSec;
        }

        private float getXVelocity() {
            return this.xVelComputed;
        }

        private float getYVelocity() {
            return this.yVelComputed;
        }
    }

    private static class MeasureStateButton
    extends Button {
        private MeasureStateButton(android.content.Context context) {
            super(context);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            Layout layout = this.getLayout();
            if (layout != null) {
                for (int line = 0; line < layout.getLineCount(); ++line) {
                    if (layout.getEllipsisCount(line) <= 0) continue;
                    this.setMeasuredDimension(this.getMeasuredWidthAndState() | 0x1000000, this.getMeasuredHeightAndState());
                    return;
                }
            }
        }
    }

    private static class MeasureStateTextView
    extends TextView {
        private MeasureStateTextView(android.content.Context context) {
            super(context);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            Layout layout = this.getLayout();
            if (layout != null) {
                for (int line = 0; line < layout.getLineCount(); ++line) {
                    if (layout.getEllipsisCount(line) <= 0) continue;
                    this.setMeasuredDimension(this.getMeasuredWidthAndState() | 0x1000000, this.getMeasuredHeightAndState());
                    return;
                }
            }
        }
    }
}

