/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.ClientConfiguration;
import com.evergage.android.Context;
import com.evergage.android.Evergage;
import com.evergage.android.Screen;
import com.evergage.android.internal.AppLifecycleManager;
import com.evergage.android.internal.CampaignDispatcher;
import com.evergage.android.internal.CampaignImpl;
import com.evergage.android.internal.Config;
import com.evergage.android.internal.ConnectivityManager;
import com.evergage.android.internal.Constants;
import com.evergage.android.internal.ContextImpl;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.EventConstants;
import com.evergage.android.internal.PushTokenManager;
import com.evergage.android.internal.QueuedEventSender;
import com.evergage.android.internal.ScreenImpl;
import com.evergage.android.internal.Sender;
import com.evergage.android.internal.UIManager;
import com.evergage.android.internal.util.DeviceUtil;
import com.evergage.android.internal.util.HostAppUtil;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.NetworkingUtil;
import com.evergage.android.internal.util.PromoteUtil;
import com.evergage.android.internal.util.SafetyUtil;
import com.evergage.android.internal.util.StringUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONObject;

final class EvergageImpl
extends Evergage {
    private AppLifecycleManager appLifecycleManager;
    private Config config;
    private UIManager uiManager;
    private ConnectivityManager connectivityManager;
    private Sender sender;
    private QueuedEventSender eventSender;
    private ContextImpl globalContext;
    private CampaignDispatcher campaignDispatcher;
    private PushTokenManager pushTokenManager;
    private String userId;
    private String accountId;
    private JSONObject attributes = new JSONObject();
    private String testExperienceId;
    private SafetyUtil.Timer clearTestExperienceIdTimer;
    private final AppLifecycleManager.Callback appLifecycleCallback;
    private final ConnectivityManager.ConnectivityCallback connectivityCallback;
    private final Sender.SuccessJsonCallback configSuccessCallback;
    private final Sender.FailureCallback configFailureCallback;
    private final Sender.SuccessJsonArrayCallback eventsSuccessCallback;
    private final Sender.FailureCallback eventsFailureCallback;
    private UUID configRequestUUID;
    private static AtomicBoolean initializeCalled = new AtomicBoolean(false);
    private static volatile boolean initialized;
    private volatile boolean started;
    private volatile boolean disabled;
    private boolean processedLaunch = false;

    @MainThread
    static void initialize() {
        if (!initializeCalled.compareAndSet(false, true)) {
            SafetyUtil.assertFail(Integer.MAX_VALUE, "Evergage.initialize() can only be called once, and should be called in Application onCreate()", null, false);
            return;
        }
        if (Looper.myLooper() != SafetyUtil.sMainLooper) {
            SafetyUtil.assertFail(Integer.MAX_VALUE, "Evergage.initialize() called from non-main thread.  Should be called in Application onCreate()", null, false);
            return;
        }
        Application application = DependencyManager.getApplication();
        if (application == null) {
            SafetyUtil.assertFail(Integer.MAX_VALUE, "Evergage cannot initialize, no Application provided", null, false);
            return;
        }
        if (Build.VERSION.SDK_INT < 14) {
            Logger.log(2000, TAG, null, "Will not initialize, Android API < 14");
            return;
        }
        Logger.log(3000, TAG, null, "Initializing, v", "1.4.0");
        initialized = true;
        DependencyManager.getAppLifecycleManager();
    }

    EvergageImpl() {
        if (!initialized) {
            if (!initializeCalled.get()) {
                SafetyUtil.assertFail(Integer.MAX_VALUE, "Evergage initialize() must called in Application onCreate() before getInstance()", null, false);
            }
            this.appLifecycleCallback = null;
            this.configSuccessCallback = null;
            this.configFailureCallback = null;
            this.eventsSuccessCallback = null;
            this.eventsFailureCallback = null;
            this.connectivityCallback = null;
        } else {
            this.appLifecycleCallback = new AppLifecycleManager.Callback(){

                @Override
                @MainThread
                public void onAppStateChange(@NonNull String newState, @NonNull String oldState) {
                    EvergageImpl.this.onAppStateChange(newState, oldState);
                }
            };
            this.configSuccessCallback = new Sender.SuccessJsonCallback(){

                @Override
                @MainThread
                public void onSendSuccessJson(@NonNull Object sender, @NonNull UUID requestUUID, @NonNull Sender.Response response, @NonNull JSONObject json) {
                    SafetyUtil.assertOnMain();
                    if (sender != EvergageImpl.this.sender || !requestUUID.equals(EvergageImpl.this.configRequestUUID)) {
                        return;
                    }
                    EvergageImpl.this.configRequestUUID = null;
                    EvergageImpl.this.processConfigResponse(response, json, null);
                }
            };
            this.configFailureCallback = new Sender.FailureCallback(){

                @Override
                @MainThread
                public void onSendFailure(@NonNull Object sender, @NonNull UUID requestUUID, @Nullable Sender.Response response, @NonNull Exception exception) {
                    SafetyUtil.assertOnMain();
                    if (sender != EvergageImpl.this.sender || !requestUUID.equals(EvergageImpl.this.configRequestUUID)) {
                        return;
                    }
                    EvergageImpl.this.configRequestUUID = null;
                    EvergageImpl.this.processConfigResponse(response, null, exception);
                }
            };
            this.eventsSuccessCallback = new Sender.SuccessJsonArrayCallback(){

                @Override
                @MainThread
                public void onSendSuccessJsonArray(@NonNull Object eventSender, @NonNull UUID requestUUID, @NonNull Sender.Response response, @NonNull JSONArray jsonArray) {
                    if (eventSender != EvergageImpl.this.eventSender) {
                        return;
                    }
                    EvergageImpl.this.handleEventResponses(jsonArray);
                }
            };
            this.eventsFailureCallback = new Sender.FailureCallback(){

                @Override
                @MainThread
                public void onSendFailure(@NonNull Object eventSender, @NonNull UUID requestUUID, @Nullable Sender.Response response, @NonNull Exception exception) {
                }
            };
            this.connectivityCallback = new ConnectivityManager.ConnectivityCallback(){

                @Override
                @MainThread
                public void onConnectivityChange(boolean isConnected) {
                    SafetyUtil.assertOnMain();
                    if (isConnected) {
                        EvergageImpl.this.startSystemsAsNecessary();
                        EvergageImpl.this.sendConfigRequestIfNecessary();
                    }
                }
            };
        }
        this.updateDependenciesAndState();
    }

    private void updateDependenciesAndState() {
        this.config = DependencyManager.getConfig();
        if (!initialized) {
            this.disabled = true;
            return;
        }
        Object value = this.config.objectForKey(Boolean.class, "disable", false);
        if (value != null) {
            this.disabled = (Boolean)value;
        }
        if ((value = this.config.objectForKey(Number.class, "logLevel", false)) != null) {
            Logger.setLogThreshold(((Number)value).intValue());
        }
        this.appLifecycleManager = DependencyManager.getAppLifecycleManager();
        this.globalContext = DependencyManager.getGlobalContext();
        this.sender = DependencyManager.getSender();
        this.connectivityManager = DependencyManager.getConnectivityManager();
        this.campaignDispatcher = DependencyManager.getCampaignDispatcher();
        this.eventSender = DependencyManager.getQueuedEventSender();
        this.pushTokenManager = DependencyManager.getPushTokenManager();
        this.uiManager = DependencyManager.getUiManager();
        this.appLifecycleManager.weakCallback = new WeakReference<AppLifecycleManager.Callback>(this.appLifecycleCallback);
        this.connectivityManager.weakCallback = new WeakReference<ConnectivityManager.ConnectivityCallback>(this.connectivityCallback);
        this.eventSender.weakSuccessCallback = new WeakReference<Sender.SuccessJsonArrayCallback>(this.eventsSuccessCallback);
        this.eventSender.weakFailureCallback = new WeakReference<Sender.FailureCallback>(this.eventsFailureCallback);
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            public void runImpl() {
                EvergageImpl.this.onConfigUpdate();
                EvergageImpl.this.processLaunchIfNecessary();
            }
        });
    }

    @Override
    public void start(@NonNull ClientConfiguration clientConfiguration) {
        JSONObject json = Config.clientConfigurationToJson(clientConfiguration);
        this.startWithConfiguration(json);
    }

    @Override
    public void start(@NonNull String accountKey, @NonNull String dataset) {
        JSONObject clientConfig = new JSONObject();
        JSONUtil.put(clientConfig, "account", accountKey);
        JSONUtil.put(clientConfig, "dataset", dataset);
        this.startWithConfiguration(clientConfig);
    }

    private void startWithConfiguration(final @NonNull JSONObject clientConfig) {
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                SafetyUtil.assertOnMain();
                if (!initialized) {
                    return;
                }
                if (EvergageImpl.this.started) {
                    Logger.log(2000, TAG, null, "Ignoring start request, already started");
                    return;
                }
                if (!EvergageImpl.this.config.clientConfigValid(clientConfig)) {
                    Logger.log(1000, TAG, null, "Cannot start, invalid client configuration: ", clientConfig.toString());
                    return;
                }
                EvergageImpl.this.started = true;
                if (EvergageImpl.this.config.clientConfigRequiresReset(clientConfig)) {
                    EvergageImpl.this.resetAndClearProperties(false);
                    EvergageImpl.this.started = true;
                }
                Logger.log(3000, TAG, null, "Starting with client configuration: ", clientConfig.toString());
                EvergageImpl.this.config.replaceConfiguration(clientConfig, 1);
                EvergageImpl.this.onConfigUpdate();
            }
        });
    }

    void stop() {
        this.stopAndClearProperties(true);
    }

    private void stopAndClearProperties(final boolean clearProperties) {
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                SafetyUtil.assertOnMain();
                Logger.log(2000, TAG, null, "Stopping");
                boolean wasStarted = EvergageImpl.this.started;
                EvergageImpl.this.started = false;
                EvergageImpl.this.stopSystemsAsNecessary();
                if (wasStarted && EvergageImpl.this.eventSender != null) {
                    EvergageImpl.this.eventSender.saveToFile();
                }
                EvergageImpl.this.campaignDispatcher.clearAllCampaignsHeld();
                EvergageImpl.this.updateTestExperienceId(null, true);
                if (clearProperties) {
                    // empty if block
                }
            }
        });
    }

    @Override
    public void reset() {
        this.resetAndClearProperties(true);
    }

    private void resetAndClearProperties(final boolean clearProperties) {
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                SafetyUtil.assertOnMain();
                EvergageImpl.this.stopAndClearProperties(clearProperties);
                Logger.log(2000, TAG, null, "Resetting");
                EvergageImpl.this.processedLaunch = false;
                EvergageImpl.this.configRequestUUID = null;
                PromoteUtil.resetPromoteWarnings();
                if (clearProperties) {
                    EvergageImpl.this.userId = null;
                    EvergageImpl.this.accountId = null;
                    EvergageImpl.this.attributes = new JSONObject();
                    Logger.setLogThresholdToDefault(false);
                }
                EvergageImpl.this.config.reset();
                if (EvergageImpl.this.appLifecycleManager != null) {
                    EvergageImpl.this.appLifecycleManager.reset();
                }
                if (EvergageImpl.this.connectivityManager != null) {
                    EvergageImpl.this.connectivityManager.reset();
                }
                if (EvergageImpl.this.sender != null) {
                    EvergageImpl.this.sender.reset();
                }
                if (EvergageImpl.this.eventSender != null) {
                    EvergageImpl.this.eventSender.reset();
                }
                if (EvergageImpl.this.uiManager != null) {
                    EvergageImpl.this.uiManager.reset();
                }
                if (EvergageImpl.this.globalContext != null) {
                    EvergageImpl.this.globalContext.reset();
                }
                if (EvergageImpl.this.pushTokenManager != null) {
                    EvergageImpl.this.pushTokenManager.reset();
                }
                if (EvergageImpl.this.campaignDispatcher != null) {
                    EvergageImpl.this.campaignDispatcher.reset();
                }
                ScreenImpl.resetAllScreens();
                EvergageImpl.this.updateDependenciesAndState();
            }
        });
    }

    @MainThread
    private void startSystemsAsNecessary() {
        SafetyUtil.assertOnMain();
        if (!initialized) {
            return;
        }
        if ("active".equals(this.appLifecycleManager.getAppState())) {
            this.connectivityManager.startMonitoring();
        }
        if (this.disabled || !this.started) {
            return;
        }
        this.trackInstallOrUpgradeAsNecessary();
        this.globalContext.startSystemsAsNecessary();
        ScreenImpl.startSystemsAllScreens();
        this.pushTokenManager.startSystemsAsNecessary();
        this.uiManager.startSystemsAsNecessary();
        if ("active".equals(this.appLifecycleManager.getAppState())) {
            if (this.config.hasEmptyLayer(3)) {
                this.sendConfigRequestIfNecessary();
            } else {
                this.eventSender.startSendingQueuedEvents();
            }
        }
    }

    @MainThread
    private void stopSystemsAsNecessary() {
        SafetyUtil.assertOnMain();
        if (!initialized) {
            return;
        }
        if ("background".equals(this.appLifecycleManager.getAppState())) {
            this.connectivityManager.stopMonitoring();
        }
        if (!this.started || this.disabled || "background".equals(this.appLifecycleManager.getAppState())) {
            this.eventSender.stopSendingQueuedEvents();
            if (this.started) {
                this.eventSender.saveToFile();
            }
        }
        if (!this.started || this.disabled) {
            this.uiManager.hideAll();
        }
        if (this.disabled) {
            this.eventSender.clear();
            this.campaignDispatcher.unregisterAll();
        }
        this.uiManager.stopSystemsAsNecessary();
        this.pushTokenManager.stopSystemsAsNecessary();
        ScreenImpl.stopSystemsAllScreens();
        this.globalContext.stopSystemsAsNecessary();
    }

    boolean isStarted() {
        return this.started;
    }

    boolean isDisabled() {
        return this.disabled;
    }

    boolean isDisabledOrNotInitialized() {
        return !initialized || this.disabled;
    }

    boolean isRunning() {
        return this.started && !this.disabled;
    }

    boolean isRunningAndNotDesignMode() {
        return this.isRunning();
    }

    @MainThread
    private void disable() {
        SafetyUtil.assertOnMain();
        if (this.disabled) {
            return;
        }
        this.disabled = true;
        Logger.log(2000, TAG, null, "Evergage is disabled.");
        this.stopSystemsAsNecessary();
    }

    @MainThread
    private void enable() {
        SafetyUtil.assertOnMain();
        if (!this.disabled) {
            return;
        }
        this.disabled = false;
        Logger.log(2000, TAG, null, "Evergage has been re-enabled. May need to re-navigate", " to screens or relaunch app for full Evergage functionality after being disabled.");
        this.startSystemsAsNecessary();
    }

    @MainThread
    private void onConfigUpdate() {
        Boolean bool;
        SafetyUtil.assertOnMain();
        Integer integer = this.config.intForKey("logLevel");
        if (integer != null) {
            Logger.setLogThreshold(integer);
        }
        if ((bool = this.config.boolForKey("disable")) != null) {
            if (bool.booleanValue()) {
                this.disable();
            } else {
                this.enable();
            }
        }
        if (this.appLifecycleManager != null) {
            this.appLifecycleManager.updateConfig();
        }
        if (this.sender != null) {
            this.sender.updateConfig();
        }
        if (this.eventSender != null) {
            this.eventSender.updateConfig();
        }
        ScreenImpl.setIgnorableClassNames(this.config.jsonArrayForKey("ignorableClasses"));
        if (this.pushTokenManager != null) {
            this.pushTokenManager.onConfigUpdate();
        }
        Boolean alwaysEnableActivity = this.config.boolForKey("enableManifestComponents");
        int enabledState = 0;
        if (alwaysEnableActivity != null && alwaysEnableActivity.booleanValue() || HostAppUtil.appIsDebugBuildOrDebuggable()) {
            enabledState = 1;
        }
        HostAppUtil.updateManifestComponents(enabledState);
        this.startSystemsAsNecessary();
    }

    @MainThread
    private void sendConfigRequestIfNecessary() {
        SafetyUtil.assertOnMain();
        if (!initialized) {
            return;
        }
        if (this.config.hasEmptyLayer(1) || !this.config.isExpired() || this.configRequestUUID != null) {
            return;
        }
        Logger.log(3000, TAG, null, "Config: update attempt");
        Long lastModified = this.config.lastModified();
        ArrayList<String> params = this.buildConfigRequestParams();
        if (params == null) {
            SafetyUtil.assertFail(1000, "Config: Need params for request", null, false);
            return;
        }
        this.configRequestUUID = this.sender.requestConfigWithParams(params, lastModified, new WeakReference<Sender.SuccessJsonCallback>(this.configSuccessCallback), new WeakReference<Sender.FailureCallback>(this.configFailureCallback));
    }

    @MainThread
    private void processConfigResponse(@Nullable Sender.Response response, @Nullable JSONObject json, @Nullable Exception error) {
        Integer statusCode = response == null ? 0 : response.code;
        if (statusCode == 304) {
            Logger.log(4000, TAG, null, "Config: not modified, setting updated timestamp only");
            this.config.setConfiguration(new JSONObject(), 3);
            return;
        }
        if (statusCode == 400 || statusCode == 404) {
            Logger.log(1000, TAG, error, "Config: not found, disabling");
            json = new JSONObject();
            JSONUtil.put(json, "disable", true);
        } else {
            String headerValueString;
            Long lastModified;
            List<String> headerValueList;
            if (error != null || response == null) {
                Logger.log(1000, TAG, error, "Config: update error, keeping existing config");
                return;
            }
            Logger.log(3000, TAG, null, "Config: update success");
            if (json == null) {
                json = new JSONObject();
            }
            List<String> list = headerValueList = response.headers == null ? null : response.headers.get("Last-Modified");
            if (headerValueList != null && !headerValueList.isEmpty() && (lastModified = NetworkingUtil.millisFromHttpDateString(headerValueString = headerValueList.get(0))) != null) {
                JSONUtil.put(json, "__lastModified", lastModified);
            }
        }
        this.config.replaceConfiguration(json, 3);
        this.onConfigUpdate();
    }

    @Override
    @Nullable
    public synchronized String getUserId() {
        return this.userId;
    }

    @Override
    public synchronized void setUserId(@Nullable String userId) {
        if ("0".equals(userId = StringUtil.trimString("userId", userId))) {
            Logger.log(1000, TAG, null, "Ignoring attempt to set userId to \"0\".");
            return;
        }
        if (!StringUtil.isValid(userId)) {
            userId = null;
            this.accountId = null;
            Logger.log(3000, TAG, null, "Cleared userId and accountId");
        }
        this.userId = userId;
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            public void runImpl() {
                EvergageImpl.this.pushTokenManager.enqueuePushTokenUpdateEvent();
            }
        });
    }

    @Override
    @Nullable
    public String getAnonymousId() {
        if (this.isDisabledOrNotInitialized()) {
            return null;
        }
        return this.config.uniqueIdentifier();
    }

    @Override
    public void setUserAttribute(@NonNull String attributeName, @Nullable String attributeValue) {
        this.setAttributeValue(attributeName, attributeValue);
    }

    @Override
    @Nullable
    public synchronized String getAccountId() {
        return this.accountId;
    }

    @Override
    public synchronized void setAccountId(@Nullable String accountId) {
        if ("0".equals(accountId = StringUtil.trimString("accountId", accountId))) {
            Logger.log(1000, TAG, null, "Ignoring attempt to set accountId to \"0\".");
            return;
        }
        if (!StringUtil.isValid(accountId)) {
            accountId = null;
            Logger.log(3000, TAG, null, "Cleared accountId");
        }
        this.accountId = accountId;
    }

    @Override
    public void setAccountAttribute(@NonNull String attributeName, @Nullable String attributeValue) {
        this.setAttributeValue(attributeName, attributeValue);
    }

    @Override
    public void setFirebaseToken(String token) {
        this.pushTokenManager.handlePushToken(token);
    }

    private void setAttributeValue(final @NonNull String attributeName, final @Nullable String attributeValue) {
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                SafetyUtil.assertOnMain();
                if (EvergageImpl.this.isDisabledOrNotInitialized()) {
                    return;
                }
                String name = StringUtil.trimString("name", attributeName);
                String value = StringUtil.trimString("value", attributeValue);
                if (!EvergageImpl.this.validateAttributeName(name)) {
                    Logger.log(1000, TAG, null, "Ignoring invalid attribute: ", name, " ", value);
                    return;
                }
                if (value == null) {
                    JSONUtil.put(EvergageImpl.this.attributes, name, JSONObject.NULL);
                    Logger.log(3000, TAG, null, "Clearing attribute ", name);
                } else {
                    value = StringUtil.truncate(name, value);
                    JSONUtil.put(EvergageImpl.this.attributes, name, value);
                    Logger.log(3000, TAG, null, "Setting attribute ", name, " to the value ", value);
                }
            }
        });
    }

    private boolean validateAttributeName(String name) {
        if (!StringUtil.isValid(name)) {
            Logger.log(1000, TAG, null, "Attribute name must be a non-empty value");
            return false;
        }
        if (EventConstants.ALL_OUTGOING.contains(name)) {
            Logger.log(1000, TAG, null, "Attribute is invalid because it uses a reserved name: ", name);
            return false;
        }
        return true;
    }

    @MainThread
    private boolean processLaunchIfNecessary() {
        SafetyUtil.assertOnMain();
        if (!initialized || this.processedLaunch) {
            return false;
        }
        if ("background".equals(this.appLifecycleManager.getAppState())) {
            return false;
        }
        this.processedLaunch = true;
        this.config.setExpired();
        this.sendConfigRequestIfNecessary();
        Boolean trackLaunch = this.config.boolForKey("trackLaunch");
        if (trackLaunch != null && trackLaunch.booleanValue()) {
            this.globalContext.trackAction("App Launch");
        }
        return true;
    }

    @MainThread
    private void trackInstallOrUpgradeAsNecessary() {
        SafetyUtil.assertOnMain();
        if (!this.isRunningAndNotDesignMode()) {
            return;
        }
        Integer appVersion = HostAppUtil.appVersionCode();
        if (appVersion == null) {
            Logger.log(2000, TAG, null, "Could not determine app version");
            return;
        }
        Integer configAppVersion = this.config.intForKey("__lastAppVersionCode");
        if (appVersion.equals(configAppVersion)) {
            return;
        }
        Long modifiedDate = HostAppUtil.appUpgradedDateInMillis();
        if (modifiedDate == null) {
            return;
        }
        Long createdDate = HostAppUtil.appInstallDateInMillis();
        if (createdDate == null) {
            return;
        }
        JSONObject config = new JSONObject();
        JSONUtil.put(config, "__lastAppVersionCode", appVersion);
        this.config.setConfiguration(config, 2);
        Boolean trackInstallUpgrade = this.config.boolForKey("trackInstallUpgrade");
        if (trackInstallUpgrade == null || !trackInstallUpgrade.booleanValue()) {
            return;
        }
        if (modifiedDate > createdDate + 1000L) {
            this.globalContext.trackAction("App Upgrade");
        } else {
            this.globalContext.trackAction("App Install");
        }
    }

    @MainThread
    private void onAppStateChange(@NonNull String newState, @NonNull String oldState) {
        SafetyUtil.assertOnMain();
        if (!initialized) {
            return;
        }
        if ("background".equals(oldState)) {
            if (!this.processLaunchIfNecessary()) {
                this.config.setExpired();
                this.sendConfigRequestIfNecessary();
            }
            if (!this.disabled) {
                Logger.log(4000, TAG, null, "Application entered foreground");
                Boolean trackFg = this.config.boolForKey("trackForeground");
                if (trackFg != null && trackFg.booleanValue()) {
                    this.globalContext.trackAction("App Foreground");
                }
            }
        }
        switch (newState) {
            case "active": {
                this.startSystemsAsNecessary();
                break;
            }
            case "inactive": {
                if (!this.isRunning()) break;
                this.stopSystemsAsNecessary();
                break;
            }
            case "background": {
                Boolean trackBg;
                if (!this.disabled && (trackBg = this.config.boolForKey("trackBackground")) != null && trackBg.booleanValue()) {
                    this.globalContext.trackAction("App Background");
                }
                this.stopSystemsAsNecessary();
                break;
            }
        }
    }

    @Override
    public boolean processIntent(@NonNull Intent intent) {
        Uri data;
        if (intent == null || (data = intent.getData()) == null || data.getScheme() == null || !data.getScheme().toLowerCase(Constants.LOCALE_POSIX).startsWith("evg")) {
            return false;
        }
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                if (!initialized) {
                    return;
                }
                if (!"test".equalsIgnoreCase(data.getHost()) || data.getPathSegments().size() != 1) {
                    String msg = "Unrecognized Uri: " + data;
                    EvergageImpl.this.uiManager.showOrReplaceAlert("Evergage Testing", msg);
                } else {
                    EvergageImpl.this.updateTestExperienceId(data.getLastPathSegment(), false);
                }
            }
        });
        return true;
    }

    @MainThread
    private void updateTestExperienceId(@Nullable String newTestExperienceId, boolean alertOnlyIfChanging) {
        long delayMillis;
        String alertMessage;
        SafetyUtil.assertOnMain();
        if (!initialized) {
            return;
        }
        newTestExperienceId = StringUtil.trimString("testId", newTestExperienceId);
        boolean allowUpdate = true;
        if (newTestExperienceId == null || "none".equals(newTestExperienceId.toLowerCase(Constants.LOCALE_POSIX))) {
            alertMessage = "Not including any test campaigns";
            newTestExperienceId = null;
        } else if ("all".equals(newTestExperienceId.toLowerCase(Constants.LOCALE_POSIX))) {
            alertMessage = "Including all test campaigns";
            newTestExperienceId = "true";
        } else {
            String validatedId = EvergageImpl.validateTestExperienceId(newTestExperienceId);
            if (validatedId != null) {
                newTestExperienceId = validatedId;
                alertMessage = "Including specific campaign experience: " + newTestExperienceId;
            } else {
                alertMessage = "Ignoring invalid campaign experience: " + newTestExperienceId;
                allowUpdate = false;
            }
        }
        if (this.disabled) {
            alertMessage = "Ignoring test campaigns, Evergage is currently disabled.";
            allowUpdate = false;
        }
        if (!alertOnlyIfChanging || newTestExperienceId != null && !newTestExperienceId.equals(this.testExperienceId) || this.testExperienceId != null && !this.testExperienceId.equals(newTestExperienceId)) {
            this.uiManager.showOrReplaceAlert("Evergage Testing", alertMessage);
        }
        if (!allowUpdate) {
            return;
        }
        this.testExperienceId = newTestExperienceId;
        if (this.clearTestExperienceIdTimer != null) {
            this.clearTestExperienceIdTimer.cancel();
        }
        this.clearTestExperienceIdTimer = null;
        if (newTestExperienceId == null) {
            return;
        }
        Long delaySec = this.config.longForKey("testExperienceTimeout");
        if (delaySec == null || (delayMillis = delaySec * 1000L) <= 0L) {
            return;
        }
        this.clearTestExperienceIdTimer = new SafetyUtil.Timer(SafetyUtil.sMainHandler, new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                SafetyUtil.assertOnMain();
                if (EvergageImpl.this.clearTestExperienceIdTimer == null) {
                    return;
                }
                EvergageImpl.this.clearTestExperienceIdTimer.cancel();
                EvergageImpl.this.clearTestExperienceIdTimer = null;
                EvergageImpl.this.testExperienceId = null;
                String msg = "No longer including any test campaigns.  Reopen URL to start again.";
                EvergageImpl.this.uiManager.showOrReplaceAlert("Evergage Testing", msg);
            }
        });
        this.clearTestExperienceIdTimer.restartWithDelay(delayMillis);
    }

    @Nullable
    private static String validateTestExperienceId(@NonNull String experienceId) {
        if ((experienceId = StringUtil.trimString("textExperienceId", experienceId)) == null || experienceId.length() != 5 || !StringUtil.onlyAlphaNumericCharsInString(experienceId)) {
            Logger.log(2000, "Testing", null, "Invalid experience id: ", experienceId);
            return null;
        }
        return experienceId;
    }

    @MainThread
    void sendAction(@NonNull String action, @NonNull String contextId, @Nullable JSONObject additionalFields) {
        SafetyUtil.assertOnMain();
        if (this.isDisabledOrNotInitialized()) {
            return;
        }
        if (!StringUtil.isValid(action) || !StringUtil.isValid(contextId)) {
            Logger.log(1000, TAG, null, "Action: Ignoring since incomplete: action ", action, " contextId ", contextId);
            return;
        }
        Logger.log(3000, "Action", null, "[", action, "] contextId [", contextId, "]");
        JSONObject event = this.buildFullEventParams();
        if (event == null) {
            return;
        }
        JSONUtil.put(event, "action", action);
        JSONUtil.put(event, ".ri", contextId);
        if (this.attributes.length() > 0) {
            JSONUtil.putAll(event, this.attributes);
            this.attributes = new JSONObject();
        }
        if (additionalFields != null) {
            JSONUtil.putAll(event, additionalFields);
        }
        this.eventSender.addEvent(event);
    }

    @MainThread
    void sendPingForItem(@NonNull String sparseItemString, long timeOnPage) {
        SafetyUtil.assertOnMain();
        if (this.isDisabledOrNotInitialized()) {
            return;
        }
        if (!StringUtil.isValid(sparseItemString) || timeOnPage <= 0L) {
            Logger.log(2000, TAG, null, "Ping: Ignoring, invalid", Long.toString(timeOnPage), "ms ", sparseItemString);
            return;
        }
        if (!this.started) {
            Logger.log(2000, TAG, null, "Ping: Ignoring, Evergage not started or in design mode", Long.toString(timeOnPage), "ms ", sparseItemString);
            return;
        }
        JSONObject event = this.buildBaseParams();
        if (event == null) {
            return;
        }
        JSONUtil.put(event, ".item", sparseItemString);
        JSONUtil.put(event, ".top", timeOnPage);
        JSONUtil.put(event, ".se", "p");
        Logger.log(3000, TAG, null, "Ping: sending ", Long.toString(timeOnPage), "ms ", sparseItemString);
        this.eventSender.addEvent(event);
    }

    @MainThread
    void sendCampaignStats(@NonNull String statsString, boolean testing) {
        SafetyUtil.assertOnMain();
        if (this.isDisabledOrNotInitialized() || !StringUtil.isValid(statsString)) {
            return;
        }
        JSONObject event = this.buildBaseParams();
        if (event == null) {
            return;
        }
        JSONUtil.put(event, ".cStat", statsString);
        JSONUtil.put(event, ".se", "m");
        if (testing) {
            JSONUtil.put(event, ".test", "true");
        }
        this.eventSender.addEvent(event);
    }

    @MainThread
    private void handleEventResponses(@NonNull JSONArray eventResponses) {
        SafetyUtil.assertOnMain();
        if (this.isDisabledOrNotInitialized()) {
            return;
        }
        if (!this.started) {
            Logger.log(4000, "Events", null, "Ignoring response, Evergage not started or in design mode");
            return;
        }
        block7: for (int index = 0; index < eventResponses.length(); ++index) {
            JSONArray campaignResponses;
            JSONObject eventResponse = JSONUtil.arrayGetJSONObject(eventResponses, index);
            if (eventResponse == null) {
                Object obj = JSONUtil.arrayGet(eventResponses, index);
                Logger.log(1000, "Events", null, "Unexpected event class: ", obj == null ? null : obj.getClass().getCanonicalName(), " in events: ", eventResponses.toString());
                continue;
            }
            String newAffinityId = JSONUtil.getString(eventResponse, "anonAffinityId");
            if (StringUtil.isValid(newAffinityId)) {
                JSONObject configUpdate = new JSONObject();
                JSONUtil.put(configUpdate, "__visitorAffinityId", newAffinityId);
                this.config.setConfiguration(configUpdate, 2);
            }
            Integer errorCode = JSONUtil.getInteger(eventResponse, "errorCode");
            JSONArray validationErrors = JSONUtil.getJSONArray(eventResponse, "validationErrors");
            if (errorCode != null && errorCode != 0) {
                String errorString;
                switch (errorCode) {
                    case 1: {
                        errorString = "missing encrypted user id parameter";
                        break;
                    }
                    case 2: {
                        errorString = "invalid encrypted user id parameter";
                        break;
                    }
                    case 3: {
                        errorString = "busy";
                        break;
                    }
                    case 4: {
                        Logger.log(3000, "Events", null, "Response contained an anonymous id correction");
                        continue block7;
                    }
                    case 5: {
                        errorString = "invalid event";
                        break;
                    }
                    default: {
                        errorString = errorCode.toString();
                    }
                }
                if (validationErrors != null) {
                    Logger.log(1000, "Events", null, "Response contained the error code [", errorString, "] with the validation errors: ", validationErrors.toString());
                } else {
                    Logger.log(1000, "Events", null, "Response contained the error code [", errorString, "]");
                }
            }
            if ((campaignResponses = JSONUtil.getJSONArray(eventResponse, "campaignResponses")) == null) continue;
            for (int i = 0; i < campaignResponses.length(); ++i) {
                JSONObject jsonCampaign = JSONUtil.arrayGetJSONObject(campaignResponses, i);
                if (jsonCampaign == null) {
                    Object obj = JSONUtil.arrayGet(campaignResponses, i);
                    Logger.log(2000, "Campaign", null, "Ignoring, found unexpected class: ", obj != null ? obj.getClass().getCanonicalName() : null);
                    continue;
                }
                CampaignImpl campaign = CampaignImpl.campaignWithJSON(jsonCampaign);
                if (campaign == null) continue;
                this.campaignDispatcher.handleCampaign(campaign);
            }
        }
    }

    private ArrayList<String> buildConfigRequestParams() {
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<String> missing = new ArrayList<String>();
        if (StringUtil.isValid("Android")) {
            params.add("Android");
        } else {
            missing.add("os name");
        }
        String bundleId = HostAppUtil.packageName();
        if (StringUtil.isValid(bundleId)) {
            params.add(bundleId);
        } else {
            missing.add("bundle id");
        }
        String bundleVersion = HostAppUtil.appVersionName();
        if (StringUtil.isValid(bundleVersion)) {
            params.add(bundleVersion);
        } else {
            missing.add("bundle version");
        }
        params.add("1.4.0");
        if (!missing.isEmpty()) {
            Logger.log(1000, TAG, null, "Missing params for config request: ", missing.toString());
        }
        return params;
    }

    @MainThread
    @Nullable
    private JSONObject buildFullEventParams() {
        SafetyUtil.assertOnMain();
        JSONObject params = this.buildBaseParams();
        if (params == null) {
            return null;
        }
        String testExpId = this.testExperienceId;
        if (StringUtil.isValid(testExpId)) {
            JSONUtil.put(params, ".testMessages", testExpId);
        }
        return params;
    }

    @MainThread
    @Nullable
    JSONObject buildBaseParams() {
        String osVersion;
        String machine;
        long currentTimeEpochMillis;
        String userId;
        SafetyUtil.assertOnMain();
        JSONObject params = new JSONObject();
        JSONUtil.put(params, ".mbv", "1.4.0");
        JSONUtil.put(params, ".on", "Android");
        String anonUserId = this.config.uniqueIdentifier();
        if (!StringUtil.isValid(anonUserId)) {
            Logger.log(1000, TAG, null, "Cannot build event, no anonId");
            return null;
        }
        JSONUtil.put(params, ".anonId", anonUserId);
        String affinityId = this.config.stringForKey("__visitorAffinityId");
        if (StringUtil.isValid(affinityId)) {
            JSONUtil.put(params, ".aaId", affinityId);
        }
        if (StringUtil.isValid(userId = this.userId)) {
            JSONUtil.put(params, "userId", userId);
        } else {
            JSONUtil.put(params, "_anon", "true");
        }
        String accountId = this.accountId;
        if (StringUtil.isValid(accountId)) {
            JSONUtil.put(params, "company", accountId);
        }
        if ((currentTimeEpochMillis = System.currentTimeMillis()) > 0L) {
            JSONUtil.put(params, "timestamp", currentTimeEpochMillis);
        }
        if (StringUtil.isValid(machine = DeviceUtil.machine())) {
            JSONUtil.put(params, ".d", machine);
        }
        if (StringUtil.isValid(osVersion = DeviceUtil.osVersion())) {
            JSONUtil.put(params, ".ov", osVersion);
        }
        String appName = HostAppUtil.packageName();
        String appVersion = HostAppUtil.appVersionName();
        if (StringUtil.isValid(appName)) {
            JSONUtil.put(params, ".an", appName);
            if (StringUtil.isValid(appVersion)) {
                JSONUtil.put(params, ".av", appVersion);
            }
        }
        return params;
    }

    @Override
    @Nullable
    public Context getGlobalContext() {
        if (this.isDisabledOrNotInitialized()) {
            return null;
        }
        return this.globalContext;
    }

    @Override
    @Nullable
    public Screen getScreenForActivity(@NonNull Activity activity) {
        return ScreenImpl.forActivity(activity);
    }
}

