/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.Evergage;
import com.evergage.android.internal.AppLifecycleManager;
import com.evergage.android.internal.CampaignDispatcher;
import com.evergage.android.internal.Config;
import com.evergage.android.internal.ConnectivityManager;
import com.evergage.android.internal.ContextImpl;
import com.evergage.android.internal.EvergageImpl;
import com.evergage.android.internal.PushTokenManager;
import com.evergage.android.internal.QueuedEventSender;
import com.evergage.android.internal.Sender;
import com.evergage.android.internal.UIManager;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.SafetyUtil;

@SuppressLint(value={"StaticFieldLeak"})
public class DependencyManager {
    private static Application application;
    private static Config config;
    private static AppLifecycleManager appLifecycleManager;
    private static ConnectivityManager connectivityManager;
    private static Sender sender;
    private static QueuedEventSender queuedEventSender;
    private static CampaignDispatcher campaignDispatcher;
    private static UIManager uiManager;
    private static PushTokenManager pushTokenManager;
    private static EvergageImpl evergage;
    private static ContextImpl globalContext;
    private static final Object LAZY_NOT_SET;

    public static synchronized void initialize(@NonNull Application application) {
        DependencyManager.setApplication(application);
        Logger.setLogThresholdToDefault(true);
        EvergageImpl.initialize();
    }

    private static synchronized void setApplication(@NonNull Application application) {
        if (!(application instanceof Application)) {
            Logger.log(Integer.MAX_VALUE, "Evergage", null, "Expected instance of Application but given: " + application);
            DependencyManager.application = null;
        } else {
            DependencyManager.application = application;
        }
    }

    @Nullable
    public static synchronized Application getApplication() {
        return application;
    }

    @Nullable
    public static synchronized Context getAppContext() {
        if (application == null) {
            return null;
        }
        return application.getApplicationContext();
    }

    private static synchronized void setConfig(@Nullable Config config) {
        DependencyManager.config = config;
    }

    @NonNull
    static synchronized Config getConfig() {
        if (config == null) {
            config = new Config();
        }
        return config;
    }

    private static synchronized void setAppLifecycleManager(@Nullable AppLifecycleManager appLifecycleManager) {
        DependencyManager.appLifecycleManager = appLifecycleManager;
    }

    @Nullable
    static synchronized AppLifecycleManager getAppLifecycleManager() {
        if (Build.VERSION.SDK_INT < 14) {
            return null;
        }
        if (appLifecycleManager == null) {
            appLifecycleManager = new AppLifecycleManager();
        }
        return appLifecycleManager;
    }

    private static synchronized void setConnectivityManager(@Nullable ConnectivityManager connectivityManager) {
        DependencyManager.connectivityManager = connectivityManager;
    }

    @NonNull
    static synchronized ConnectivityManager getConnectivityManager() {
        if (connectivityManager == null) {
            connectivityManager = new ConnectivityManager();
        }
        return connectivityManager;
    }

    static ConnectivityManager.ConnectivityCallback generateConnectivityCallback(final SafetyUtil.SafeRunnable runnable) {
        return new ConnectivityManager.ConnectivityCallback(){

            @Override
            public void onConnectivityChange(boolean isConnected) {
                runnable.run();
            }
        };
    }

    private static synchronized void setSender(@Nullable Sender sender) {
        DependencyManager.sender = sender;
    }

    @NonNull
    static synchronized Sender getSender() {
        if (sender == null) {
            sender = new Sender();
        }
        return sender;
    }

    private static synchronized void setQueuedEventSender(@Nullable QueuedEventSender queuedEventSender) {
        DependencyManager.queuedEventSender = queuedEventSender;
    }

    @NonNull
    static synchronized QueuedEventSender getQueuedEventSender() {
        if (queuedEventSender == null) {
            queuedEventSender = new QueuedEventSender();
        }
        return queuedEventSender;
    }

    private static synchronized void setCampaignDispatcher(@Nullable CampaignDispatcher dispatcher) {
        campaignDispatcher = dispatcher;
    }

    @NonNull
    static synchronized CampaignDispatcher getCampaignDispatcher() {
        if (campaignDispatcher == null) {
            campaignDispatcher = new CampaignDispatcher();
        }
        return campaignDispatcher;
    }

    private static synchronized void setUiManager(@Nullable UIManager uiManager) {
        DependencyManager.uiManager = uiManager;
    }

    @NonNull
    static synchronized UIManager getUiManager() {
        if (uiManager == null) {
            uiManager = new UIManager();
        }
        return uiManager;
    }

    private static synchronized void setPushTokenManager(@Nullable PushTokenManager pushTokenManager) {
        DependencyManager.pushTokenManager = pushTokenManager;
    }

    @NonNull
    static synchronized PushTokenManager getPushTokenManager() {
        if (pushTokenManager == null) {
            pushTokenManager = new PushTokenManager();
        }
        return pushTokenManager;
    }

    private static synchronized void setEvergage(@Nullable EvergageImpl evergage) {
        DependencyManager.evergage = evergage;
    }

    @NonNull
    public static synchronized Evergage getEvergage() {
        if (evergage == null) {
            evergage = new EvergageImpl();
        }
        return evergage;
    }

    @NonNull
    static LazyNonNull<EvergageImpl> lazyGetEvergage() {
        return new LazyNonNull<EvergageImpl>(){

            @Override
            @NonNull
            protected EvergageImpl provideOnce() {
                return (EvergageImpl)DependencyManager.getEvergage();
            }
        };
    }

    private static synchronized void setGlobalContext(@Nullable ContextImpl globalContext) {
        DependencyManager.globalContext = globalContext;
    }

    @NonNull
    static synchronized ContextImpl getGlobalContext() {
        if (globalContext == null) {
            globalContext = new ContextImpl("Global");
        }
        return globalContext;
    }

    static {
        LAZY_NOT_SET = new Object();
    }

    static abstract class LazyNullable<T> {
        private volatile Object cached = DependencyManager.access$000();

        LazyNullable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public T get() {
            if (this.cached == LAZY_NOT_SET) {
                LazyNullable lazyNullable = this;
                synchronized (lazyNullable) {
                    if (this.cached == LAZY_NOT_SET) {
                        this.cached = this.provideOnce();
                    }
                }
            }
            return (T)this.cached;
        }

        @Nullable
        protected abstract T provideOnce();
    }

    static abstract class LazyNonNull<T> {
        private volatile Object cached = DependencyManager.access$000();

        LazyNonNull() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public T get() {
            if (this.cached == LAZY_NOT_SET) {
                LazyNonNull lazyNonNull = this;
                synchronized (lazyNonNull) {
                    if (this.cached == LAZY_NOT_SET) {
                        this.cached = this.provideOnce();
                    }
                }
            }
            return (T)this.cached;
        }

        @NonNull
        protected abstract T provideOnce();
    }
}

