/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import android.content.Intent;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.Campaign;
import com.evergage.android.CampaignHandler;
import com.evergage.android.Context;
import com.evergage.android.internal.AppLifecycleManager;
import com.evergage.android.internal.CampaignDispatcher;
import com.evergage.android.internal.CampaignImpl;
import com.evergage.android.internal.Config;
import com.evergage.android.internal.Constants;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.EvergageImpl;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.PromoteUtil;
import com.evergage.android.internal.util.SafetyUtil;
import com.evergage.android.internal.util.StringUtil;
import com.evergage.android.promote.Category;
import com.evergage.android.promote.Item;
import com.evergage.android.promote.LineItem;
import com.evergage.android.promote.Order;
import com.evergage.android.promote.Review;
import com.evergage.android.promote.Tag;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

class ContextImpl
implements Context {
    private static final String TAG = "Context";
    static final String ID_GLOBAL = "Global";
    protected Config config;
    protected DependencyManager.LazyNonNull<EvergageImpl> lazyEvergage;
    @Nullable
    private AppLifecycleManager appLifecycleManager;
    protected CampaignDispatcher campaignDispatcher;
    protected final String identifier;
    private String currentViewItemPingableSparseJson;
    private long pingViewTimeStart;
    private long pingMaxDelay;
    private volatile boolean active;
    private SafetyUtil.SafeRunnable pingTimerSafeRunnable = new SafetyUtil.SafeRunnable(){

        @Override
        @MainThread
        public void runImpl() {
            SafetyUtil.assertOnMain();
            ContextImpl.this.sendAndClearPing();
            ContextImpl.this.restartOrClearPingTimer();
        }
    };
    private final SafetyUtil.WeakSafeRunnable weakSafePingTimerRunnable = new SafetyUtil.WeakSafeRunnable(this.pingTimerSafeRunnable);

    ContextImpl(@NonNull String identifier) {
        this.identifier = identifier;
        this.reset();
    }

    void reset() {
        this.pingViewTimeStart = 0L;
        SafetyUtil.sMainHandler.removeCallbacks((Runnable)this.weakSafePingTimerRunnable);
        this.setActive(false);
        this.config = DependencyManager.getConfig();
        this.lazyEvergage = DependencyManager.lazyGetEvergage();
        this.appLifecycleManager = DependencyManager.getAppLifecycleManager();
        this.campaignDispatcher = DependencyManager.getCampaignDispatcher();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setCampaignHandler(final @Nullable CampaignHandler handler, final @NonNull String target) {
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            public void runImpl() {
                ContextImpl.this.setCampaignHandler(handler, target, true);
            }
        });
    }

    @MainThread
    void setCampaignHandler(@Nullable CampaignHandler handler, @NonNull String target, boolean checkPrefix) {
        SafetyUtil.assertOnMain();
        if (this.lazyEvergage.get().isDisabledOrNotInitialized()) {
            return;
        }
        this.registerContextId();
        if (checkPrefix && target.toLowerCase(Constants.LOCALE_POSIX).startsWith("evg")) {
            Logger.log(1000, TAG, null, "[", this.identifier, "] Ignoring setCampaignHandler for target [", target, "], prefix '", "evg", "' is reserved");
            return;
        }
        this.campaignDispatcher.setHandler(handler, this.identifier, target);
    }

    @Override
    public void trackImpression(final @NonNull Campaign campaign) {
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            public void runImpl() {
                if (ContextImpl.this.lazyEvergage.get().isDisabledOrNotInitialized()) {
                    return;
                }
                JSONArray stats = CampaignImpl.statsForCampaign(campaign, "i");
                Logger.log(3000, ContextImpl.TAG, null, "[", ContextImpl.this.identifier, "] Tracking impression for campaign [", campaign.getCampaignName(), ":", campaign.getCampaignId(), "]");
                ContextImpl.this.registerContextId();
                ContextImpl.this.trackStats(stats, ((CampaignImpl)campaign).test);
            }
        });
    }

    @Override
    public void trackClickthrough(final @NonNull Campaign campaign) {
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            public void runImpl() {
                if (ContextImpl.this.lazyEvergage.get().isDisabledOrNotInitialized()) {
                    return;
                }
                if (campaign.isControlGroup()) {
                    Logger.log(1000, ContextImpl.TAG, null, "[", ContextImpl.this.identifier, "] Ignoring invalid clickthrough for user in control group on campaign [", campaign.getCampaignName(), ":", campaign.getCampaignId(), "]");
                    return;
                }
                JSONArray stats = CampaignImpl.statsForCampaign(campaign, "c");
                Logger.log(3000, ContextImpl.TAG, null, "[", ContextImpl.this.identifier, "] Tracking clickthrough for campaign [", campaign.getCampaignName(), ":", campaign.getCampaignId(), "]");
                ContextImpl.this.registerContextId();
                ContextImpl.this.trackStats(stats, ((CampaignImpl)campaign).test);
            }
        });
    }

    @Override
    public void trackDismissal(final @NonNull Campaign campaign) {
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            public void runImpl() {
                if (ContextImpl.this.lazyEvergage.get().isDisabledOrNotInitialized()) {
                    return;
                }
                if (campaign.isControlGroup()) {
                    Logger.log(1000, ContextImpl.TAG, null, "[", ContextImpl.this.identifier, "] Ignoring invalid dismissal for user in control group on campaign [", campaign.getCampaignName(), ":", campaign.getCampaignId(), "]");
                    return;
                }
                JSONArray stats = CampaignImpl.statsForCampaign(campaign, "d");
                Logger.log(3000, ContextImpl.TAG, null, "[", ContextImpl.this.identifier, "] Tracking dismissal for campaign [", campaign.getCampaignName(), ":", campaign.getCampaignId(), "]");
                ContextImpl.this.registerContextId();
                ContextImpl.this.trackStats(stats, ((CampaignImpl)campaign).test);
            }
        });
    }

    @Override
    public void trackClickthrough(final @NonNull Map<String, String> notificationData) {
        if (notificationData == null || !notificationData.containsKey("evg-eid")) {
            return;
        }
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            public void runImpl() {
                ContextImpl.this.trackNotificationClickthrough((String)notificationData.get("evg-eid"), (String)notificationData.get("evg-piks"), notificationData.containsKey("evg-t"));
                notificationData.remove("evg-eid");
            }
        });
    }

    @Override
    public void trackClickthrough(final @NonNull Intent notificationIntent) {
        if (notificationIntent == null || !notificationIntent.hasExtra("evg-eid")) {
            return;
        }
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            public void runImpl() {
                ContextImpl.this.trackNotificationClickthrough(notificationIntent.getStringExtra("evg-eid"), notificationIntent.getStringExtra("evg-piks"), notificationIntent.hasExtra("evg-t"));
                notificationIntent.removeExtra("evg-eid");
            }
        });
    }

    private void trackNotificationClickthrough(String experienceId, String promotedItemKeys, boolean testing) {
        SafetyUtil.assertOnMain();
        if (StringUtil.isValid(experienceId)) {
            JSONObject stats = CampaignImpl.statsFromDeconstructedCampaign("c", experienceId, promotedItemKeys, false);
            JSONArray statsArray = new JSONArray();
            statsArray.put((Object)stats);
            Logger.log(3000, "Notification", null, "Found ", testing ? "test" : "", " experience [", experienceId, "], tracking click");
            this.trackStats(statsArray, testing);
        }
    }

    private void trackStats(@NonNull JSONArray stats, boolean testing) {
        String statsString = stats.toString();
        Logger.log(3000, TAG, null, "[", this.identifier, "] Tracking ", testing ? "test" : "", " stats: ", statsString);
        this.registerContextId();
        this.lazyEvergage.get().sendCampaignStats(statsString, testing);
    }

    private boolean checkAppState() {
        Boolean check = this.config.boolForKey("contextChecksAppState");
        return check != null && check != false;
    }

    protected boolean allowSetActive(boolean active) {
        if (active) {
            return this.lazyEvergage.get().isRunningAndNotDesignMode() && (!this.checkAppState() || this.appLifecycleManager != null && "active".equals(this.appLifecycleManager.getAppState()));
        }
        return !this.lazyEvergage.get().isRunningAndNotDesignMode() || this.checkAppState() && (this.appLifecycleManager == null || "background".equals(this.appLifecycleManager.getAppState()));
    }

    private void setActive(boolean active) {
        if (active == this.active) {
            return;
        }
        if (active) {
            this.active = true;
            Logger.log(3000, TAG, null, "[", this.identifier, "] ACTIVE");
            this.registerContextId();
            this.campaignDispatcher.setDispatchingAllowed(true, this.identifier);
        } else {
            this.active = false;
            Logger.log(3000, TAG, null, "[", this.identifier, "] Not active");
            this.campaignDispatcher.setDispatchingAllowed(false, this.identifier);
            this.sendAndClearPing();
        }
    }

    @MainThread
    protected void startSystemsAsNecessary() {
        SafetyUtil.assertOnMain();
        if (!this.isActive() && this.allowSetActive(true)) {
            this.setActive(true);
        }
        if (!this.isActive()) {
            return;
        }
        if (!this.checkAppState() || this.appLifecycleManager != null && "active".equals(this.appLifecycleManager.getAppState())) {
            this.registerContextId();
            this.campaignDispatcher.setDispatchingAllowed(true, this.identifier);
        }
        if (this.pingViewTimeStart == 0L) {
            this.restartOrClearPingTimer();
        }
    }

    @MainThread
    protected void stopSystemsAsNecessary() {
        SafetyUtil.assertOnMain();
        if (this.isActive() && this.allowSetActive(false)) {
            this.setActive(false);
        }
        if (this.lazyEvergage.get().isDisabled()) {
            this.setCurrentViewItemPingable(null);
        }
        if (!this.isActive()) {
            return;
        }
        if (this.checkAppState() && (this.appLifecycleManager == null || !"active".equals(this.appLifecycleManager.getAppState()))) {
            this.campaignDispatcher.setDispatchingAllowed(false, this.identifier);
        }
        if (this.appLifecycleManager == null || !"active".equals(this.appLifecycleManager.getAppState())) {
            this.sendAndClearPing();
        }
    }

    @MainThread
    protected void registerContextId() {
        SafetyUtil.assertOnMain();
        if (this.lazyEvergage.get().isDisabledOrNotInitialized()) {
            return;
        }
        this.campaignDispatcher.registerContextIdIfNecessary(this.identifier);
    }

    @MainThread
    private void setCurrentViewItemPingable(@Nullable JSONObject currentViewItem) {
        SafetyUtil.assertOnMain();
        if (this.currentViewItemPingableSparseJson != null) {
            this.sendAndClearPing();
        }
        this.currentViewItemPingableSparseJson = null;
        if (currentViewItem != null && (currentViewItem = PromoteUtil.sparsifyItem(currentViewItem)) != null) {
            this.currentViewItemPingableSparseJson = currentViewItem.toString();
        }
        if (this.currentViewItemPingableSparseJson != null) {
            this.restartOrClearPingTimer();
        }
    }

    @MainThread
    private void restartOrClearPingTimer() {
        Double delay = this.config.doubleForKey("timeOnPageTimeout");
        if (delay != null) {
            delay = delay * 1000.0;
        }
        if (!this.isActive() || this.currentViewItemPingableSparseJson == null || this.appLifecycleManager == null || !"active".equals(this.appLifecycleManager.getAppState()) || delay == null || delay <= 0.0) {
            this.pingViewTimeStart = 0L;
            SafetyUtil.sMainHandler.removeCallbacks((Runnable)this.weakSafePingTimerRunnable);
        } else {
            this.pingMaxDelay = delay.longValue();
            this.pingViewTimeStart = System.currentTimeMillis();
            SafetyUtil.runAfterDelay(this.pingMaxDelay, SafetyUtil.sMainHandler, this.weakSafePingTimerRunnable);
        }
    }

    @MainThread
    private void sendAndClearPing() {
        SafetyUtil.assertOnMain();
        if (this.pingViewTimeStart != 0L && this.currentViewItemPingableSparseJson != null) {
            long timeOnPage = System.currentTimeMillis() - this.pingViewTimeStart;
            timeOnPage = Math.min(timeOnPage, this.pingMaxDelay);
            this.lazyEvergage.get().sendPingForItem(this.currentViewItemPingableSparseJson, timeOnPage);
        }
        this.pingViewTimeStart = 0L;
        SafetyUtil.sMainHandler.removeCallbacks((Runnable)this.weakSafePingTimerRunnable);
    }

    @Override
    public void viewItem(@Nullable Item item) {
        this.viewItem(item, null);
    }

    @Override
    public void viewItem(@Nullable Item item, @Nullable String actionName) {
        if (this.lazyEvergage.get().isDisabledOrNotInitialized()) {
            return;
        }
        this.viewItem("item", actionName, "View Item", item);
    }

    private void viewItem(final @NonNull String itemType, final @Nullable String actionName, final @NonNull String itemAction, final @Nullable Item item) {
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                JSONObject itemJson;
                SafetyUtil.assertOnMain();
                if (ContextImpl.this.lazyEvergage.get().isDisabledOrNotInitialized()) {
                    return;
                }
                if (item == null || (itemJson = item.toJSONObject()) == null || !PromoteUtil.itemHasRequiredStringFields(itemJson, itemType)) {
                    ContextImpl.this.setCurrentViewItemPingable(null);
                    return;
                }
                PromoteUtil.logUnknownItemFields(itemJson);
                ContextImpl.this.setCurrentViewItemPingable(itemJson);
                JSONObject itemFields = new JSONObject();
                JSONUtil.put(itemFields, ".item", itemJson.toString());
                ContextImpl.this.trackItemFields(itemFields, itemAction, actionName);
            }
        });
    }

    @Override
    public void viewItemDetail(@Nullable Item item) {
        this.viewItemDetail(item, null);
    }

    @Override
    public void viewItemDetail(@Nullable Item item, @Nullable String actionName) {
        if (this.lazyEvergage.get().isDisabledOrNotInitialized()) {
            return;
        }
        this.viewItem("item", actionName, "View Item Detail", item);
    }

    @Override
    public void viewCategory(@Nullable Category category) {
        this.viewCategory(category, null);
    }

    @Override
    public void viewCategory(@Nullable Category category, @Nullable String actionName) {
        if (this.lazyEvergage.get().isDisabledOrNotInitialized()) {
            return;
        }
        this.viewItem("category", actionName, "View Category", category);
    }

    @Override
    public void viewTag(@Nullable Tag tag) {
        this.viewTag(tag, null);
    }

    @Override
    public void viewTag(@Nullable Tag tag, @Nullable String actionName) {
        if (this.lazyEvergage.get().isDisabledOrNotInitialized()) {
            return;
        }
        this.viewItem("tag", actionName, "View Tag", tag);
    }

    @Override
    public void addToCart(final @NonNull LineItem lineItem) {
        if (this.lazyEvergage.get().isDisabledOrNotInitialized()) {
            return;
        }
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                JSONObject lineItemJson;
                SafetyUtil.assertOnMain();
                if (ContextImpl.this.lazyEvergage.get().isDisabledOrNotInitialized()) {
                    return;
                }
                if (lineItem == null || (lineItemJson = lineItem.toJSONObject()) == null || PromoteUtil.isRequiredObjectMissing(lineItemJson, "lineItem")) {
                    return;
                }
                PromoteUtil.logUnknownLineItemFields(lineItemJson);
                JSONObject sparsifiedLineItem = PromoteUtil.sparsifyLineItem(lineItemJson);
                if (sparsifiedLineItem == null) {
                    return;
                }
                JSONObject itemFields = new JSONObject();
                JSONUtil.put(itemFields, ".lineItem", sparsifiedLineItem.toString());
                ContextImpl.this.trackItemFields(itemFields, "Add To Cart", null);
            }
        });
    }

    @Override
    public void removeFromCart(final @NonNull LineItem lineItem) {
        if (this.lazyEvergage.get().isDisabledOrNotInitialized()) {
            return;
        }
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                JSONObject lineItemJson;
                SafetyUtil.assertOnMain();
                if (ContextImpl.this.lazyEvergage.get().isDisabledOrNotInitialized()) {
                    return;
                }
                if (lineItem == null || (lineItemJson = lineItem.toJSONObject()) == null || PromoteUtil.isRequiredObjectMissing(lineItemJson, "lineItem")) {
                    return;
                }
                PromoteUtil.logUnknownLineItemFields(lineItemJson);
                JSONObject sparsifiedLineItem = PromoteUtil.sparsifyLineItem(lineItemJson);
                if (sparsifiedLineItem == null) {
                    return;
                }
                JSONObject itemFields = new JSONObject();
                JSONUtil.put(itemFields, ".lineItem", sparsifiedLineItem.toString());
                ContextImpl.this.trackItemFields(itemFields, "Remove From Cart", null);
            }
        });
    }

    @Override
    public void viewCart(final @NonNull Order order) {
        if (this.lazyEvergage.get().isDisabledOrNotInitialized()) {
            return;
        }
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                JSONObject orderJson;
                SafetyUtil.assertOnMain();
                if (ContextImpl.this.lazyEvergage.get().isDisabledOrNotInitialized()) {
                    return;
                }
                if (order == null || (orderJson = order.toJSONObject()) == null || PromoteUtil.isRequiredObjectMissing(orderJson, "order")) {
                    return;
                }
                PromoteUtil.logUnknownOrderFields(orderJson);
                JSONObject sparsifiedOrder = PromoteUtil.sparsifyLineItemsInOrder(orderJson);
                if (sparsifiedOrder == null) {
                    return;
                }
                JSONObject itemFields = new JSONObject();
                JSONUtil.put(itemFields, ".order", sparsifiedOrder.toString());
                ContextImpl.this.trackItemFields(itemFields, "View Cart", null);
            }
        });
    }

    @Override
    public void purchase(final @NonNull Order order) {
        if (this.lazyEvergage.get().isDisabledOrNotInitialized()) {
            return;
        }
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                JSONObject orderJson;
                SafetyUtil.assertOnMain();
                if (ContextImpl.this.lazyEvergage.get().isDisabledOrNotInitialized()) {
                    return;
                }
                if (order == null || (orderJson = order.toJSONObject()) == null || PromoteUtil.isRequiredObjectMissing(orderJson, "order")) {
                    return;
                }
                PromoteUtil.logUnknownOrderFields(orderJson);
                JSONObject sparsifiedOrder = PromoteUtil.sparsifyLineItemsInOrder(orderJson);
                if (sparsifiedOrder == null) {
                    return;
                }
                JSONObject itemFields = new JSONObject();
                JSONUtil.put(itemFields, ".order", sparsifiedOrder.toString());
                ContextImpl.this.trackItemFields(itemFields, "Purchase", null);
            }
        });
    }

    @Override
    public void review(@NonNull Item item) {
        this.review(item, null);
    }

    @Override
    public void review(final @NonNull Item item, final @Nullable Review reviewDetails) {
        if (this.lazyEvergage.get().isDisabledOrNotInitialized()) {
            return;
        }
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                JSONObject reviewDetailsJson;
                JSONObject itemJson;
                SafetyUtil.assertOnMain();
                if (ContextImpl.this.lazyEvergage.get().isDisabledOrNotInitialized()) {
                    return;
                }
                if (item == null || (itemJson = item.toJSONObject()) == null || PromoteUtil.isRequiredObjectMissing(itemJson, "item")) {
                    return;
                }
                JSONObject itemFields = new JSONObject();
                if (reviewDetails != null && (reviewDetailsJson = reviewDetails.toJSONObject()) != null) {
                    PromoteUtil.logUnknownReviewFields(reviewDetailsJson);
                    JSONUtil.put(itemFields, ".review", reviewDetailsJson.toString());
                }
                PromoteUtil.logUnknownItemFields(itemJson);
                JSONObject sparsifiedItem = PromoteUtil.sparsifyItem(itemJson);
                if (sparsifiedItem == null) {
                    return;
                }
                JSONUtil.put(itemFields, ".item", sparsifiedItem.toString());
                ContextImpl.this.trackItemFields(itemFields, "Review", null);
            }
        });
    }

    @Override
    public void share(@NonNull Item item) {
        if (this.lazyEvergage.get().isDisabledOrNotInitialized()) {
            return;
        }
        this.trackItemInteraction(item, "Share");
    }

    @Override
    public void comment(@NonNull Item item) {
        if (this.lazyEvergage.get().isDisabledOrNotInitialized()) {
            return;
        }
        this.trackItemInteraction(item, "Comment");
    }

    @Override
    public void favorite(@NonNull Item item) {
        if (this.lazyEvergage.get().isDisabledOrNotInitialized()) {
            return;
        }
        this.trackItemInteraction(item, "Favorite");
    }

    private void trackItemInteraction(final @Nullable Item item, final String itemAction) {
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                JSONObject itemJson;
                SafetyUtil.assertOnMain();
                if (ContextImpl.this.lazyEvergage.get().isDisabledOrNotInitialized()) {
                    return;
                }
                if (item == null || (itemJson = item.toJSONObject()) == null || PromoteUtil.isRequiredObjectMissing(itemJson, "item")) {
                    return;
                }
                PromoteUtil.logUnknownItemFields(itemJson);
                JSONObject sparsifiedItem = PromoteUtil.sparsifyItem(itemJson);
                if (sparsifiedItem == null) {
                    return;
                }
                JSONObject itemFields = new JSONObject();
                JSONUtil.put(itemFields, ".item", sparsifiedItem.toString());
                ContextImpl.this.trackItemFields(itemFields, itemAction, null);
            }
        });
    }

    private void trackItemFields(@NonNull JSONObject itemFields, @NonNull String itemAction, @Nullable String actionName) {
        this.registerContextId();
        if (StringUtil.isValid(actionName) && !actionName.equals(itemAction)) {
            JSONUtil.put(itemFields, ".itemAction", itemAction);
            this.lazyEvergage.get().sendAction(actionName, this.identifier, itemFields);
        } else {
            this.lazyEvergage.get().sendAction(itemAction, this.identifier, itemFields);
        }
    }

    @Override
    public void trackAction(final @NonNull String action) {
        SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

            @Override
            @MainThread
            public void runImpl() {
                SafetyUtil.assertOnMain();
                if (ContextImpl.this.lazyEvergage.get().isDisabledOrNotInitialized()) {
                    return;
                }
                ContextImpl.this.registerContextId();
                ContextImpl.this.lazyEvergage.get().sendAction(action, ContextImpl.this.identifier, null);
            }
        });
    }
}

