/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.SafetyUtil;
import java.lang.ref.WeakReference;

class ConnectivityManager {
    private static final String TAG = "ConnectivityManager";
    private Context appContext;
    private android.net.ConnectivityManager androidConnMgr;
    private BroadcastReceiver receiver;
    volatile WeakReference<ConnectivityCallback> weakCallback;
    private volatile WeakReference<Runnable> postCallbackHook;
    private volatile boolean connected;

    ConnectivityManager() {
        this.reset();
    }

    void reset() {
        this.stopMonitoring();
        this.weakCallback = null;
        this.appContext = DependencyManager.getAppContext();
        this.androidConnMgr = this.appContext == null ? null : (android.net.ConnectivityManager)this.appContext.getSystemService("connectivity");
    }

    @MainThread
    private void updateState(@Nullable android.net.ConnectivityManager cm) {
        Runnable hook;
        ConnectivityCallback strongCallback;
        NetworkInfo activeNetworkInfo;
        SafetyUtil.assertOnMain();
        boolean wasConnected = this.connected;
        this.connected = !this.isMonitoring() || cm == null || (activeNetworkInfo = cm.getActiveNetworkInfo()) == null ? false : activeNetworkInfo.isConnected();
        if (this.connected == wasConnected) {
            return;
        }
        if (this.weakCallback != null && (strongCallback = (ConnectivityCallback)this.weakCallback.get()) != null) {
            strongCallback.onConnectivityChange(this.connected);
        }
        if (this.postCallbackHook != null && (hook = (Runnable)this.postCallbackHook.get()) != null) {
            hook.run();
        }
    }

    @MainThread
    void startMonitoring() {
        SafetyUtil.assertOnMain();
        if (this.appContext == null || this.isMonitoring()) {
            return;
        }
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.receiver = new Receiver(new WeakReference<ConnectivityManager>(this));
        this.appContext.registerReceiver(this.receiver, filter);
        this.updateState(this.androidConnMgr);
    }

    void stopMonitoring() {
        if (this.appContext == null || !this.isMonitoring()) {
            return;
        }
        this.appContext.unregisterReceiver(this.receiver);
        this.receiver = null;
        this.updateState(null);
    }

    boolean isMonitoring() {
        return this.receiver != null;
    }

    boolean isConnected() {
        return this.connected;
    }

    static interface ConnectivityCallback {
        public void onConnectivityChange(boolean var1);
    }

    static class Receiver
    extends BroadcastReceiver {
        private final WeakReference<ConnectivityManager> weakReference;

        Receiver(@NonNull WeakReference<ConnectivityManager> weakReference) {
            this.weakReference = weakReference;
        }

        @MainThread
        public void onReceive(Context context, Intent intent) {
            SafetyUtil.assertOnMain();
            ConnectivityManager strongReference = (ConnectivityManager)this.weakReference.get();
            if (strongReference == null) {
                Logger.log(2000, ConnectivityManager.TAG, null, "Unexpected onReceive, will unregisterReceiver");
                context.unregisterReceiver((BroadcastReceiver)this);
                return;
            }
            if (!"android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                return;
            }
            strongReference.updateState(strongReference.androidConnMgr);
        }
    }
}

